// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: SaveImagePropertiesDialog.java,v $
// History:	       Revision 1.2  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.1  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.3  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.2  2004/11/02 20:53:53  rammi
// History:	       Added keyboard shortcuts etc via actions
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import de.caff.gimmix.I18n;
import de.caff.gimmix.ResourcedAction;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Dialog for print properties.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.2 $
 */
public class SaveImagePropertiesDialog
        extends JDialog
{
  /** I18n resource key for dialog title. */
  public static final String RESOURCE_TITLE = "SAVEIMG_SETUP:title";
  /** I18n key for save button. */
  public static final String RESOURCE_BUTTON_TEXT_OKAY = "SAVEIMG_SETUP:buttonTextOk";
  /** I18n key for cancel button. */
  public static final String RESOURCE_BUTTON_TEXT_CANCEL = "SAVEIMG_SETUP:buttonTextCancel";

  /** The save image properties to change. */
  private MazeSaveImageProperties saveImageProperties;

  /**
   *  Constructor.
   *  @param owner          frame which owns this dialog
   *  @param systemAccess   access to underlying operation system
   */
  public SaveImagePropertiesDialog(Frame owner, DataStorage systemAccess)
  {
    super(owner, I18n.getString(RESOURCE_TITLE));

    saveImageProperties = MazeSaveImageProperties.getMazeSaveImageProperties(systemAccess);

    getContentPane().setLayout(new BorderLayout());
    final PropertySetterPanel psp = new PropertySetterPanel(saveImageProperties.getPropertyInformations());
    psp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    getContentPane().add(psp,
                         BorderLayout.CENTER);


    Box buttonBox = Box.createHorizontalBox();
    getContentPane().add(buttonBox, BorderLayout.SOUTH);
    JButton saveButton   = new JButton(new ResourcedAction(RESOURCE_BUTTON_TEXT_OKAY) {
      public void actionPerformed(ActionEvent e)
      {
        close();
      }
      @Override
      protected Object clone() throws CloneNotSupportedException
      {
        throw new CloneNotSupportedException();
      }
    });
    JButton cancelButton = new JButton(new ResourcedAction(RESOURCE_BUTTON_TEXT_CANCEL) {
      public void actionPerformed(ActionEvent e)
      {
        canceled();
      }
      @Override
      protected Object clone() throws CloneNotSupportedException
      {
        throw new CloneNotSupportedException();
      }
    });
    buttonBox.add(Box.createHorizontalGlue());
    buttonBox.add(saveButton);
    buttonBox.add(cancelButton);
    //buttonBox.add(Box.createHorizontalGlue());
    buttonBox.setBorder(BorderFactory.createEmptyBorder(12, 4, 12, 4));

    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    addWindowListener(new WindowAdapter()
    {
      @Override public void windowClosing(WindowEvent e)
      {
        canceled();
      }
    });

    pack();
  }

  /**
   * Called when dialog is canceled.
   */
  private void canceled()
  {
    saveImageProperties = null;
    close();
  }

  /**
   * Called when dialog is closed.
   */
  private void close()
  {
    setVisible(false);
    dispose();
  }

  /**
   *  Get the properties after the dialog is closed.
   *  @return properties or <code>null</code> if the dialog was canceled
   */
  public MazeSaveImageProperties getSaveImageProperties()
  {
    return saveImageProperties;
  }
}