// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 19:15:39 $
//
// History:	       $Log: PropertySetterPanel.java,v $
// History:	       Revision 1.4  2012/06/07 19:15:39  rammi
// History:	       Removed properties dialog from SVG save
// History:
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;


import de.caff.gimmix.I18n;

import javax.swing.*;
import java.awt.*;
import java.util.Collection;

/**
 * Panel to display various properties and their setters.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.4 $
 */
public class PropertySetterPanel
        extends JPanel
{
  /**
   *  Constructor.
   */
  protected PropertySetterPanel()
  {
    super(new GridBagLayout());

  }

  /**
   * Constructor.
   * @param setters setters to display
   */
  public PropertySetterPanel(Collection<PropertyInformation> setters)
  {
    this();
    initialize(setters);
  }

  /**
   * Initialize this panel.
   * @param setters setters used for initialization
   */
  protected void initialize(Collection<PropertyInformation> setters)
  {
    GridBagConstraints gbc = new GridBagConstraints();

    gbc.insets = new Insets(1, 4, 1, 4);
    gbc.weighty = 0.0;

    for (PropertyInformation information: setters) {
      gbc.gridwidth = GridBagConstraints.RELATIVE;
      gbc.anchor    = GridBagConstraints.EAST;
      gbc.fill      = GridBagConstraints.NONE;
      String name = I18n.getString(information.getName());
      if (!name.endsWith(":")) {
        name += ":";
      }
      JLabel label = new JLabel(name, JLabel.RIGHT);
      add(label, gbc);

      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.anchor    = GridBagConstraints.WEST;
      gbc.fill      = GridBagConstraints.HORIZONTAL;
      add(information.getSetterComponent(), gbc);
    }
  }
}
