// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: PropertyInformation.java,v $
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.2  2004/10/25 14:54:57  rammi
// History:	       Javadoc changes
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import javax.swing.*;

/**
 *  Information about a property.
 *
 *  A property can be any property which can be any information which can be displayed to the user
 *  and posibly be set by the user.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.4 $
 */
public interface PropertyInformation
{
  /** The suffix used for short descritpions. */
  public static final String SHORT_DESCRIPTION_SUFFIX = "-SHORT";

  /**
   *  Get the name of the property.
   *  @return property value
   */
  public String getName();

  /**
   *  Get a localized description of the property with the current default locale.
   *  @return localized description
   */
  public String getLocalizedDescription();

  /**
   *  Get a short localized description of the property with the current default locale.
   *  @return localized short description or the standard localized description if no
   *          short description is defined
   *  @see #getLocalizedDescription()
   */
  public String getLocalizedShortDescription();

  /**
   *  Get the current value of property.
   *  @return property value
   */
  public Object getPropertyValue();

  /**
   *  A component to set the property.
   *  @return setter component
   */
  public JComponent getSetterComponent();

  /**
   *  Forget changed data in the property setter.
   */
  public void forget();

  /**
   *  Is the setter component just for display?
   *  @return the answer
   */
  public boolean isInformational();
}
