// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: ProgressShower.java,v $
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.2  2005/04/19 22:15:14  rammi
// History:	       Fixed some Thread problems
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.4 $
 */
public interface ProgressShower
{
  /**
   *  Start the action.
   *  @param note      note to display with the progress
   *  @param maxValue  maximum value
   */
  public void start(String note, int maxValue);

  /**
   *  Set the current progress.
   *  @param value  current progress
   *  @return <code>true</code>: user requested an abort of the action,
   *          <code>false</code>: no abort requested, go on
   */
  public boolean setProgress(int value);

  /**
   *  End the action.
   */
  public void end();
}
