// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 19:15:39 $
//
// History:	       $Log: PrintPropertiesDialog.java,v $
// History:	       Revision 1.5  2012/06/07 19:15:39  rammi
// History:	       Removed properties dialog from SVG save
// History:
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.2  2004/11/02 20:53:53  rammi
// History:	       Added keyboard shortcuts etc via actions
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import de.caff.gimmix.I18n;
import de.caff.gimmix.ResourcedAction;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Dialog for print properties.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.5 $
 */
public class PrintPropertiesDialog
        extends JDialog
{
  /** I18n resource key for dialog title. */
  public static final String RESOURCE_TITLE = "PRINT_SETUP:title";
  /** I18n key for save button. */
  public static final String RESOURCE_BUTTON_TEXT_SAVE   = "PRINT_SETUP:buttonTextSave";
  /** I18n key for cancel button. */
  public static final String RESOURCE_BUTTON_TEXT_CANCEL = "PRINT_SETUP:buttonTextCancel";

  /** Old data. */
  private final DataStorage previousData = new TemporaryDataStorage();
  /** The print properties to change. */
  private final MazePrintProperties printProperties;
  /** The properties returned on success. */
  private MazePrintProperties returnProperties;

  /**
   *  Constructor.
   *  @param owner          frame which owns this dialog
   *  @param printProperties print properties to set
   */
  public PrintPropertiesDialog(Frame owner, MazePrintProperties printProperties)
  {
    super(owner, I18n.getString(RESOURCE_TITLE));
    this.printProperties = printProperties;
    printProperties.storePersistentData(previousData);

    getContentPane().setLayout(new BorderLayout());
    final PropertySetterPanel psp = new PropertySetterPanel(printProperties.getPropertyInformations());
    psp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    getContentPane().add(psp,
                         BorderLayout.CENTER);


    Box buttonBox = Box.createHorizontalBox();
    getContentPane().add(buttonBox, BorderLayout.SOUTH);
    JButton saveButton   = new JButton(new ResourcedAction(RESOURCE_BUTTON_TEXT_SAVE) {
      public void actionPerformed(ActionEvent e)
      {
        close();
      }
      @Override
      protected Object clone() throws CloneNotSupportedException
      {
        throw new CloneNotSupportedException();
      }
    });
    JButton cancelButton = new JButton(new ResourcedAction(RESOURCE_BUTTON_TEXT_CANCEL) {
      public void actionPerformed(ActionEvent e)
      {
        canceled();
      }
      @Override
      protected Object clone() throws CloneNotSupportedException
      {
        throw new CloneNotSupportedException();
      }
    });
    buttonBox.add(Box.createHorizontalGlue());
    buttonBox.add(saveButton);
    buttonBox.add(cancelButton);
    //buttonBox.add(Box.createHorizontalGlue());
    buttonBox.setBorder(BorderFactory.createEmptyBorder(12, 4, 12, 4));

    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    addWindowListener(new WindowAdapter()
    {
      @Override public void windowClosing(WindowEvent e)
      {
        canceled();
      }
    });

    pack();

    returnProperties = printProperties;
  }

  /**
   * Get the print properties.
   * @return print properties
   */
  public MazePrintProperties getPrintProperties()
  {
    return returnProperties;
  }

  /**
   * Called when dialog is canceled.
   */
  private void canceled()
  {
    returnProperties = null;
    reset();
    close();
  }

  /**
   * Called when dialog is closed.
   */
  private void close()
  {
    setVisible(false);
    dispose();
  }

  /**
   * Reset.
   */
  private void reset()
  {
    printProperties.overwriteFromPersistentData(previousData);
  }
}
