// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: NullSystemAccess.java,v $
// History:	       Revision 1.5  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.4  2009/09/24 17:32:20  rammi
// History:	       Finetuning dialog placement
// History:
// History:	       Revision 1.3  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import javax.swing.*;
import java.awt.print.Printable;
import java.io.IOException;

/**
 *  A minimalist system access which does not actually access the system.
 *  Persistent data is only stored for the given session.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.5 $
 */
class NullSystemAccess
        extends TemporaryDataStorage
        implements SystemAccess
{

  /**
   * Print the given printable.
   *
   * @param printable printable to be printed
   * @return <code>true</code>: printing was successful,
   *         <code>false</code>: printing failed or was canceled
   */
  public boolean print(Printable printable)
  {
    return false;
  }

  /**
   * Get the contents of a user selected file.
   *
   * @param filetype type of file to be used
   * @return byte array or <code>null</code> if the user canceled the operation
   * @throws java.io.IOException on errors during file access
   */
  public byte[] getUserFileContent(FileType filetype) throws IOException
  {
    return null;
  }

  /**
   * Save a byte array into a user selected file.
   *
   * @param content  the content of the file
   * @param filetype type of file to be used
   * @return <code>true</code> if the user saved the file, <code>false</code> otherwise
   * @throws java.io.IOException on errors during file access
   */
  public boolean saveUserFileContent(byte[] content, FileType filetype) throws IOException
  {
    return false;
  }

  /**
   * Sets the main frame of the application.
   * This is useful for centering dialogs.
   *
   * @param frame application's main frame
   */
  public void setMainFrame(JFrame frame)
  {
  }
}
