// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazeSaveImagePropertiesProvider.java,v $
// History:	       Revision 1.2  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.1  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

/**
 * Provider for informations on how to print a maze.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.2 $
 */
public interface MazeSaveImagePropertiesProvider
        extends MazePaintPropertiesProvider
{
  /** I18n resource key for "extent" */
  public static final String RESOURCE_EXTENT         = "MAZE_PRINT:extent";

  /**
   *  Get the image extent.
   *  The extent describes the longer side of the image.
   *  @return image extent
   */
  int getExtent();

}