// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazeResourceBundle_de.java,v $
// History:	       Revision 1.10  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.9  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.8  2006/12/19 18:00:38  rammi
// History:	       Documentation improvements
// History:
// History:	       Revision 1.7  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.6  2005/04/19 22:15:14  rammi
// History:	       Fixed some Thread problems
// History:	
// History:	       Revision 1.5  2005/04/19 20:00:45  rammi
// History:	       no message
// History:	
// History:	       Revision 1.4  2004/11/02 20:53:53  rammi
// History:	       Added keyboard shortcuts etc via actions
// History:	
// History:	       Revision 1.3  2004/11/02 14:13:08  rammi
// History:	       Added keyboard shortcuts for the menus
// History:	
// History:	       Revision 1.2  2004/10/31 15:05:57  rammi
// History:	       Added octogonal maze
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import java.util.ListResourceBundle;

import static de.caff.gimmix.ResourcedAction.*;
import static de.caff.maze.MazeResourceBundle.TITLE;

/**
 * I18n resource bundle for German language.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.10 $
 */
public class MazeResourceBundle_de
        extends ListResourceBundle
{
  private final Object[][] inhalte = {
    // PROPERTIES
    { AbstractBasicMaze.PROPERTY_MAZE,                   "Labyrinth" },
    { AbstractBasicMaze.PROPERTY_WAY,                    "Lsungsweg" },
    { AbstractBasicMaze.PROPERTY_WAY_POINTS,             "Wegpunkte" },
    { AbstractBasicMaze.PROPERTY_SEED,                   "Zufallssaat" },
    { AbstractBasicMaze.PROPERTY_NUMBER_CELLS,           "Anzahl Zellen" },
    { AbstractBasicMaze.PROPERTY_SOLUTION_LENGTH,        "Lsungslnge" },
    { AbstractBasicMaze.PROPERTY_CREATION_TIME,          "Erzeugungszeit [ms]" },

    { MazePaintProperties.PROPERTY_BACKGROUND_PAINT,     "Hintergrundfarbe" },
    { MazePaintProperties.PROPERTY_CELL_BORDER_PAINT,    "Zellenrandfarbe" },
    { MazePaintProperties.PROPERTY_INNER_BORDER_PAINT,   "Innenrnderfarbe" },
    { MazePaintProperties.PROPERTY_OUTER_BORDER_PAINT,   "Auenrandfarbe" },
    { MazePaintProperties.PROPERTY_SHOWING_CELL_BORDERS, "Zeige Zellrnder" },
    { MazePaintProperties.PROPERTY_SHOWING_SOLUTION,     "Zeige Lsung" },
    { MazePaintProperties.PROPERTY_SOLUTION_PAINT,       "Lsungsfarbe" },
    { MazePaintProperties.PROPERTY_WAY_START_PAINT,      "Startzellenfarbe" },
    { MazePaintProperties.PROPERTY_WAY_END_PAINT,        "Endzellenfarbe" },

    { MazePrintProperties.PROPERTY_PRINT_INFO,           "Zeige Info" },
    { MazePrintProperties.PROPERTY_BLOW_UP_FACTOR,       "Drucken auf" },
    { MazePrintProperties.RESOURCE_PAGE,                 "%0 Seite" },
    { MazePrintProperties.RESOURCE_PAGES,                "%0 Seiten" },

    { MazeSaveImageProperties.PROPERTY_EXTENT,           "Bildgre (Lnge der lngeren Seite)" },

    { CircularMaze.PROPERTY_INNER_RADIUS,                "Radius Mittelzelle (positiv) oder -loch (negativ)" },
    { CircularMaze.PROPERTY_INNER_RADIUS+
      PropertyInformation.SHORT_DESCRIPTION_SUFFIX,      "Zentralradius" },
    { CircularMaze.PROPERTY_NR_INNERMOST_RING,           "Anzahl Zellen im innersten Ring" },
    { CircularMaze.PROPERTY_NR_INNERMOST_RING+
      PropertyInformation.SHORT_DESCRIPTION_SUFFIX,      "Innenringzellen" },
    { CircularMaze.PROPERTY_NR_RINGS,                    "Anzahl Ringe" },

    { HexagonalMaze.PROPERTY_HORIZONTAL_CELLS,           "Anzahl Zellen in jeder Zeile" },
    { HexagonalMaze.PROPERTY_VERTICAL_CELLS,             "Anzahl Zeilen" },

    { OctogonalMaze.PROPERTY_HORIZONTAL_CELLS,           "Anzahl Spalten" },
    { OctogonalMaze.PROPERTY_VERTICAL_CELLS,             "Anzahl Zeilen" },

    { RectangularMaze.PROPERTY_HORIZONTAL_CELLS,         "Anzahl Spalten" },
    { RectangularMaze.PROPERTY_VERTICAL_CELLS,           "Anzahl Zeilen" },

    { DiamondMaze.PROPERTY_HORIZONTAL_CELLS,             "Anzahl Spalten" },
    { DiamondMaze.PROPERTY_VERTICAL_CELLS,               "Anzahl Zeilen" },

    { TriangularMaze.PROPERTY_SIZE,                      "Gre (Anzahl Kantenzellen)" },

    // TYPES
    { CircularMaze.MAZE_TYPE,                            "Kreisfrmiges Labyrinth"    },
    { HexagonalMaze.MAZE_TYPE,                           "Hexagonales Labyrinth"   },
    { OctogonalMaze.MAZE_TYPE,                           "Oktogonales Labyrinth"   },
    { RectangularMaze.MAZE_TYPE,                         "Rechteckiges Labyrinth" },
    { TriangularMaze.MAZE_TYPE,                          "Dreieckiges Labyrinth"  },
    { DiamondMaze.MAZE_TYPE,                             "Rautenfrmiges Labyrinth" },

    // GENERAL GUI
    { MazeFrame.RESOURCE_TITLE,                          "irrGardener" },

    { MazeFrame.RESOURCE_MENU_FILE,                      "Datei" },
    { MazeFrame.RESOURCE_MENU_FILE+MNEMO,                "D" },

    { MazeFrame.RESOURCE_MENUITEM_OPEN,                  "Labyrinth ffnen..." },
    { MazeFrame.RESOURCE_MENUITEM_OPEN+MNEMO,            "" },
    { MazeFrame.RESOURCE_MENUITEM_OPEN+ACCEL,            "ctrl O" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE,                  "Labyrinth speichern..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE+MNEMO,            "s" },
    { MazeFrame.RESOURCE_MENUITEM_SAVE+ACCEL,            "ctrl S" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE,            "Als Bild speichern..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE+MNEMO,      "B" },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE+ACCEL,      "ctrl I" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_DXF,              "Als DXF speichern..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_DXF+MNEMO,        "D" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_SVG,              "Als SVG speichern..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_SVG+MNEMO,        "V" },

    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP,           "Druckeinstellung..." },
    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP+MNEMO,     "e" },
    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP+ACCEL,     "ctrl T" },

    { MazeFrame.RESOURCE_MENUITEM_PRINT,                 "Labyrinth drucken..." },
    { MazeFrame.RESOURCE_MENUITEM_PRINT+MNEMO,           "d" },
    { MazeFrame.RESOURCE_MENUITEM_PRINT+ACCEL,           "ctrl P" },

    { MazeFrame.RESOURCE_MENUITEM_EXIT,                  "Beenden" },
    { MazeFrame.RESOURCE_MENUITEM_EXIT+MNEMO,            "B" },
    { MazeFrame.RESOURCE_MENUITEM_EXIT+ACCEL,            "ctrl X" },

    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE,      "Erzeugen" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+TTT,  "Erzeugt ein neues Labyrinth mit den angegebenen Daten" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+MNEMO,"E" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+ACCEL,"ctrl ENTER" },

    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET,       "Rcksetzen" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+TTT,   "Setzt die genderten Daten zurck" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+MNEMO, "R" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+ACCEL, "ctrl ESC" },

    { MultiMazeControlPanel.RESOURCE_PRINT_ERROR,        "Fehler beim Drucken: %0" },
    { MultiMazeControlPanel.RESOURCE_PRINT_ERROR+TITLE,  "Druckfehler" },
    { ApplicationSystemAccess.RESOURCE_MAZE_FILTER_DESCRIPTION, "Labyrinthdateien" },
    { MazeCanvas.RESOURCE_BUTTON_ABORT,                  "Abbrechen" },

    // PRINT SETUP
    { PrintPropertiesDialog.RESOURCE_TITLE,              "Druckeinstellungen" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_SAVE,   "Speichern" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_SAVE+MNEMO,   "S" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL, "Abbrechen" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL+MNEMO, "A" },

    // SAVE IMAGE SETUP
    { SaveImagePropertiesDialog.RESOURCE_TITLE,          "Bild-Speicher-Einstellungen" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_OKAY, "Okay" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_OKAY+MNEMO, "O" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL, "Abbruch" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL+MNEMO, "A" },

    // ERRORS
    { MazeFrame.RESOURCE_ERROR_FILE_READ,                "Kann Datei nicht lesen!\n%0" },
    { MazeFrame.RESOURCE_ERROR_FILE_WRITE,               "Kann Datei nicht schreiben!\n%0" },
    { MazeFrame.RESOURCE_ERROR_FS_ACCESS,                "Kann nicht auf das lokale Dateisystem zugreifen!" },
          
    // OTHER
    { MazeTool.MESSAGE_CREATING,                         "Erzeuge Labyrinth..." },
    { MazeCanvas.TITLE_CREATION_EXCEPTION,               "Fehler" },
    { MazeCanvas.MESSAGE_CREATION_EXCEPTION,             "Fehler bei der Labyrintherzeugung: %1 (%2)" },

    { SystemAccess.MAZE_FILE_TYPE.resType,               "irrGardener-Labyinth-Dateien" },
    { SystemAccess.IMAGE_FILE_TYPE.resType,              "PNG-Bilddateien" },
    { DxfMazePainter.FILE_TYPE.resType,                  "DXF-Dateien" },
    { SvgMazePainter.FILE_TYPE.resType,                  "SVG-Dateien" },

  };

  protected Object[][] getContents()
  {
    return inhalte;
  }

}
