// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazeResourceBundle.java,v $
// History:	       Revision 1.10  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.9  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.8  2006/12/19 18:00:38  rammi
// History:	       Documentation improvements
// History:
// History:	       Revision 1.7  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.6  2005/04/19 22:15:14  rammi
// History:	       Fixed some Thread problems
// History:	
// History:	       Revision 1.5  2005/04/19 20:00:45  rammi
// History:	       no message
// History:	
// History:	       Revision 1.4  2004/11/02 20:53:53  rammi
// History:	       Added keyboard shortcuts etc via actions
// History:	
// History:	       Revision 1.3  2004/11/02 14:13:08  rammi
// History:	       Added keyboard shortcuts for the menus
// History:	
// History:	       Revision 1.2  2004/10/31 15:05:57  rammi
// History:	       Added octogonal maze
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import java.util.ListResourceBundle;

import static de.caff.gimmix.ResourcedAction.*;

/**
 * I18n default resource bundle: English.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.10 $
 */
public class MazeResourceBundle
        extends ListResourceBundle
{

  private final Object[][] contents = {
    // PROPERTIES
    { AbstractBasicMaze.PROPERTY_MAZE,                   "Maze" },
    { AbstractBasicMaze.PROPERTY_WAY,                    "Solution way" },
    { AbstractBasicMaze.PROPERTY_WAY_POINTS,             "Way points" },
    { AbstractBasicMaze.PROPERTY_SEED,                   "Random seed" },
    { AbstractBasicMaze.PROPERTY_NUMBER_CELLS,           "Number of cells" },
    { AbstractBasicMaze.PROPERTY_SOLUTION_LENGTH,        "Solution length" },
    { AbstractBasicMaze.PROPERTY_CREATION_TIME,          "Creation time [ms]" },

    { MazePaintProperties.PROPERTY_BACKGROUND_PAINT,     "Maze background color" },
    { MazePaintProperties.PROPERTY_CELL_BORDER_PAINT,    "Cell border color" },
    { MazePaintProperties.PROPERTY_INNER_BORDER_PAINT,   "Inner border color" },
    { MazePaintProperties.PROPERTY_OUTER_BORDER_PAINT,   "Outer border color" },
    { MazePaintProperties.PROPERTY_SHOWING_CELL_BORDERS, "Showing cell borders" },
    { MazePaintProperties.PROPERTY_SHOWING_SOLUTION,     "Showing solution" },
    { MazePaintProperties.PROPERTY_SOLUTION_PAINT,       "Solution color" },
    { MazePaintProperties.PROPERTY_WAY_START_PAINT,      "Start cell color" },
    { MazePaintProperties.PROPERTY_WAY_END_PAINT,        "End cell color" },

    { MazePrintProperties.PROPERTY_PRINT_INFO,           "Print maze info" },
    { MazePrintProperties.PROPERTY_BLOW_UP_FACTOR,       "Print to" },
    { MazePrintProperties.RESOURCE_PAGE,                 "%0 page" },
    { MazePrintProperties.RESOURCE_PAGES,                "%0 pages" },

    { MazeSaveImageProperties.PROPERTY_EXTENT,           "Image extent (length of longer side)" },

    { CircularMaze.PROPERTY_INNER_RADIUS,                "Radius of center cell (positive) or hole (negative)" },
    { CircularMaze.PROPERTY_INNER_RADIUS+
      PropertyInformation.SHORT_DESCRIPTION_SUFFIX,      "Center radius" },
    { CircularMaze.PROPERTY_NR_INNERMOST_RING,           "Number of cells in innermost ring" },
    { CircularMaze.PROPERTY_NR_INNERMOST_RING+
      PropertyInformation.SHORT_DESCRIPTION_SUFFIX,      "Inner ring cells" },
    { CircularMaze.PROPERTY_NR_RINGS,                    "Number of rings" },

    { HexagonalMaze.PROPERTY_HORIZONTAL_CELLS,           "Number of cells per row" },
    { HexagonalMaze.PROPERTY_VERTICAL_CELLS,             "Number of rows" },

    { OctogonalMaze.PROPERTY_HORIZONTAL_CELLS,           "Number of columns" },
    { OctogonalMaze.PROPERTY_VERTICAL_CELLS,             "Number of rows" },

    { RectangularMaze.PROPERTY_HORIZONTAL_CELLS,         "Number of columns" },
    { RectangularMaze.PROPERTY_VERTICAL_CELLS,           "Number of rows" },

    { DiamondMaze.PROPERTY_HORIZONTAL_CELLS,             "Number of columns" },
    { DiamondMaze.PROPERTY_VERTICAL_CELLS,               "Number of rows" },

    { TriangularMaze.PROPERTY_SIZE,                      "Size (cells per edge)" },

    // TYPES
    { CircularMaze.MAZE_TYPE,                            "Circular maze"    },
    { HexagonalMaze.MAZE_TYPE,                           "Hexagonal maze"   },
    { OctogonalMaze.MAZE_TYPE,                           "Octogonal maze"   },
    { RectangularMaze.MAZE_TYPE,                         "Rectangular maze" },
    { TriangularMaze.MAZE_TYPE,                          "Triangular maze"  },
    { DiamondMaze.MAZE_TYPE,                             "Diamond maze"  },

    // GENERAL GUI
    { MazeFrame.RESOURCE_TITLE,                          "irrGardener" },

    { MazeFrame.RESOURCE_MENU_FILE,                      "File" },
    { MazeFrame.RESOURCE_MENU_FILE+MNEMO,                "F" },

    { MazeFrame.RESOURCE_MENUITEM_OPEN,                  "Open Maze..." },
    { MazeFrame.RESOURCE_MENUITEM_OPEN+MNEMO,            "O" },
    { MazeFrame.RESOURCE_MENUITEM_OPEN+ACCEL,            "ctrl L" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE,                  "Save Maze..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE+MNEMO,            "S" },
    { MazeFrame.RESOURCE_MENUITEM_SAVE+ACCEL,            "ctrl S" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE,            "Save as Image..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE+MNEMO,      "I" },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_IMAGE+ACCEL,      "ctrl I" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_DXF,              "Save as DXF..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_DXF+MNEMO,        "D" },

    { MazeFrame.RESOURCE_MENUITEM_SAVE_SVG,              "Save as SVG..." },
    { MazeFrame.RESOURCE_MENUITEM_SAVE_SVG+MNEMO,        "V" },

    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP,           "Setup Printing..." },
    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP+MNEMO,     "t" },
    { MazeFrame.RESOURCE_MENUITEM_PRINT_SETUP+ACCEL,     "ctrl T" },

    { MazeFrame.RESOURCE_MENUITEM_PRINT,                 "Print Maze..." },
    { MazeFrame.RESOURCE_MENUITEM_PRINT+MNEMO,           "P" },
    { MazeFrame.RESOURCE_MENUITEM_PRINT+ACCEL,           "ctrl P" },

    { MazeFrame.RESOURCE_MENUITEM_EXIT,                  "Exit" },
    { MazeFrame.RESOURCE_MENUITEM_EXIT+MNEMO,            "x" },
    { MazeFrame.RESOURCE_MENUITEM_EXIT+ACCEL,            "ctrl Q" },

    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE,      "Create" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+TTT,  "Creates a new maze with the displayed settings" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+MNEMO,"C" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_CREATE+ACCEL,"ctrl ENTER" },

    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET,       "Reset" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+TTT,   "Resets the changed settings to the values of the maze" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+MNEMO, "R" },
    { MultiMazeControlPanel.RESOURCE_BUTTON_RESET+ACCEL, "ctrl ESC" },

    { MultiMazeControlPanel.RESOURCE_PRINT_ERROR,        "Error occured during printing: %0" },
    { MultiMazeControlPanel.RESOURCE_PRINT_ERROR+TITLE,  "Print Error" },
    { ApplicationSystemAccess.RESOURCE_MAZE_FILTER_DESCRIPTION, "Maze files" },
    { MazeCanvas.RESOURCE_BUTTON_ABORT,                  "Abort" },

    // PRINT SETUP
    { PrintPropertiesDialog.RESOURCE_TITLE,              "Print Settings" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_SAVE,   "Save" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_SAVE+MNEMO,   "S" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL, "Cancel" },
    { PrintPropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL+MNEMO, "C" },

    // SAVE IMAGE SETUP
    { SaveImagePropertiesDialog.RESOURCE_TITLE,          "Save Image Settings" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_OKAY, "Okay" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_OKAY+MNEMO, "O" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL, "Cancel" },
    { SaveImagePropertiesDialog.RESOURCE_BUTTON_TEXT_CANCEL+MNEMO, "C" },

    // ERRORS
    { MazeFrame.RESOURCE_ERROR_FILE_READ,                "Cannot read file!\n%0" },
    { MazeFrame.RESOURCE_ERROR_FILE_WRITE,               "Cannot write file!\n%0" },
    { MazeFrame.RESOURCE_ERROR_FS_ACCESS,                "Cannot access local file system!" },

    // OTHER
    { MazeTool.MESSAGE_CREATING,                         "Creating maze..." },
    { MazeCanvas.TITLE_CREATION_EXCEPTION,               "Error" },
    { MazeCanvas.MESSAGE_CREATION_EXCEPTION,             "Error occured during Maze Creation: %1 (%2)" },

    { SystemAccess.MAZE_FILE_TYPE.resType,               "irrGardener Maze Files" },
    { SystemAccess.IMAGE_FILE_TYPE.resType,              "PNG Image Files" },
    { DxfMazePainter.FILE_TYPE.resType,                  "DXF Files" },
    { SvgMazePainter.FILE_TYPE.resType,                  "SVG Files" },

  };
  /** Resource key extension for title resource. */
  public static final String TITLE = "-TITLE";

  protected Object[][] getContents()
  {
    return contents;
  }

}
