// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazePrintPropertiesProvider.java,v $
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2009/09/24 16:43:31  rammi
// History:	       Added image saving.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import de.caff.gimmix.I18n;

/**
 * Provider for informations on how to print a maze.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.4 $
 */
public interface MazePrintPropertiesProvider
        extends MazePaintPropertiesProvider
{
  /** I18n resource key for "page" */
  public static final String RESOURCE_PAGE           = "MAZE_PRINT:page";
  /** I18n resource key for "pages" */
  public static final String RESOURCE_PAGES          = "MAZE_PRINT:pages";

  /**
   *  A factor describing on how many pages the maze is drawn.
   */
  public enum BlowUpFactor {
    /** Single page. */
    BLOW_UP_SINGLE(1),
    /** Double page. */
    BLOW_UP_DOUBLE(2),
    /** Quad page. */
    BLOW_UP_QUAD(4),
    /** 8 pages. */
    BLOW_UP_EIGHT(8),
    /** 16 pages. */
    BLOW_UP_SIXTEEN(16);

    /** Number of pages. */
    private int pages;

    /**
     * Constructor.
     * @param pages number of pages
     */
    BlowUpFactor(int pages)
    {
      this.pages = pages;
    }

    /**
     * Get the number of pages.
     * @return number of pages
     */
    public int getPages()
    {
      return pages;
    }

    /**
     *  Get a descriptive string.
     *  Attention: the returned string is internationalizes, don't depend on a certain format.
     *  @return description
     */
    @Override
    public String toString()
    {
      return I18n.format(pages == 1 ? RESOURCE_PAGE : RESOURCE_PAGES, pages);
    }
  }

  /**
   *  Get the blow-up factor. It defines on how many pages the
   *  maze is printed.
   *  @return blow-up factor
   */
  BlowUpFactor getBlowUpFactor();

  /**
   *  Should the maze information be printed?
   *  @return the answer
   */
  boolean isPrintInfo();
}
