// ============================================================================
// File:               $File$
//
// Project:            Maze creator.
//
// Purpose:
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2012  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazePainter.java,v $
// History:	       Revision 1.1  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
//=============================================================================
package de.caff.maze;

import java.awt.*;

/**
 * Interface for generalized painting, allowing easier conversion to vector formats.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.1 $
 */
public interface MazePainter
{
  /**
   * The current state of painting.
   */
  enum PaintObjectType {
    /** Painting the background. */
    Background,
    /** Painting the way start. */
    WayStart,
    /** Painting the way end. */
    WayEnd,
    /** Painting the solution. */
    Solution,
    /** Painting the cell borders. */
    CellBorders,
    /** Painting the inner cell borders. */
    InnerWalls,
    /** Painting the outer cell borders. */
    OuterWalls
  }

  /**
   * Start painting the maze.
   * @param maze painted maze
   */
  void startPaintingMaze(Maze maze);

  /**
   * End painting the maze.
   */
  void endPaintingMaze();

  /**
   * Start painting the given type of paint objects.
   * @param type object type which painting starts
   */
  void startPainting(PaintObjectType type);

  /**
   * End painting the given type of paint objects.
   * @param type object type which painting has ended
   */
  void endPainting(PaintObjectType type);

  /**
   * Set a stroke.
   * @param stroke new stroke to use in upcoming drawing commands
   */
  void setStroke(Stroke stroke);

  /**
   * Set a paint.
   * @param paint paint to use in upcoming drawing commands.
   */
  void setPaint(Paint paint);

  /**
   * Draw a line with current paint and stroke..
   * @param startX  starting point X coordinate
   * @param startY  starting point Y coordinate
   * @param endX    ending point X coordinate
   * @param endY    ending point Y coordinate
   */
  void drawLine(float startX, float startY, float endX, float endY);

  /**
   * Draw an open arc with current paint and stroke.
   * @param x       x of rectangle enclosing ellipse
   * @param y       y of rectangle enclosing ellipse
   * @param w       width of rectangle enclosing ellipse
   * @param h       height of rectangle enclosing ellipse
   * @param start   start of angle in degrees, from x axis,
   * @param extent  extent of angle in degrees
   */
  void drawArc(float x, float y, float w, float h,
               float start, float extent);
  /**
   * Draw a shape with current paint and stroke.
   * @param shape shape to draw
   */
  void draw(Shape shape);

  /**
   * Fill a shape with the current paint.
   * @param shape shape to fill
   */
  void fill(Shape shape);
}
