// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazePaintPropertiesProvider.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import java.awt.*;

/**
 *  Interface of objects which know how a maze is painted.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.3 $
 */
public interface MazePaintPropertiesProvider
{
  /**
   * Is the solution displayed?
   * @return the answer
   */
  boolean isShowingSolution();

  /**
   *  Are cell borders displayed?
   *  Cell borders are drawn between connected cells.
   *  @return the answer
   */
  boolean isShowingCellBorders();

  /**
   *  Get the paint of the outer walls.
   *  @return outer border paint
   */
  Paint getOuterWallPaint();

  /**
   *  Get the paint of the inner walls.
   *  Inner borders are drawn between unconnected cells.
   *  @return inner border paint
   */
  Paint getInnerWallsPaint();

  /**
   * Get the paint of cell borders.
   * Cell borders are drawn between connected cells if they are drawn at all.
   * @return cell border paint
   * @see #isShowingCellBorders()
   */
  Paint getCellBorderPaint();

  /**
   * Get the paint of solution cells.
   * @return solution cell paint
   * @see #isShowingSolution()
   */
  Paint getSolutionPaint();

  /**
   * Get the background paint.
   * @return background paint
   */
  Paint getBackgroundPaint();

  /**
   *  Get the paint for the start cell.
   *  @return start cell paint
   */
  Paint getWayStartPaint();

  /**
   *  Get the paint for the end cell.
   *  @return end cell paint
   */
  Paint getWayEndPaint();
}
