// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2005-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazeFinishedListener.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1  2005/04/19 22:15:14  rammi
// History:	       Fixed some Thread problems
// History:	
//=============================================================================
package de.caff.maze;

/**
 *  A listener which is informed when a maze has finished its creation.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.3 $
 */
public interface MazeFinishedListener
{
  /**
   *  Called if the maze creation is finished.
   *  @param maze maze which creation is finished
   *  @param exception if not <code>null</code> this exception occured during maze creation
   */
  public void finished(Maze maze, Throwable exception);
}
