// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: MazeCell.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:54  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import java.awt.*;


/**
 *  Basic class describing a cell in a maze.
 *
 *  The following items describe the intention used:
 *  <ul>
 *   <li>The flooding algorithm used to create the maze associates every cell with a set,
 *       so there has to be a way to set and get this set: see {@link de.caff.maze.MazeCell#getSet()} and
 *       {@link MazeCell#setSet(Object)}.</li>
 *   <li>A cell has neighbours and can be connected to them: see {@link de.caff.maze.MazeCell#getNeighbours()},
 *       {@link MazeCell#connectTo(MazeCell)} and {@link de.caff.maze.MazeCell#getConnectedNeighbours()}.</li>
 *   <li>A cell belongs to a maze: see {@link de.caff.maze.MazeCell#getMaze()}</li>
 *   <li>In this maze it has an unique id: {@link de.caff.maze.MazeCell#getID()}</li>
 *   <li>A cell has a shape: see {@link de.caff.maze.MazeCell#getShape()}</li>
 *  </ul>
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.3 $
 */
public abstract class MazeCell
{
  /** The current set during creation. */
  private Object set;

  /**
   *  Get the current set during maze creation.
   *  @return current set
   */
  public Object getSet()
  {
    return set;
  }

  /**
   *  Set the current set during maze creation.
   *  @param set the current set
   */
  public void setSet(Object set)
  {
    this.set = set;
  }

  /**
   * Connect this cell to the given one.
   * The algorithm will also call the inverse method for cell.
   *
   * @param cell cell to connect to
   */
  public abstract void connectTo(MazeCell cell);

  /**
   *  Get the neighbour cells of this one.
   *  @return neigbour cells
   */
  public abstract MazeCell[] getNeighbours();

  /**
   * Get the connected neighbour cells of this one.
   *
   * @return neigbour cells
   */
  public abstract MazeCell[] getConnectedNeighbours();

  /**
   *  Get the maze to which this cell belongs.
   *  @return the maze of this cell
   */
  public abstract Maze getMaze();

  /**
   *  Get the shape of this cell in the current display.
   *  @return maze cell shape
   */
  public abstract Shape getShape();

  /**
   *  Get the id of this cell.
   *  The id has to be unique for a given geometry of a maze.
   *
   *  @return unique id
   *  @see Maze#getCellByID(int) 
   */
  public abstract int getID();
}
