// ============================================================================
// File:               $File$
//
// Project:            Maze creation tool
//
// Purpose:
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: LongTextField.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
//=============================================================================
package de.caff.maze;

import javax.swing.*;
import javax.swing.text.*;

/**
 *  Text field useful to input a long integer.
 */
public class LongTextField
        extends JTextField
{
  /**
   *  Document handling a long integer number.
   */
  private class LongDocument
          extends PlainDocument
  {
    public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException
    {
      if (str == null) {
	return;
      }
      String prevText = getText(0, getLength());
      
      String text = prevText.substring(0, offs) + 
	            str + prevText.substring(offs);
      
      try {
	if (!"-".equals(text)) {
	  Long.parseLong(text);
	}

	super.insertString(offs, str, a);
      } catch (NumberFormatException x) {
	getToolkit().beep();
      }
    }
  }

  /**
   * Constructor.
   * @param value initial value
   * @param cols  columns
   */
  public LongTextField(long value, int cols)
  {
    super(Long.toString(value), cols);
  }

  @Override
  protected Document createDefaultModel()
  {
    return new LongDocument();
  }

  /**
   *  Set a value.
   *  @param value value to set
   */
  public void setValue(long value)
  {
    setText(Long.toString(value));
  }

  /**
   *  Overridden to throw NumberFormatExeption if text does not define a number.
   *  @param text text to set
   */
  @Override
  public void setText(String text)
  {
    Long.parseLong(text);
    super.setText(text);
  }

  /**
   *  Get the value in this field.
   *  @return value
   *  @throws NumberFormatException if current content does not defines a number
   */
  public long getValue() throws NumberFormatException
  {
    return Long.parseLong(getText());
  }
}
