// ============================================================================
// File:               $File$
//
// Project:            Maze creator.
//
// Purpose:
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2012  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: Graphics2DMazePainter.java,v $
// History:	       Revision 1.1  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
//=============================================================================
package de.caff.maze;

import java.awt.*;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;

/**
 * The standard maze painter which paints everything to a Graphics2D object.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.1 $
 */
public class Graphics2DMazePainter
        implements MazePainter
{
  private final Graphics2D g;

  /**
   * Constructor.
   * @param g2 graphics object to which the painting is forwarded.
   */
  public Graphics2DMazePainter(Graphics2D g2)
  {
    this.g = g2;
  }

  /**
   * Start painting the maze.
   *
   * @param maze painted maze
   */
  public void startPaintingMaze(Maze maze)
  {
    // ignored
  }

  /**
   * End painting the maze.
   */
  public void endPaintingMaze()
  {
    // ignored
  }

  /**
   * Start painting the given type of paint objects.
   *
   * @param type object type which painting starts
   */
  public void startPainting(PaintObjectType type)
  {
    // ignored
  }

  /**
   * End painting the given type of paint objects.
   *
   * @param type object type which painting has ended
   */
  public void endPainting(PaintObjectType type)
  {
    // ignored
  }

  /**
   * Set a stroke.
   *
   * @param stroke new stroke to use in upcoming drawing commands
   */
  public void setStroke(Stroke stroke)
  {
    g.setStroke(stroke);
  }

  /**
   * Set a paint.
   *
   * @param paint paint to use in upcoming drawing commands.
   */
  public void setPaint(Paint paint)
  {
    g.setPaint(paint);
  }

  /**
   * Draw a line with current paint and stroke..
   *
   * @param startX starting point X coordinate
   * @param startY starting point Y coordinate
   * @param endX   ending point X coordinate
   * @param endY   ending point Y coordinate
   */
  public void drawLine(float startX, float startY, float endX, float endY)
  {
    g.draw(new Line2D.Float(startX, startY, endX, endY));
  }

  /**
   * Draw an open arc with current paint and stroke.
   *
   * @param x      x of rectangle enclosing ellipse
   * @param y      y of rectangle enclosing ellipse
   * @param w      width of rectangle enclosing ellipse
   * @param h      height of rectangle enclosing ellipse
   * @param start  start of angle in degrees, from x axis,
   * @param extent extent of angle in degrees
   */
  public void drawArc(float x, float y, float w, float h, float start, float extent)
  {
    g.draw(new Arc2D.Float(x, y, w, h, start, extent, Arc2D.OPEN));
  }

  /**
   * Draw a shape with current paint and stroke.
   *
   * @param shape shape to draw
   */
  public void draw(Shape shape)
  {
    g.draw(shape);
  }

  /**
   * Fill a shape with the current paint.
   *
   * @param shape shape to fill
   */
  public void fill(Shape shape)
  {
    g.fill(shape);
  }
}
