// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: DataStorage.java,v $
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.2  2004/10/31 22:07:43  rammi
// History:	       Fixed problem with default ways on first execution
// History:	
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import java.awt.*;

/**
 *  An interface for temporary or persistent storage of data.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.4 $
 */
public interface DataStorage
{
  /**
   *  Get a string value.
   *  @param key key for the string
   *  @param defaultValue default value which is returned if the string is not defined
   *  @return the string value defined by the key or the default value
   */
  String getString(String key, String defaultValue);

  /**
   *  Set a string.
   *  @param key key for the string
   *  @param value the string value to store
   */
  void setString(String key, String value);

  /**
   *  Get a boolean value.
   *  @param key           the key of the value
   *  @param defaultValue  the default value if the key is not defined
   *  @return the boolean value defined by the key of the default value
   */
  boolean getBoolean(String key, boolean defaultValue);

  /**
   *  Set a boolean.
   *  @param key   key for the boolean
   *  @param value value of the boolean
   */
  void setBoolean(String key, boolean value);

  /**
   *  Get a integer value.
   *  @param key           the key of the value
   *  @param defaultValue  the default value if the key is not defined
   *  @return the integer value defined by the key of the default value
   */
  int getInt(String key, int defaultValue);

  /**
   *  Set a integer value.
   *  @param key   key for the int
   *  @param value value of the int
   */
  void setInt(String key, int value);

  /**
   *  Get a persistent long integer value.
   *  @param key           the key of the value
   *  @param defaultValue  the default value if the key is not defined
   *  @return the long integer value defined by the key of the default value
   */
  long getLong(String key, long defaultValue);

  /**
   *  Set a long integer value.
   *  @param key   key for the long int
   *  @param value value of the long int
   */
  void setLong(String key, long value);

  /**
   *  Get a double value.
   *  @param key           the key of the value
   *  @param defaultValue  the default value if the key is not defined
   *  @return the double value defined by the key of the default value
   */
  double getDouble(String key, double defaultValue);

  /**
   *  Set a double value.
   *  @param key   key for the int
   *  @param value value of the int
   */
  void setDouble(String key, double value);

  /**
   *  Get a color value.
   *  @param key           the key of the value
   *  @param defaultValue  the default value if the key is not defined
   *  @return the color value deg´fined by the key of the default value
   */
  Color getColor(String key, Color defaultValue);

  /**
   *  Set a color.
   *  @param key   key for the color
   *  @param value value of the color
   */
  void setColor(String key, Color value);

  /**
   *  Is his key defined?
   *  @param key   key to look for
   *  @return <code>true</code> if the key is defined, <code>false</code> otherwise
   */
  boolean hasKey(String key);

  /**
   *  Store all data if this has not already happenend.
   *  This is called when the process is about to shutdown.
   *  On it persistent implementation of this interface this
   *  method should store all data persistently if this has not
   *  already happened. A temporary storage does nothing.
   */
  void storePersistentData();
}
