// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: AbstractPropertyInformation.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
//=============================================================================
package de.caff.maze;

import de.caff.gimmix.I18n;

import javax.swing.*;
import java.util.MissingResourceException;

/**
 *  Basic implementation of a PropertyInformation.
 *
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.3 $
 */
public abstract class AbstractPropertyInformation
        implements PropertyInformation
{
  /** Property resource id name. */
  private final String name;

  /**
   *  Constructor.
   *  @param name  property name which is also used as a prefix for the various resources
   */
  protected AbstractPropertyInformation(String name)
  {
    this.name  = name;
  }

  /**
   * Get the name of the property.
   *
   * @return property value
   */
  public String getName()
  {
    return name;
  }

  /**
   * Get a localized description of the property with the current default locale.
   *
   * @return localized description
   */
  public String getLocalizedDescription()
  {
    return I18n.getString(getName());
  }

  /**
   * Get a short localized description of the property with the current default locale.
   *
   * @return localized short description or the standard localized description if no
   *         short description is defined
   * @see #getLocalizedDescription()
   */
  public String getLocalizedShortDescription()
  {
    try {
      return I18n.getString(getName()+SHORT_DESCRIPTION_SUFFIX);
    } catch (MissingResourceException e) {
      return getLocalizedDescription();
    }
  }

  /**
   *  A component to set the property.
   *  @return setter component
   */
  public abstract JComponent getSetterComponent();

  /**
   *  Forget changed data in the property setter.
   *  This default implementation does nothing which is the standard fo informational displays.
   */
  public void forget()
  {
  }

  /**
   *  Is the setter component just for display?
   *  This default implementation returns <code>false</code> which is the standard for non-informational displays.
   *  @return the answer
   */
  public boolean isInformational()
  {
    return false;
  }
}
