// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2004-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: ResourcedAction.java,v $
// History:	       Revision 1.4  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.3  2006/12/19 18:11:36  rammi
// History:	       Documentation improvements
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1  2004/11/02 20:53:53  rammi
// History:	       Added keyboard shortcuts etc via actions
// History:	
//=============================================================================
package de.caff.gimmix;

import javax.swing.*;
import java.util.MissingResourceException;

/**
 * Internationalized action.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision: 1.4 $
 */
public abstract class ResourcedAction
        extends AbstractAction
{
  /** Resource key extension for tool tip text resource. */
  public static final String TTT = "-TTT";
  /** Resource key extension for accelerator resource. */
  public static final String ACCEL = "-ACCEL";
  /** Resource key extension for mnemonics resource. */
  public static final String MNEMO = "-MNEMO";
  /** Resource key extension for icon path resource. */
  public static final String ICONURL = "-ICONURL";

  /**
   *  Get an icon from a resource.
   *  @param pathKey key to describe the icon's path
   *  @return icon or <code>null</code>
   */
  private static Icon getIcon(String pathKey)
  {
    try {
      String iconPath = I18n.getString(pathKey);
      return new ImageIcon(ResourcedAction.class.getResource(iconPath));
    } catch (MissingResourceException e) {
      return null;
    }
  }

  /**
   *  Create a resourced action.
   *  @param resourceKey resource key
   */
  protected ResourcedAction(String resourceKey)
  {
    super(I18n.getString(resourceKey), getIcon(resourceKey+ICONURL));
    try {
      String mnemonic = I18n.getString(resourceKey+MNEMO);
      if (mnemonic.length() > 0) {
        putValue(MNEMONIC_KEY, new Integer(mnemonic.charAt(0)));
      }
    } catch (MissingResourceException e) {
    }
    // try setting accelerator
    try {
      String accelerator = I18n.getString(resourceKey+ACCEL);
      KeyStroke keyStroke = KeyStroke.getKeyStroke(accelerator);
      putValue(ACCELERATOR_KEY, keyStroke);
    } catch (MissingResourceException e) {
    }
    // try setting tooltip
    try {
      String ttt = I18n.getString(resourceKey+TTT);
      putValue(SHORT_DESCRIPTION, ttt);
    } catch (MissingResourceException e) {
    }
  }

  @Override
  protected Object clone() throws CloneNotSupportedException
  {
    throw new CloneNotSupportedException();
  }
}
