// ============================================================================
// File:               Localizable.java
//
// Project:            i18n 
//
// Purpose:            Interface for Components which can be localized.
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2002-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: Localizable.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1.1.1  2004/10/25 14:47:55  rammi
// History:	       Initial version
// History:	
// History:	       Revision 1.2  2002/03/04 19:37:43  rammi
// History:	       added CVS variables
// History:	
//=============================================================================

package de.caff.gimmix;


import java.util.Locale;

/**
 *  Interface for Components which can be localized.
 *  <code>Component</code>s are localizable themselves, too.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.3 $
 */
public interface Localizable {
  /**
   *  Set the locale.
   *  @param  l   locale to set.
   */
  public void setLocale(Locale l);

  /**
   *  Get the locale.
   *  @return  the locale
   */
  public Locale getLocale();
}
