// ============================================================================
// File:               $File$
//
// Project:            DXF viewer
//
// Purpose:            A knock off listener invoke when a {@link Worker} has finished.
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2003-2006  Rammi (rammi@caff.de)
//
//                     This code was part of the irrGardener maze creation tool
//                     (see http://caff.de/maze/)
//                     and may be used and changed without restrictions
//                     since December 19, 2006.
//                     No guarantees are given.
//
// Latest change:      $Date: 2012/06/07 18:36:39 $
//
// History:	       $Log: KnockOffListener.java,v $
// History:	       Revision 1.3  2012/06/07 18:36:39  rammi
// History:	       FIxed typo in copyright comment.
// History:	       Added vector format outputs to DXF and SVG.
// History:
// History:	       Revision 1.2  2006/12/19 16:12:00  rammi
// History:	       Opened the code
// History:
// History:	       Revision 1.1  2005/04/19 22:15:14  rammi
// History:	       Fixed some Thread problems
// History:	
// History:	       Revision 1.1  2003/01/23 12:00:51  rammi
// History:	       First release.
// History:	
//=============================================================================

package de.caff.gimmix;

/**
 *  A knock off listener invoke when a {@link Worker} has finished.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision: 1.3 $
 */
public interface KnockOffListener
{
  /**
   *  Called when a {@link Worker worker} has finished its work.
   *  @param worker worker which knocks off
   */
  public void knockedOff(Worker worker);
}
