// ============================================================================
// File:               TestStringMultiply
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            20.01.22 11:53
//=============================================================================
package de.caff.generics;

import junit.framework.TestCase;

/**
 * String multiplication test.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 20, 2022
 */
public class TestStringMultiply
        extends TestCase
{
  public void test1()
  {
    assertEquals("", Types.multiple("foO", 0));
    assertEquals("foO", Types.multiple("foO", 1));
    assertEquals("foOfoO", Types.multiple("foO", 2));
    assertEquals("foOfoOfoO", Types.multiple("foO", 3));
    assertEquals("foOfoOfoOfoO", Types.multiple("foO", 4));
    assertEquals("foOfoOfoOfoOfoO", Types.multiple("foO", 5));
    assertEquals("foOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoO",
                 Types.multiple("foO", 15));
    assertEquals("foOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoO",
                 Types.multiple("foO", 16));
    assertEquals("foOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoOfoO",
                 Types.multiple("foO", 17));
  }
}
