// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import junit.framework.TestCase;

import java.util.Random;
import java.util.concurrent.*;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since Mai 11, 2021
 */
public class TestRecreatingLeastRecentlyUsedCache
        extends TestCase
{
  public void test() throws InterruptedException
  {
    final Random rnd = new Random(0);
    final RecreatingLeastRecentlyUsedCache<Integer, byte[]> cache = new RecreatingLeastRecentlyUsedCache<>(4,
                                                                                             i -> new byte[i * 1024 * 1024]);
    final LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<>();
    final ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 8, 1000, TimeUnit.SECONDS, workQueue);
    for (int t = 0;  t < 1024;  ++t) {
      executor.submit(() -> {
        try {
          Thread.sleep(rnd.nextInt(100));
        } catch (InterruptedException e) {
          e.printStackTrace();
        }
        final int key = rnd.nextInt(100) + 2500;
        final Future<byte[]> result = executor.submit(() -> cache.get(key));
      });
    }
    executor.shutdown();
    while (!workQueue.isEmpty()) {
      try {
        Thread.sleep(1000);
      } catch (InterruptedException e) {
        e.printStackTrace();
      }
      final Runtime runtime = Runtime.getRuntime();
      System.out.printf("%d / %d / %d / %d\n", workQueue.size(), runtime.freeMemory(), runtime.maxMemory(), runtime.totalMemory());
    }
    assertTrue(executor.awaitTermination(1000, TimeUnit.SECONDS));
  }
}
