// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import de.caff.generics.util.Counter;
import de.caff.generics.util.SimpleCounter;
import junit.framework.TestCase;

import java.util.Arrays;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since December 15, 2021
 */
public class TestFloatIndexable
        extends TestCase
{
  public void testIteration()
  {
    final float[] array = { 0.1f, 1.2f, 2.3f, 3.14f, 4.5f, 5.6f };
    final FloatIndexable indexable = FloatIndexable.viewArray(array);

    assertEquals(array.length, indexable.size());
    final Counter counter = new SimpleCounter();
    indexable.forEachFloat(v -> {
      assertEquals(array[counter.getValue()], v);
      counter.add1();
    });
    assertEquals(array.length, counter.getValue());
  }

  public void testFreeze()
  {
    final float[] array = { 0.1f, 1.2f, 2.3f, 3.14f, 4.5f, 5.6f };
    final float[] backup = array.clone();
    final FloatIndexable indexable = FloatIndexable.viewArray(array);
    final FloatIndexable sub = indexable.subSet(2, 5);
    final FloatIndexable frozen = indexable.frozen();
    final FloatIndexable subFrozen = sub.frozen();
    final FloatIndexable frozenSub = frozen.subSet(2, 5);

    array[3] = (float)-Math.PI;
    assertEquals(array[3], indexable.get(3));
    assertEquals(array[3], sub.get(1));
    assertEquals(backup[3], frozen.get(3));
    assertEquals(backup[3], subFrozen.get(1));
    assertEquals(backup[3], frozenSub.get(1));

    assertTrue(Arrays.equals(array, indexable.toArray()));
    assertTrue(Arrays.equals(backup, frozen.toArray()));
  }
}
