package de.caff.generics;

import de.caff.generics.util.Counter;
import de.caff.generics.util.SimpleCounter;
import junit.framework.TestCase;

import java.util.Arrays;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since December 15, 2021
 */
public class TestByteIndexable
        extends TestCase
{
  public void testIteration()
  {
    final byte[] array = { 0, 1, 2, 3, 4, 5 };
    final ByteIndexable indexable = ByteIndexable.viewArray(array);

    assertEquals(array.length, indexable.size());
    final Counter counter = new SimpleCounter();
    indexable.forEachByte(i -> assertEquals(counter.add1() - 1, i));
    assertEquals(array.length, counter.getValue());
  }

  public void testFreeze()
  {
    final byte[] array = { 0, 1, 2, 3, 4, 5 };
    final byte[] backup = array.clone();
    final ByteIndexable indexable = ByteIndexable.viewArray(array);
    final ByteIndexable sub = indexable.subSet(2, 5);
    final ByteIndexable frozen = indexable.frozen();
    final ByteIndexable subFrozen = sub.frozen();
    final ByteIndexable frozenSub = frozen.subSet(2, 5);

    array[3] = -3;
    assertEquals(-3, indexable.get(3));
    assertEquals(-3, sub.get(1));
    assertEquals(3, frozen.get(3));
    assertEquals(3, subFrozen.get(1));
    assertEquals(3, frozenSub.get(1));

    assertTrue(Arrays.equals(array, indexable.toArray()));
    assertTrue(Arrays.equals(backup, frozen.toArray()));
  }
}
