// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics;

import de.caff.generics.util.Counter;
import de.caff.generics.util.SimpleCounter;
import junit.framework.TestCase;

import java.util.Arrays;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since December 15, 2021
 */
public class TestBooleanIndexable
        extends TestCase
{
  public void testIteration()
  {
    final boolean[] array = { false, true, false, true, false, true };
    final BooleanIndexable indexable = BooleanIndexable.viewArray(array);

    assertEquals(array.length, indexable.size());
    final Counter counter = new SimpleCounter();
    indexable.forEachBool(i -> assertEquals(counter.add1() % 2 == 0, i));
    assertEquals(array.length, counter.getValue());
  }

  public void testFreeze()
  {
    final boolean[] array = { false, true, false, true, false, true };
    final boolean[] backup = array.clone();
    final BooleanIndexable indexable = BooleanIndexable.viewArray(array);
    final BooleanIndexable sub = indexable.subSet(2, 5);
    final BooleanIndexable frozen = indexable.frozen();
    final BooleanIndexable subFrozen = sub.frozen();
    final BooleanIndexable frozenSub = frozen.subSet(2, 5);

    array[3] = false;
    assertEquals(false, indexable.get(3));
    assertEquals(false, sub.get(1));
    assertEquals(true, frozen.get(3));
    assertEquals(true, subFrozen.get(1));
    assertEquals(true, frozenSub.get(1));

    assertTrue(Arrays.equals(array, indexable.toArray()));
    assertTrue(Arrays.equals(backup, frozen.toArray()));
  }
}
