// ============================================================================
// File:               TestBitPos
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2023-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            1/9/23 5:03 PM
//=============================================================================
package de.caff.generics;

import junit.framework.TestCase;

import static de.caff.generics.Primitives.positionOfHighestOneBit;
import static de.caff.generics.Primitives.positionOfLowestOneBit;

/**
 * Test the bit position methods in {@link Primitives}.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 09, 2023
 */
public class TestBitPos
        extends TestCase
{
  public void testInt()
  {
    assertEquals(-1, positionOfHighestOneBit(0));
    assertEquals(-1, positionOfLowestOneBit(0));

    assertEquals(0, positionOfHighestOneBit(1));
    assertEquals(0, positionOfLowestOneBit(1));

    assertEquals(1, positionOfHighestOneBit(3));
    assertEquals(0, positionOfLowestOneBit(3));

    assertEquals(5, positionOfHighestOneBit(42));
    assertEquals(1, positionOfLowestOneBit(42));

    assertEquals(30, positionOfHighestOneBit(Integer.MAX_VALUE));
    assertEquals(0, positionOfLowestOneBit(Integer.MAX_VALUE));

    assertEquals(31, positionOfHighestOneBit(Integer.MIN_VALUE));
    assertEquals(31, positionOfLowestOneBit(Integer.MIN_VALUE));

    assertEquals(31, positionOfHighestOneBit(-1));
    assertEquals(0, positionOfLowestOneBit(-1));
  }

  public void testLong()
  {
    assertEquals(-1, positionOfHighestOneBit(0L));
    assertEquals(-1, positionOfLowestOneBit(0L));

    assertEquals(0, positionOfHighestOneBit(1L));
    assertEquals(0, positionOfLowestOneBit(1L));

    assertEquals(1, positionOfHighestOneBit(3L));
    assertEquals(0, positionOfLowestOneBit(3L));

    assertEquals(5, positionOfHighestOneBit(42L));
    assertEquals(1, positionOfLowestOneBit(42L));

    assertEquals(30, positionOfHighestOneBit((long)Integer.MAX_VALUE));
    assertEquals(0, positionOfLowestOneBit((long)Integer.MAX_VALUE));

    final long intMinMasked = Integer.MIN_VALUE & 0xff_ff_ff_ffL;
    assertEquals(31, positionOfHighestOneBit(intMinMasked));
    assertEquals(31, positionOfLowestOneBit(intMinMasked));

    assertEquals(62, positionOfHighestOneBit(Long.MAX_VALUE));
    assertEquals(0, positionOfLowestOneBit(Long.MAX_VALUE));

    assertEquals(63, positionOfHighestOneBit(Long.MIN_VALUE));
    assertEquals(63, positionOfLowestOneBit(Long.MIN_VALUE));

    assertEquals(63, positionOfHighestOneBit(-1L));
    assertEquals(0, positionOfLowestOneBit(-1L));
  }
}
