// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================

/**
 * This package provides semantic versioning for modules.
 * <p>
 * de.caff code is divided into lots of modules. With the help of the classes
 * in this package it is possible to have access to the
 * {@link de.caff.version.SemVer semantic versions} of
 * the modules contained in an application during runtime.
 * This is done via the Java {@link java.util.ServiceLoader service loader}
 * mechanism. Classes which implement {@link de.caff.version.ModuleVersionService}
 * and which are published as services (i.e. there are dedicated service entries in the jar
 * containing the class) can automatically be retrieved at runtime.
 * <p>
 * The interface {@link de.caff.version.ModuleVersionService} provides static accessors
 * methods for retrieving the registered services.
 * <p>
 * Helper class {@link de.caff.version.ModuleVersionTool} provides static helper
 * method to create Java code implementing the service.
 */
package de.caff.version;