// This class is automatically created by de.caff.version.ModuleVersionService.
package de.caff.version
;
import de.caff.annotation.NotNull;
import de.caff.generics.Types;
import de.caff.version.ModuleVersionService;
import de.caff.version.SemVer;

import java.util.Objects;

/**
 * Module version information.
 * This automatically created class provides version information for the module in which it is contained.
 * Note that creating this class is only the first step, it is necessary to include it in the
 * META-INF/services directory in the module's jar.
 */
public class ModuleVersion
        implements ModuleVersionService
{
  /** Module name. */
  @NotNull
  public static final String MODULE_NAME = "de·caff:generics";
  /** Module version as a constant. */
  @NotNull
  public static final SemVer VERSION = Objects.requireNonNull(SemVer.parse("3.19.30+20250513-131825"));

  @NotNull
  @Override
  public String getModuleName()
  {
    return MODULE_NAME;
  }

  @NotNull
  @Override
  public SemVer getModuleVersion()
  {
    return VERSION;
  }

  /**
   * Get the release date.
   * This assumes that the release date is included in {@link #VERSION} as build string.
   * @return build string of the version, empty if there is none
   */
  @NotNull
  public static String getReleaseDate()
  {
    return Types.notNull(VERSION.getBuildString());
  }

  @NotNull
  @Override
  public String toString()
  {
    return String.format("%s: %s", MODULE_NAME, VERSION);
  }
}
