// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021 - 2022  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.tuple;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;

import java.io.Serializable;
import java.util.Objects;

/**
 * Immutable tuple with 7 non-null elements.
 *
 * If you want to iterate over a tuple or access its elements by index
 * (note that both is only possible for a common super type of the tuple's types)
 * {@link de.caff.generics.Indexable#viewTuple(ITuple7)} will come to help.
 *
 * Note that this class is automatically created by {@code tools.TupleClassCreator} (not yet public).
 *
 * @param <T1> type of first element
 * @param <T2> type of second element
 * @param <T3> type of third element
 * @param <T4> type of fourth element
 * @param <T5> type of fifth element
 * @param <T6> type of sixth element
 * @param <T7> type of seventh element
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 17, 2021
 * @see NTuple7
 */
public class Tuple7<T1, T2, T3, T4, T5, T6, T7>
        extends ITuple7.Base<T1, T2, T3, T4, T5, T6, T7>
        implements Serializable
{
  private static final long serialVersionUID = 1L;

  @NotNull
  private final T1 elem1;
  @NotNull
  private final T2 elem2;
  @NotNull
  private final T3 elem3;
  @NotNull
  private final T4 elem4;
  @NotNull
  private final T5 elem5;
  @NotNull
  private final T6 elem6;
  @NotNull
  private final T7 elem7;

  /**
   * Constructor.
   * @param e1 first element
   * @param e2 second element
   * @param e3 third element
   * @param e4 fourth element
   * @param e5 fifth element
   * @param e6 sixth element
   * @param e7 seventh element
   */
  public Tuple7(@NotNull T1 e1, @NotNull T2 e2, @NotNull T3 e3, @NotNull T4 e4, @NotNull T5 e5, @NotNull T6 e6, @NotNull T7 e7)
  {
    assert e1 != null;
    elem1 = e1;
    assert e2 != null;
    elem2 = e2;
    assert e3 != null;
    elem3 = e3;
    assert e4 != null;
    elem4 = e4;
    assert e5 != null;
    elem5 = e5;
    assert e6 != null;
    elem6 = e6;
    assert e7 != null;
    elem7 = e7;
  }

  @NotNull
  @Override
  public T1 _1()  {
    return elem1;
  }

  @NotNull
  @Override
  public T2 _2()  {
    return elem2;
  }

  @NotNull
  @Override
  public T3 _3()  {
    return elem3;
  }

  @NotNull
  @Override
  public T4 _4()  {
    return elem4;
  }

  @NotNull
  @Override
  public T5 _5()  {
    return elem5;
  }

  @NotNull
  @Override
  public T6 _6()  {
    return elem6;
  }

  @NotNull
  @Override
  public T7 _7()  {
    return elem7;
  }

  @NotNull
  @Override
  public Tuple6<T1, T2, T3, T4, T5, T6> _123456()  {
    return new Tuple6<>(elem1, elem2, elem3, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple6<T1, T2, T3, T4, T5, T7> _123457()  {
    return new Tuple6<>(elem1, elem2, elem3, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple6<T1, T2, T3, T4, T6, T7> _123467()  {
    return new Tuple6<>(elem1, elem2, elem3, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple6<T1, T2, T3, T5, T6, T7> _123567()  {
    return new Tuple6<>(elem1, elem2, elem3, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple6<T1, T2, T4, T5, T6, T7> _124567()  {
    return new Tuple6<>(elem1, elem2, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple6<T1, T3, T4, T5, T6, T7> _134567()  {
    return new Tuple6<>(elem1, elem3, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple6<T2, T3, T4, T5, T6, T7> _234567()  {
    return new Tuple6<>(elem2, elem3, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T4, T5> _12345()  {
    return new Tuple5<>(elem1, elem2, elem3, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T4, T6> _12346()  {
    return new Tuple5<>(elem1, elem2, elem3, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T5, T6> _12356()  {
    return new Tuple5<>(elem1, elem2, elem3, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T4, T5, T6> _12456()  {
    return new Tuple5<>(elem1, elem2, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple5<T1, T3, T4, T5, T6> _13456()  {
    return new Tuple5<>(elem1, elem3, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple5<T2, T3, T4, T5, T6> _23456()  {
    return new Tuple5<>(elem2, elem3, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T4, T7> _12347()  {
    return new Tuple5<>(elem1, elem2, elem3, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T5, T7> _12357()  {
    return new Tuple5<>(elem1, elem2, elem3, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T4, T5, T7> _12457()  {
    return new Tuple5<>(elem1, elem2, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T3, T4, T5, T7> _13457()  {
    return new Tuple5<>(elem1, elem3, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T2, T3, T4, T5, T7> _23457()  {
    return new Tuple5<>(elem2, elem3, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T3, T6, T7> _12367()  {
    return new Tuple5<>(elem1, elem2, elem3, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T4, T6, T7> _12467()  {
    return new Tuple5<>(elem1, elem2, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T3, T4, T6, T7> _13467()  {
    return new Tuple5<>(elem1, elem3, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T2, T3, T4, T6, T7> _23467()  {
    return new Tuple5<>(elem2, elem3, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T2, T5, T6, T7> _12567()  {
    return new Tuple5<>(elem1, elem2, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T3, T5, T6, T7> _13567()  {
    return new Tuple5<>(elem1, elem3, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T2, T3, T5, T6, T7> _23567()  {
    return new Tuple5<>(elem2, elem3, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T1, T4, T5, T6, T7> _14567()  {
    return new Tuple5<>(elem1, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T2, T4, T5, T6, T7> _24567()  {
    return new Tuple5<>(elem2, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple5<T3, T4, T5, T6, T7> _34567()  {
    return new Tuple5<>(elem3, elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T3, T4> _1234()  {
    return new Tuple4<>(elem1, elem2, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T3, T5> _1235()  {
    return new Tuple4<>(elem1, elem2, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T4, T5> _1245()  {
    return new Tuple4<>(elem1, elem2, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T4, T5> _1345()  {
    return new Tuple4<>(elem1, elem3, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T4, T5> _2345()  {
    return new Tuple4<>(elem2, elem3, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T3, T6> _1236()  {
    return new Tuple4<>(elem1, elem2, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T4, T6> _1246()  {
    return new Tuple4<>(elem1, elem2, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T4, T6> _1346()  {
    return new Tuple4<>(elem1, elem3, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T4, T6> _2346()  {
    return new Tuple4<>(elem2, elem3, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T5, T6> _1256()  {
    return new Tuple4<>(elem1, elem2, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T5, T6> _1356()  {
    return new Tuple4<>(elem1, elem3, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T5, T6> _2356()  {
    return new Tuple4<>(elem2, elem3, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T4, T5, T6> _1456()  {
    return new Tuple4<>(elem1, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T2, T4, T5, T6> _2456()  {
    return new Tuple4<>(elem2, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T3, T4, T5, T6> _3456()  {
    return new Tuple4<>(elem3, elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T3, T7> _1237()  {
    return new Tuple4<>(elem1, elem2, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T4, T7> _1247()  {
    return new Tuple4<>(elem1, elem2, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T4, T7> _1347()  {
    return new Tuple4<>(elem1, elem3, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T4, T7> _2347()  {
    return new Tuple4<>(elem2, elem3, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T5, T7> _1257()  {
    return new Tuple4<>(elem1, elem2, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T5, T7> _1357()  {
    return new Tuple4<>(elem1, elem3, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T5, T7> _2357()  {
    return new Tuple4<>(elem2, elem3, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T4, T5, T7> _1457()  {
    return new Tuple4<>(elem1, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T4, T5, T7> _2457()  {
    return new Tuple4<>(elem2, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T3, T4, T5, T7> _3457()  {
    return new Tuple4<>(elem3, elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T2, T6, T7> _1267()  {
    return new Tuple4<>(elem1, elem2, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T3, T6, T7> _1367()  {
    return new Tuple4<>(elem1, elem3, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T3, T6, T7> _2367()  {
    return new Tuple4<>(elem2, elem3, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T4, T6, T7> _1467()  {
    return new Tuple4<>(elem1, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T4, T6, T7> _2467()  {
    return new Tuple4<>(elem2, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T3, T4, T6, T7> _3467()  {
    return new Tuple4<>(elem3, elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T1, T5, T6, T7> _1567()  {
    return new Tuple4<>(elem1, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T2, T5, T6, T7> _2567()  {
    return new Tuple4<>(elem2, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T3, T5, T6, T7> _3567()  {
    return new Tuple4<>(elem3, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple4<T4, T5, T6, T7> _4567()  {
    return new Tuple4<>(elem4, elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T2, T3> _123()  {
    return new Tuple3<>(elem1, elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T1, T3, T2> _132()  {
    return new Tuple3<>(elem1, elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T1, T2> _312()  {
    return new Tuple3<>(elem3, elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T2, T1> _321()  {
    return new Tuple3<>(elem3, elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T3, T1> _231()  {
    return new Tuple3<>(elem2, elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T1, T3> _213()  {
    return new Tuple3<>(elem2, elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T1, T2, T4> _124()  {
    return new Tuple3<>(elem1, elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T1, T4, T2> _142()  {
    return new Tuple3<>(elem1, elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T1, T2> _412()  {
    return new Tuple3<>(elem4, elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T2, T1> _421()  {
    return new Tuple3<>(elem4, elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T4, T1> _241()  {
    return new Tuple3<>(elem2, elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T1, T4> _214()  {
    return new Tuple3<>(elem2, elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T1, T3, T4> _134()  {
    return new Tuple3<>(elem1, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T1, T4, T3> _143()  {
    return new Tuple3<>(elem1, elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T1, T3> _413()  {
    return new Tuple3<>(elem4, elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T3, T1> _431()  {
    return new Tuple3<>(elem4, elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T4, T1> _341()  {
    return new Tuple3<>(elem3, elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T1, T4> _314()  {
    return new Tuple3<>(elem3, elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T2, T3, T4> _234()  {
    return new Tuple3<>(elem2, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T2, T4, T3> _243()  {
    return new Tuple3<>(elem2, elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T2, T3> _423()  {
    return new Tuple3<>(elem4, elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T3, T2> _432()  {
    return new Tuple3<>(elem4, elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T4, T2> _342()  {
    return new Tuple3<>(elem3, elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T2, T4> _324()  {
    return new Tuple3<>(elem3, elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T1, T2, T5> _125()  {
    return new Tuple3<>(elem1, elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T5, T2> _152()  {
    return new Tuple3<>(elem1, elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T1, T2> _512()  {
    return new Tuple3<>(elem5, elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T2, T1> _521()  {
    return new Tuple3<>(elem5, elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T5, T1> _251()  {
    return new Tuple3<>(elem2, elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T1, T5> _215()  {
    return new Tuple3<>(elem2, elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T3, T5> _135()  {
    return new Tuple3<>(elem1, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T5, T3> _153()  {
    return new Tuple3<>(elem1, elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T1, T3> _513()  {
    return new Tuple3<>(elem5, elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T3, T1> _531()  {
    return new Tuple3<>(elem5, elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T5, T1> _351()  {
    return new Tuple3<>(elem3, elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T1, T5> _315()  {
    return new Tuple3<>(elem3, elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T2, T3, T5> _235()  {
    return new Tuple3<>(elem2, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T2, T5, T3> _253()  {
    return new Tuple3<>(elem2, elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T2, T3> _523()  {
    return new Tuple3<>(elem5, elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T3, T2> _532()  {
    return new Tuple3<>(elem5, elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T5, T2> _352()  {
    return new Tuple3<>(elem3, elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T2, T5> _325()  {
    return new Tuple3<>(elem3, elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T4, T5> _145()  {
    return new Tuple3<>(elem1, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T5, T4> _154()  {
    return new Tuple3<>(elem1, elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T1, T4> _514()  {
    return new Tuple3<>(elem5, elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T4, T1> _541()  {
    return new Tuple3<>(elem5, elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T5, T1> _451()  {
    return new Tuple3<>(elem4, elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T1, T5> _415()  {
    return new Tuple3<>(elem4, elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T2, T4, T5> _245()  {
    return new Tuple3<>(elem2, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T2, T5, T4> _254()  {
    return new Tuple3<>(elem2, elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T2, T4> _524()  {
    return new Tuple3<>(elem5, elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T4, T2> _542()  {
    return new Tuple3<>(elem5, elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T5, T2> _452()  {
    return new Tuple3<>(elem4, elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T2, T5> _425()  {
    return new Tuple3<>(elem4, elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T3, T4, T5> _345()  {
    return new Tuple3<>(elem3, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T3, T5, T4> _354()  {
    return new Tuple3<>(elem3, elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T3, T4> _534()  {
    return new Tuple3<>(elem5, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T4, T3> _543()  {
    return new Tuple3<>(elem5, elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T5, T3> _453()  {
    return new Tuple3<>(elem4, elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T3, T5> _435()  {
    return new Tuple3<>(elem4, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T1, T2, T6> _126()  {
    return new Tuple3<>(elem1, elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T6, T2> _162()  {
    return new Tuple3<>(elem1, elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T6, T1, T2> _612()  {
    return new Tuple3<>(elem6, elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T6, T2, T1> _621()  {
    return new Tuple3<>(elem6, elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T6, T1> _261()  {
    return new Tuple3<>(elem2, elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T1, T6> _216()  {
    return new Tuple3<>(elem2, elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T3, T6> _136()  {
    return new Tuple3<>(elem1, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T6, T3> _163()  {
    return new Tuple3<>(elem1, elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T1, T3> _613()  {
    return new Tuple3<>(elem6, elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T3, T1> _631()  {
    return new Tuple3<>(elem6, elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T6, T1> _361()  {
    return new Tuple3<>(elem3, elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T1, T6> _316()  {
    return new Tuple3<>(elem3, elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T3, T6> _236()  {
    return new Tuple3<>(elem2, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T6, T3> _263()  {
    return new Tuple3<>(elem2, elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T2, T3> _623()  {
    return new Tuple3<>(elem6, elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T3, T2> _632()  {
    return new Tuple3<>(elem6, elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T6, T2> _362()  {
    return new Tuple3<>(elem3, elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T2, T6> _326()  {
    return new Tuple3<>(elem3, elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T4, T6> _146()  {
    return new Tuple3<>(elem1, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T6, T4> _164()  {
    return new Tuple3<>(elem1, elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T1, T4> _614()  {
    return new Tuple3<>(elem6, elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T4, T1> _641()  {
    return new Tuple3<>(elem6, elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T6, T1> _461()  {
    return new Tuple3<>(elem4, elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T1, T6> _416()  {
    return new Tuple3<>(elem4, elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T4, T6> _246()  {
    return new Tuple3<>(elem2, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T6, T4> _264()  {
    return new Tuple3<>(elem2, elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T2, T4> _624()  {
    return new Tuple3<>(elem6, elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T4, T2> _642()  {
    return new Tuple3<>(elem6, elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T6, T2> _462()  {
    return new Tuple3<>(elem4, elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T2, T6> _426()  {
    return new Tuple3<>(elem4, elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T3, T4, T6> _346()  {
    return new Tuple3<>(elem3, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T3, T6, T4> _364()  {
    return new Tuple3<>(elem3, elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T3, T4> _634()  {
    return new Tuple3<>(elem6, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T4, T3> _643()  {
    return new Tuple3<>(elem6, elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T6, T3> _463()  {
    return new Tuple3<>(elem4, elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T3, T6> _436()  {
    return new Tuple3<>(elem4, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T5, T6> _156()  {
    return new Tuple3<>(elem1, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T6, T5> _165()  {
    return new Tuple3<>(elem1, elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T1, T5> _615()  {
    return new Tuple3<>(elem6, elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T5, T1> _651()  {
    return new Tuple3<>(elem6, elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T5, T6, T1> _561()  {
    return new Tuple3<>(elem5, elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T5, T1, T6> _516()  {
    return new Tuple3<>(elem5, elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T5, T6> _256()  {
    return new Tuple3<>(elem2, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T2, T6, T5> _265()  {
    return new Tuple3<>(elem2, elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T2, T5> _625()  {
    return new Tuple3<>(elem6, elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T5, T2> _652()  {
    return new Tuple3<>(elem6, elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T6, T2> _562()  {
    return new Tuple3<>(elem5, elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T2, T6> _526()  {
    return new Tuple3<>(elem5, elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T3, T5, T6> _356()  {
    return new Tuple3<>(elem3, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T3, T6, T5> _365()  {
    return new Tuple3<>(elem3, elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T3, T5> _635()  {
    return new Tuple3<>(elem6, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T5, T3> _653()  {
    return new Tuple3<>(elem6, elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T6, T3> _563()  {
    return new Tuple3<>(elem5, elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T3, T6> _536()  {
    return new Tuple3<>(elem5, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T4, T5, T6> _456()  {
    return new Tuple3<>(elem4, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T4, T6, T5> _465()  {
    return new Tuple3<>(elem4, elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T4, T5> _645()  {
    return new Tuple3<>(elem6, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T5, T4> _654()  {
    return new Tuple3<>(elem6, elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T6, T4> _564()  {
    return new Tuple3<>(elem5, elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T4, T6> _546()  {
    return new Tuple3<>(elem5, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T1, T2, T7> _127()  {
    return new Tuple3<>(elem1, elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T7, T2> _172()  {
    return new Tuple3<>(elem1, elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T7, T1, T2> _712()  {
    return new Tuple3<>(elem7, elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T7, T2, T1> _721()  {
    return new Tuple3<>(elem7, elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T7, T1> _271()  {
    return new Tuple3<>(elem2, elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T2, T1, T7> _217()  {
    return new Tuple3<>(elem2, elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T3, T7> _137()  {
    return new Tuple3<>(elem1, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T7, T3> _173()  {
    return new Tuple3<>(elem1, elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T7, T1, T3> _713()  {
    return new Tuple3<>(elem7, elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T7, T3, T1> _731()  {
    return new Tuple3<>(elem7, elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T7, T1> _371()  {
    return new Tuple3<>(elem3, elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T3, T1, T7> _317()  {
    return new Tuple3<>(elem3, elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T3, T7> _237()  {
    return new Tuple3<>(elem2, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T7, T3> _273()  {
    return new Tuple3<>(elem2, elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T7, T2, T3> _723()  {
    return new Tuple3<>(elem7, elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T7, T3, T2> _732()  {
    return new Tuple3<>(elem7, elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T7, T2> _372()  {
    return new Tuple3<>(elem3, elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T3, T2, T7> _327()  {
    return new Tuple3<>(elem3, elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T4, T7> _147()  {
    return new Tuple3<>(elem1, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T7, T4> _174()  {
    return new Tuple3<>(elem1, elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T1, T4> _714()  {
    return new Tuple3<>(elem7, elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T4, T1> _741()  {
    return new Tuple3<>(elem7, elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T7, T1> _471()  {
    return new Tuple3<>(elem4, elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T4, T1, T7> _417()  {
    return new Tuple3<>(elem4, elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T4, T7> _247()  {
    return new Tuple3<>(elem2, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T7, T4> _274()  {
    return new Tuple3<>(elem2, elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T2, T4> _724()  {
    return new Tuple3<>(elem7, elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T4, T2> _742()  {
    return new Tuple3<>(elem7, elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T7, T2> _472()  {
    return new Tuple3<>(elem4, elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T4, T2, T7> _427()  {
    return new Tuple3<>(elem4, elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T4, T7> _347()  {
    return new Tuple3<>(elem3, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T7, T4> _374()  {
    return new Tuple3<>(elem3, elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T3, T4> _734()  {
    return new Tuple3<>(elem7, elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T7, T4, T3> _743()  {
    return new Tuple3<>(elem7, elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T7, T3> _473()  {
    return new Tuple3<>(elem4, elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T4, T3, T7> _437()  {
    return new Tuple3<>(elem4, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T5, T7> _157()  {
    return new Tuple3<>(elem1, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T7, T5> _175()  {
    return new Tuple3<>(elem1, elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T1, T5> _715()  {
    return new Tuple3<>(elem7, elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T5, T1> _751()  {
    return new Tuple3<>(elem7, elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T5, T7, T1> _571()  {
    return new Tuple3<>(elem5, elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T5, T1, T7> _517()  {
    return new Tuple3<>(elem5, elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T5, T7> _257()  {
    return new Tuple3<>(elem2, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T7, T5> _275()  {
    return new Tuple3<>(elem2, elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T2, T5> _725()  {
    return new Tuple3<>(elem7, elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T5, T2> _752()  {
    return new Tuple3<>(elem7, elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T7, T2> _572()  {
    return new Tuple3<>(elem5, elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T5, T2, T7> _527()  {
    return new Tuple3<>(elem5, elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T5, T7> _357()  {
    return new Tuple3<>(elem3, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T7, T5> _375()  {
    return new Tuple3<>(elem3, elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T3, T5> _735()  {
    return new Tuple3<>(elem7, elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T5, T3> _753()  {
    return new Tuple3<>(elem7, elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T7, T3> _573()  {
    return new Tuple3<>(elem5, elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T5, T3, T7> _537()  {
    return new Tuple3<>(elem5, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T4, T5, T7> _457()  {
    return new Tuple3<>(elem4, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T4, T7, T5> _475()  {
    return new Tuple3<>(elem4, elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T4, T5> _745()  {
    return new Tuple3<>(elem7, elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T7, T5, T4> _754()  {
    return new Tuple3<>(elem7, elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T7, T4> _574()  {
    return new Tuple3<>(elem5, elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T5, T4, T7> _547()  {
    return new Tuple3<>(elem5, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T6, T7> _167()  {
    return new Tuple3<>(elem1, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T1, T7, T6> _176()  {
    return new Tuple3<>(elem1, elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T1, T6> _716()  {
    return new Tuple3<>(elem7, elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T6, T1> _761()  {
    return new Tuple3<>(elem7, elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T6, T7, T1> _671()  {
    return new Tuple3<>(elem6, elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple3<T6, T1, T7> _617()  {
    return new Tuple3<>(elem6, elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T6, T7> _267()  {
    return new Tuple3<>(elem2, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T2, T7, T6> _276()  {
    return new Tuple3<>(elem2, elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T2, T6> _726()  {
    return new Tuple3<>(elem7, elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T6, T2> _762()  {
    return new Tuple3<>(elem7, elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T6, T7, T2> _672()  {
    return new Tuple3<>(elem6, elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple3<T6, T2, T7> _627()  {
    return new Tuple3<>(elem6, elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T6, T7> _367()  {
    return new Tuple3<>(elem3, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T3, T7, T6> _376()  {
    return new Tuple3<>(elem3, elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T3, T6> _736()  {
    return new Tuple3<>(elem7, elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T6, T3> _763()  {
    return new Tuple3<>(elem7, elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T7, T3> _673()  {
    return new Tuple3<>(elem6, elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple3<T6, T3, T7> _637()  {
    return new Tuple3<>(elem6, elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T4, T6, T7> _467()  {
    return new Tuple3<>(elem4, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T4, T7, T6> _476()  {
    return new Tuple3<>(elem4, elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T4, T6> _746()  {
    return new Tuple3<>(elem7, elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T6, T4> _764()  {
    return new Tuple3<>(elem7, elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T7, T4> _674()  {
    return new Tuple3<>(elem6, elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple3<T6, T4, T7> _647()  {
    return new Tuple3<>(elem6, elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T5, T6, T7> _567()  {
    return new Tuple3<>(elem5, elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple3<T5, T7, T6> _576()  {
    return new Tuple3<>(elem5, elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T5, T6> _756()  {
    return new Tuple3<>(elem7, elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple3<T7, T6, T5> _765()  {
    return new Tuple3<>(elem7, elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T7, T5> _675()  {
    return new Tuple3<>(elem6, elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple3<T6, T5, T7> _657()  {
    return new Tuple3<>(elem6, elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T1, T2> _12()  {
    return new Tuple2<>(elem1, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T2, T1> _21()  {
    return new Tuple2<>(elem2, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T1, T3> _13()  {
    return new Tuple2<>(elem1, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T3, T1> _31()  {
    return new Tuple2<>(elem3, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T2, T3> _23()  {
    return new Tuple2<>(elem2, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T3, T2> _32()  {
    return new Tuple2<>(elem3, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T1, T4> _14()  {
    return new Tuple2<>(elem1, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T4, T1> _41()  {
    return new Tuple2<>(elem4, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T2, T4> _24()  {
    return new Tuple2<>(elem2, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T4, T2> _42()  {
    return new Tuple2<>(elem4, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T3, T4> _34()  {
    return new Tuple2<>(elem3, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T4, T3> _43()  {
    return new Tuple2<>(elem4, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T1, T5> _15()  {
    return new Tuple2<>(elem1, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T5, T1> _51()  {
    return new Tuple2<>(elem5, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T2, T5> _25()  {
    return new Tuple2<>(elem2, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T5, T2> _52()  {
    return new Tuple2<>(elem5, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T3, T5> _35()  {
    return new Tuple2<>(elem3, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T5, T3> _53()  {
    return new Tuple2<>(elem5, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T4, T5> _45()  {
    return new Tuple2<>(elem4, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T5, T4> _54()  {
    return new Tuple2<>(elem5, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T1, T6> _16()  {
    return new Tuple2<>(elem1, elem6);
  }

  @NotNull
  @Override
  public Tuple2<T6, T1> _61()  {
    return new Tuple2<>(elem6, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T2, T6> _26()  {
    return new Tuple2<>(elem2, elem6);
  }

  @NotNull
  @Override
  public Tuple2<T6, T2> _62()  {
    return new Tuple2<>(elem6, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T3, T6> _36()  {
    return new Tuple2<>(elem3, elem6);
  }

  @NotNull
  @Override
  public Tuple2<T6, T3> _63()  {
    return new Tuple2<>(elem6, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T4, T6> _46()  {
    return new Tuple2<>(elem4, elem6);
  }

  @NotNull
  @Override
  public Tuple2<T6, T4> _64()  {
    return new Tuple2<>(elem6, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T5, T6> _56()  {
    return new Tuple2<>(elem5, elem6);
  }

  @NotNull
  @Override
  public Tuple2<T6, T5> _65()  {
    return new Tuple2<>(elem6, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T1, T7> _17()  {
    return new Tuple2<>(elem1, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T1> _71()  {
    return new Tuple2<>(elem7, elem1);
  }

  @NotNull
  @Override
  public Tuple2<T2, T7> _27()  {
    return new Tuple2<>(elem2, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T2> _72()  {
    return new Tuple2<>(elem7, elem2);
  }

  @NotNull
  @Override
  public Tuple2<T3, T7> _37()  {
    return new Tuple2<>(elem3, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T3> _73()  {
    return new Tuple2<>(elem7, elem3);
  }

  @NotNull
  @Override
  public Tuple2<T4, T7> _47()  {
    return new Tuple2<>(elem4, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T4> _74()  {
    return new Tuple2<>(elem7, elem4);
  }

  @NotNull
  @Override
  public Tuple2<T5, T7> _57()  {
    return new Tuple2<>(elem5, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T5> _75()  {
    return new Tuple2<>(elem7, elem5);
  }

  @NotNull
  @Override
  public Tuple2<T6, T7> _67()  {
    return new Tuple2<>(elem6, elem7);
  }

  @NotNull
  @Override
  public Tuple2<T7, T6> _76()  {
    return new Tuple2<>(elem7, elem6);
  }

  @NotNull
  @Override
  public Tuple7<T1, T2, T3, T4, T5, T6, T7> frozenNotNull()
  {
    return this;
  }

  /**
   * Create a 7-tuple from this one where the first element is exchanged. 
   * @param e1 new first element
   * @return tuple with exchanged element
   * @param <E1> type of exchanged first element
   */
  @NotNull
  public <E1> Tuple7<E1, T2, T3, T4, T5, T6, T7> x1(@NotNull E1 e1)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second element is exchanged. 
   * @param e2 new second element
   * @return tuple with exchanged element
   * @param <E2> type of exchanged second element
   */
  @NotNull
  public <E2> Tuple7<T1, E2, T3, T4, T5, T6, T7> x2(@NotNull E2 e2)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third element is exchanged. 
   * @param e3 new third element
   * @return tuple with exchanged element
   * @param <E3> type of exchanged third element
   */
  @NotNull
  public <E3> Tuple7<T1, T2, E3, T4, T5, T6, T7> x3(@NotNull E3 e3)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fourth element is exchanged. 
   * @param e4 new fourth element
   * @return tuple with exchanged element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E4> Tuple7<T1, T2, T3, E4, T5, T6, T7> x4(@NotNull E4 e4)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fifth element is exchanged. 
   * @param e5 new fifth element
   * @return tuple with exchanged element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E5> Tuple7<T1, T2, T3, T4, E5, T6, T7> x5(@NotNull E5 e5)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the sixth element is exchanged. 
   * @param e6 new sixth element
   * @return tuple with exchanged element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E6> Tuple7<T1, T2, T3, T4, T5, E6, T7> x6(@NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the seventh element is exchanged. 
   * @param e7 new seventh element
   * @return tuple with exchanged element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E7> Tuple7<T1, T2, T3, T4, T5, T6, E7> x7(@NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first and second elements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   */
  @NotNull
  public <E1, E2> Tuple7<E1, E2, T3, T4, T5, T6, T7> x12(@NotNull E1 e1, @NotNull E2 e2)  {
    return new Tuple7<>(e1, e2, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first and third elements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   */
  @NotNull
  public <E1, E3> Tuple7<E1, T2, E3, T4, T5, T6, T7> x13(@NotNull E1 e1, @NotNull E3 e3)  {
    return new Tuple7<>(e1, elem2, e3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second and third elements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   */
  @NotNull
  public <E2, E3> Tuple7<T1, E2, E3, T4, T5, T6, T7> x23(@NotNull E2 e2, @NotNull E3 e3)  {
    return new Tuple7<>(elem1, e2, e3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first and fourth elements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E1, E4> Tuple7<E1, T2, T3, E4, T5, T6, T7> x14(@NotNull E1 e1, @NotNull E4 e4)  {
    return new Tuple7<>(e1, elem2, elem3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second and fourth elements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E2, E4> Tuple7<T1, E2, T3, E4, T5, T6, T7> x24(@NotNull E2 e2, @NotNull E4 e4)  {
    return new Tuple7<>(elem1, e2, elem3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third and fourth elements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E3, E4> Tuple7<T1, T2, E3, E4, T5, T6, T7> x34(@NotNull E3 e3, @NotNull E4 e4)  {
    return new Tuple7<>(elem1, elem2, e3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first and fifth elements are exchanged. 
   * @param e1 new first element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E5> Tuple7<E1, T2, T3, T4, E5, T6, T7> x15(@NotNull E1 e1, @NotNull E5 e5)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second and fifth elements are exchanged. 
   * @param e2 new second element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E2, E5> Tuple7<T1, E2, T3, T4, E5, T6, T7> x25(@NotNull E2 e2, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third and fifth elements are exchanged. 
   * @param e3 new third element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E3, E5> Tuple7<T1, T2, E3, T4, E5, T6, T7> x35(@NotNull E3 e3, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fourth and fifth elements are exchanged. 
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E4, E5> Tuple7<T1, T2, T3, E4, E5, T6, T7> x45(@NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first and sixth elements are exchanged. 
   * @param e1 new first element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E6> Tuple7<E1, T2, T3, T4, T5, E6, T7> x16(@NotNull E1 e1, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second and sixth elements are exchanged. 
   * @param e2 new second element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E6> Tuple7<T1, E2, T3, T4, T5, E6, T7> x26(@NotNull E2 e2, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third and sixth elements are exchanged. 
   * @param e3 new third element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E3, E6> Tuple7<T1, T2, E3, T4, T5, E6, T7> x36(@NotNull E3 e3, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fourth and sixth elements are exchanged. 
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E4, E6> Tuple7<T1, T2, T3, E4, T5, E6, T7> x46(@NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fifth and sixth elements are exchanged. 
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E5, E6> Tuple7<T1, T2, T3, T4, E5, E6, T7> x56(@NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first and seventh elements are exchanged. 
   * @param e1 new first element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E7> Tuple7<E1, T2, T3, T4, T5, T6, E7> x17(@NotNull E1 e1, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second and seventh elements are exchanged. 
   * @param e2 new second element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E7> Tuple7<T1, E2, T3, T4, T5, T6, E7> x27(@NotNull E2 e2, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third and seventh elements are exchanged. 
   * @param e3 new third element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E7> Tuple7<T1, T2, E3, T4, T5, T6, E7> x37(@NotNull E3 e3, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fourth and seventh elements are exchanged. 
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E4, E7> Tuple7<T1, T2, T3, E4, T5, T6, E7> x47(@NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fifth and seventh elements are exchanged. 
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E5, E7> Tuple7<T1, T2, T3, T4, E5, T6, E7> x57(@NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the sixth and seventh elements are exchanged. 
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E6, E7> Tuple7<T1, T2, T3, T4, T5, E6, E7> x67(@NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, and thirdelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   */
  @NotNull
  public <E1, E2, E3> Tuple7<E1, E2, E3, T4, T5, T6, T7> x123(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3)  {
    return new Tuple7<>(e1, e2, e3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, and fourthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E1, E2, E4> Tuple7<E1, E2, T3, E4, T5, T6, T7> x124(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4)  {
    return new Tuple7<>(e1, e2, elem3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, and fourthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E1, E3, E4> Tuple7<E1, T2, E3, E4, T5, T6, T7> x134(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4)  {
    return new Tuple7<>(e1, elem2, e3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, and fourthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E2, E3, E4> Tuple7<T1, E2, E3, E4, T5, T6, T7> x234(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4)  {
    return new Tuple7<>(elem1, e2, e3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E2, E5> Tuple7<E1, E2, T3, T4, E5, T6, T7> x125(@NotNull E1 e1, @NotNull E2 e2, @NotNull E5 e5)  {
    return new Tuple7<>(e1, e2, elem3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E3, E5> Tuple7<E1, T2, E3, T4, E5, T6, T7> x135(@NotNull E1 e1, @NotNull E3 e3, @NotNull E5 e5)  {
    return new Tuple7<>(e1, elem2, e3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, and fifthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E2, E3, E5> Tuple7<T1, E2, E3, T4, E5, T6, T7> x235(@NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, e2, e3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E4, E5> Tuple7<E1, T2, T3, E4, E5, T6, T7> x145(@NotNull E1 e1, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(e1, elem2, elem3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, and fifthelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E2, E4, E5> Tuple7<T1, E2, T3, E4, E5, T6, T7> x245(@NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, e2, elem3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, and fifthelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E3, E4, E5> Tuple7<T1, T2, E3, E4, E5, T6, T7> x345(@NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, elem2, e3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E6> Tuple7<E1, E2, T3, T4, T5, E6, T7> x126(@NotNull E1 e1, @NotNull E2 e2, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, elem3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E3, E6> Tuple7<E1, T2, E3, T4, T5, E6, T7> x136(@NotNull E1 e1, @NotNull E3 e3, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, e3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E3, E6> Tuple7<T1, E2, E3, T4, T5, E6, T7> x236(@NotNull E2 e2, @NotNull E3 e3, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, e3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E4, E6> Tuple7<E1, T2, T3, E4, T5, E6, T7> x146(@NotNull E1 e1, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, elem3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E4, E6> Tuple7<T1, E2, T3, E4, T5, E6, T7> x246(@NotNull E2 e2, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, elem3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, and sixthelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E3, E4, E6> Tuple7<T1, T2, E3, E4, T5, E6, T7> x346(@NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, e3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E5, E6> Tuple7<E1, T2, T3, T4, E5, E6, T7> x156(@NotNull E1 e1, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, fifth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E5, E6> Tuple7<T1, E2, T3, T4, E5, E6, T7> x256(@NotNull E2 e2, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third, fifth, and sixthelements are exchanged. 
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E3, E5, E6> Tuple7<T1, T2, E3, T4, E5, E6, T7> x356(@NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the fourth, fifth, and sixthelements are exchanged. 
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E4, E5, E6> Tuple7<T1, T2, T3, E4, E5, E6, T7> x456(@NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E7> Tuple7<E1, E2, T3, T4, T5, T6, E7> x127(@NotNull E1 e1, @NotNull E2 e2, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E7> Tuple7<E1, T2, E3, T4, T5, T6, E7> x137(@NotNull E1 e1, @NotNull E3 e3, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E7> Tuple7<T1, E2, E3, T4, T5, T6, E7> x237(@NotNull E2 e2, @NotNull E3 e3, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E4, E7> Tuple7<E1, T2, T3, E4, T5, T6, E7> x147(@NotNull E1 e1, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E4, E7> Tuple7<T1, E2, T3, E4, T5, T6, E7> x247(@NotNull E2 e2, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E4, E7> Tuple7<T1, T2, E3, E4, T5, T6, E7> x347(@NotNull E3 e3, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E5, E7> Tuple7<E1, T2, T3, T4, E5, T6, E7> x157(@NotNull E1 e1, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fifth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E5, E7> Tuple7<T1, E2, T3, T4, E5, T6, E7> x257(@NotNull E2 e2, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fifth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E5, E7> Tuple7<T1, T2, E3, T4, E5, T6, E7> x357(@NotNull E3 e3, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fourth, fifth, and seventhelements are exchanged. 
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E4, E5, E7> Tuple7<T1, T2, T3, E4, E5, T6, E7> x457(@NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E6, E7> Tuple7<E1, T2, T3, T4, T5, E6, E7> x167(@NotNull E1 e1, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E6, E7> Tuple7<T1, E2, T3, T4, T5, E6, E7> x267(@NotNull E2 e2, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, sixth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E6, E7> Tuple7<T1, T2, E3, T4, T5, E6, E7> x367(@NotNull E3 e3, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fourth, sixth, and seventhelements are exchanged. 
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E4, E6, E7> Tuple7<T1, T2, T3, E4, T5, E6, E7> x467(@NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fifth, sixth, and seventhelements are exchanged. 
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E5, E6, E7> Tuple7<T1, T2, T3, T4, E5, E6, E7> x567(@NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, and fourthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   */
  @NotNull
  public <E1, E2, E3, E4> Tuple7<E1, E2, E3, E4, T5, T6, T7> x1234(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4)  {
    return new Tuple7<>(e1, e2, e3, e4, elem5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E2, E3, E5> Tuple7<E1, E2, E3, T4, E5, T6, T7> x1235(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5)  {
    return new Tuple7<>(e1, e2, e3, elem4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E2, E4, E5> Tuple7<E1, E2, T3, E4, E5, T6, T7> x1245(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(e1, e2, elem3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E3, E4, E5> Tuple7<E1, T2, E3, E4, E5, T6, T7> x1345(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(e1, elem2, e3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, and fifthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E2, E3, E4, E5> Tuple7<T1, E2, E3, E4, E5, T6, T7> x2345(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(elem1, e2, e3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E3, E6> Tuple7<E1, E2, E3, T4, T5, E6, T7> x1236(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, e3, elem4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E4, E6> Tuple7<E1, E2, T3, E4, T5, E6, T7> x1246(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, elem3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E3, E4, E6> Tuple7<E1, T2, E3, E4, T5, E6, T7> x1346(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, e3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E3, E4, E6> Tuple7<T1, E2, E3, E4, T5, E6, T7> x2346(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, e3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E5, E6> Tuple7<E1, E2, T3, T4, E5, E6, T7> x1256(@NotNull E1 e1, @NotNull E2 e2, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, elem3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E3, E5, E6> Tuple7<E1, T2, E3, T4, E5, E6, T7> x1356(@NotNull E1 e1, @NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, e3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fifth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E3, E5, E6> Tuple7<T1, E2, E3, T4, E5, E6, T7> x2356(@NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, e3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E4, E5, E6> Tuple7<E1, T2, T3, E4, E5, E6, T7> x1456(@NotNull E1 e1, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, elem3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, fifth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E4, E5, E6> Tuple7<T1, E2, T3, E4, E5, E6, T7> x2456(@NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, elem3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, fifth, and sixthelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E3, E4, E5, E6> Tuple7<T1, T2, E3, E4, E5, E6, T7> x3456(@NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, elem2, e3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E3, E7> Tuple7<E1, E2, E3, T4, T5, T6, E7> x1237(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, e3, elem4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E4, E7> Tuple7<E1, E2, T3, E4, T5, T6, E7> x1247(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E4, E7> Tuple7<E1, T2, E3, E4, T5, T6, E7> x1347(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E4, E7> Tuple7<T1, E2, E3, E4, T5, T6, E7> x2347(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E5, E7> Tuple7<E1, E2, T3, T4, E5, T6, E7> x1257(@NotNull E1 e1, @NotNull E2 e2, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E5, E7> Tuple7<E1, T2, E3, T4, E5, T6, E7> x1357(@NotNull E1 e1, @NotNull E3 e3, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fifth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E5, E7> Tuple7<T1, E2, E3, T4, E5, T6, E7> x2357(@NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E4, E5, E7> Tuple7<E1, T2, T3, E4, E5, T6, E7> x1457(@NotNull E1 e1, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, fifth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E4, E5, E7> Tuple7<T1, E2, T3, E4, E5, T6, E7> x2457(@NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, fifth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E4, E5, E7> Tuple7<T1, T2, E3, E4, E5, T6, E7> x3457(@NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E6, E7> Tuple7<E1, E2, T3, T4, T5, E6, E7> x1267(@NotNull E1 e1, @NotNull E2 e2, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E6, E7> Tuple7<E1, T2, E3, T4, T5, E6, E7> x1367(@NotNull E1 e1, @NotNull E3 e3, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E6, E7> Tuple7<T1, E2, E3, T4, T5, E6, E7> x2367(@NotNull E2 e2, @NotNull E3 e3, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E4, E6, E7> Tuple7<E1, T2, T3, E4, T5, E6, E7> x1467(@NotNull E1 e1, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E4, E6, E7> Tuple7<T1, E2, T3, E4, T5, E6, E7> x2467(@NotNull E2 e2, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, sixth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E4, E6, E7> Tuple7<T1, T2, E3, E4, T5, E6, E7> x3467(@NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fifth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E5, E6, E7> Tuple7<E1, T2, T3, T4, E5, E6, E7> x1567(@NotNull E1 e1, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fifth, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E5, E6, E7> Tuple7<T1, E2, T3, T4, E5, E6, E7> x2567(@NotNull E2 e2, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fifth, sixth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E5, E6, E7> Tuple7<T1, T2, E3, T4, E5, E6, E7> x3567(@NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the fourth, fifth, sixth, and seventhelements are exchanged. 
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E4, E5, E6, E7> Tuple7<T1, T2, T3, E4, E5, E6, E7> x4567(@NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, elem3, e4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, fourth, and fifthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   */
  @NotNull
  public <E1, E2, E3, E4, E5> Tuple7<E1, E2, E3, E4, E5, T6, T7> x12345(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5)  {
    return new Tuple7<>(e1, e2, e3, e4, e5, elem6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, fourth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E3, E4, E6> Tuple7<E1, E2, E3, E4, T5, E6, T7> x12346(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, e3, e4, elem5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E3, E5, E6> Tuple7<E1, E2, E3, T4, E5, E6, T7> x12356(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, e3, elem4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E2, E4, E5, E6> Tuple7<E1, E2, T3, E4, E5, E6, T7> x12456(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, e2, elem3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, fifth, and sixthelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E1, E3, E4, E5, E6> Tuple7<E1, T2, E3, E4, E5, E6, T7> x13456(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(e1, elem2, e3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, fifth, and sixthelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   */
  @NotNull
  public <E2, E3, E4, E5, E6> Tuple7<T1, E2, E3, E4, E5, E6, T7> x23456(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6)  {
    return new Tuple7<>(elem1, e2, e3, e4, e5, e6, elem7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, fourth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E3, E4, E7> Tuple7<E1, E2, E3, E4, T5, T6, E7> x12347(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, e3, e4, elem5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E3, E5, E7> Tuple7<E1, E2, E3, T4, E5, T6, E7> x12357(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, e3, elem4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E4, E5, E7> Tuple7<E1, E2, T3, E4, E5, T6, E7> x12457(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, fifth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E4, E5, E7> Tuple7<E1, T2, E3, E4, E5, T6, E7> x13457(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, fifth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E4, E5, E7> Tuple7<T1, E2, E3, E4, E5, T6, E7> x23457(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, e4, e5, elem6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, third, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e3 new third element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E3, E6, E7> Tuple7<E1, E2, E3, T4, T5, E6, E7> x12367(@NotNull E1 e1, @NotNull E2 e2, @NotNull E3 e3, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, e3, elem4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fourth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E4, E6, E7> Tuple7<E1, E2, T3, E4, T5, E6, E7> x12467(@NotNull E1 e1, @NotNull E2 e2, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fourth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E4, E6, E7> Tuple7<E1, T2, E3, E4, T5, E6, E7> x13467(@NotNull E1 e1, @NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fourth, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E4, E6, E7> Tuple7<T1, E2, E3, E4, T5, E6, E7> x23467(@NotNull E2 e2, @NotNull E3 e3, @NotNull E4 e4, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, e4, elem5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, second, fifth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e2 new second element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E2> type of exchanged second element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E2, E5, E6, E7> Tuple7<E1, E2, T3, T4, E5, E6, E7> x12567(@NotNull E1 e1, @NotNull E2 e2, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, e2, elem3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, third, fifth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E3, E5, E6, E7> Tuple7<E1, T2, E3, T4, E5, E6, E7> x13567(@NotNull E1 e1, @NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, e3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, third, fifth, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e3 new third element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E3> type of exchanged third element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E3, E5, E6, E7> Tuple7<T1, E2, E3, T4, E5, E6, E7> x23567(@NotNull E2 e2, @NotNull E3 e3, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, e3, elem4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the first, fourth, fifth, sixth, and seventhelements are exchanged. 
   * @param e1 new first element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E1> type of exchanged first element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E1, E4, E5, E6, E7> Tuple7<E1, T2, T3, E4, E5, E6, E7> x14567(@NotNull E1 e1, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(e1, elem2, elem3, e4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the second, fourth, fifth, sixth, and seventhelements are exchanged. 
   * @param e2 new second element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E2> type of exchanged second element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E2, E4, E5, E6, E7> Tuple7<T1, E2, T3, E4, E5, E6, E7> x24567(@NotNull E2 e2, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, e2, elem3, e4, e5, e6, e7);
  }

  /**
   * Create a 7-tuple from this one where the third, fourth, fifth, sixth, and seventhelements are exchanged. 
   * @param e3 new third element
   * @param e4 new fourth element
   * @param e5 new fifth element
   * @param e6 new sixth element
   * @param e7 new seventh element
   * @return tuple with exchanged elements
   * @param <E3> type of exchanged third element
   * @param <E4> type of exchanged fourth element
   * @param <E5> type of exchanged fifth element
   * @param <E6> type of exchanged sixth element
   * @param <E7> type of exchanged seventh element
   */
  @NotNull
  public <E3, E4, E5, E6, E7> Tuple7<T1, T2, E3, E4, E5, E6, E7> x34567(@NotNull E3 e3, @NotNull E4 e4, @NotNull E5 e5, @NotNull E6 e6, @NotNull E7 e7)  {
    return new Tuple7<>(elem1, elem2, e3, e4, e5, e6, e7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new first element.
   * @param e1 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T, T1, T2, T3, T4, T5, T6, T7> i1(@NotNull T e1)
  {
    return new Tuple8<>(e1, elem1, elem2, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new second element.
   * @param e2 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T, T2, T3, T4, T5, T6, T7> i2(@NotNull T e2)
  {
    return new Tuple8<>(elem1, e2, elem2, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new third element.
   * @param e3 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T, T3, T4, T5, T6, T7> i3(@NotNull T e3)
  {
    return new Tuple8<>(elem1, elem2, e3, elem3, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new fourth element.
   * @param e4 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T3, T, T4, T5, T6, T7> i4(@NotNull T e4)
  {
    return new Tuple8<>(elem1, elem2, elem3, e4, elem4, elem5, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new fifth element.
   * @param e5 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T3, T4, T, T5, T6, T7> i5(@NotNull T e5)
  {
    return new Tuple8<>(elem1, elem2, elem3, elem4, e5, elem5, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new sixth element.
   * @param e6 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T3, T4, T5, T, T6, T7> i6(@NotNull T e6)
  {
    return new Tuple8<>(elem1, elem2, elem3, elem4, elem5, e6, elem6, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by inserting a new seventh element.
   * @param e7 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T3, T4, T5, T6, T, T7> i7(@NotNull T e7)
  {
    return new Tuple8<>(elem1, elem2, elem3, elem4, elem5, elem6, e7, elem7);
  }

  /**
   * Create a 8-tuple from this 7-tuple by adding a new eighth element.
   * @param e8 new element
   * @param <T> new element type
   * @return 8-tuple
   */
  @NotNull
  public <T> Tuple8<T1, T2, T3, T4, T5, T6, T7, T> i8(@NotNull T e8)
  {
    return new Tuple8<>(elem1, elem2, elem3, elem4, elem5, elem6, elem7, e8);
  }

  @NotNull
  @Override
  public String toString()
  {
    return ITuple7.toString("Tuple7", this);
  }

}
