// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021 - 2022  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.tuple;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.function.*;

import java.util.Objects;
import java.util.function.*;

/**
 * General interface for immutable 9-tuples.
 * <p>
 * This is sometimes useful to access either {@link Tuple9} or {@link NTuple9} in a general way,
 * although in most cases the concrete implementations are usually preferable.
 * <p>
 * If you want to iterate over a tuple or access its elements by index
 * (note that both is only possible for a common super type of the tuple's types)
 * {@link de.caff.generics.Indexable#viewTuple(ITuple9)} will come to help.
 * <p>
 * Note that this class is automatically created by {@code tools.TupleClassCreator} (not yet public).
 *
 * @param <T1> type of first element
 * @param <T2> type of second element
 * @param <T3> type of third element
 * @param <T4> type of fourth element
 * @param <T5> type of fifth element
 * @param <T6> type of sixth element
 * @param <T7> type of seventh element
 * @param <T8> type of eighth element
 * @param <T9> type of nineth element
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 17, 2021
 * @see Tuple9
 * @see NTuple9
 */
public interface ITuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
{
  /**
   * Get the first element.
   * @return first element
   */
  T1 _1();

  /**
   * Get the second element.
   * @return second element
   */
  T2 _2();

  /**
   * Get the third element.
   * @return third element
   */
  T3 _3();

  /**
   * Get the fourth element.
   * @return fourth element
   */
  T4 _4();

  /**
   * Get the fifth element.
   * @return fifth element
   */
  T5 _5();

  /**
   * Get the sixth element.
   * @return sixth element
   */
  T6 _6();

  /**
   * Get the seventh element.
   * @return seventh element
   */
  T7 _7();

  /**
   * Get the eighth element.
   * @return eighth element
   */
  T8 _8();

  /**
   * Get the nineth element.
   * @return nineth element
   */
  T9 _9();

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T4, T5, T6, T7, T8> _12345678()  {
    return new ITuple8.Base<T1, T2, T3, T4, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _7()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _8()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T4, T5, T6, T7, T9> _12345679()  {
    return new ITuple8.Base<T1, T2, T3, T4, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _7()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T4, T5, T6, T8, T9> _12345689()  {
    return new ITuple8.Base<T1, T2, T3, T4, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T4, T5, T7, T8, T9> _12345789()  {
    return new ITuple8.Base<T1, T2, T3, T4, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T4, T6, T7, T8, T9> _12346789()  {
    return new ITuple8.Base<T1, T2, T3, T4, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T3, T5, T6, T7, T8, T9> _12356789()  {
    return new ITuple8.Base<T1, T2, T3, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T2, T4, T5, T6, T7, T8, T9> _12456789()  {
    return new ITuple8.Base<T1, T2, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T1, T3, T4, T5, T6, T7, T8, T9> _13456789()  {
    return new ITuple8.Base<T1, T3, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 8-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple8<T2, T3, T4, T5, T6, T7, T8, T9> _23456789()  {
    return new ITuple8.Base<T2, T3, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _8()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T6, T7> _1234567()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _7()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T6, T8> _1234568()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T7, T8> _1234578()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T6, T7, T8> _1234678()  {
    return new ITuple7.Base<T1, T2, T3, T4, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T5, T6, T7, T8> _1235678()  {
    return new ITuple7.Base<T1, T2, T3, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T4, T5, T6, T7, T8> _1245678()  {
    return new ITuple7.Base<T1, T2, T4, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T4, T5, T6, T7, T8> _1345678()  {
    return new ITuple7.Base<T1, T3, T4, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T4, T5, T6, T7, T8> _2345678()  {
    return new ITuple7.Base<T2, T3, T4, T5, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _7()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T6, T9> _1234569()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T7, T9> _1234579()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T6, T7, T9> _1234679()  {
    return new ITuple7.Base<T1, T2, T3, T4, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T5, T6, T7, T9> _1235679()  {
    return new ITuple7.Base<T1, T2, T3, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T4, T5, T6, T7, T9> _1245679()  {
    return new ITuple7.Base<T1, T2, T4, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T4, T5, T6, T7, T9> _1345679()  {
    return new ITuple7.Base<T1, T3, T4, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T4, T5, T6, T7, T9> _2345679()  {
    return new ITuple7.Base<T2, T3, T4, T5, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T5, T8, T9> _1234589()  {
    return new ITuple7.Base<T1, T2, T3, T4, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T6, T8, T9> _1234689()  {
    return new ITuple7.Base<T1, T2, T3, T4, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T5, T6, T8, T9> _1235689()  {
    return new ITuple7.Base<T1, T2, T3, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T4, T5, T6, T8, T9> _1245689()  {
    return new ITuple7.Base<T1, T2, T4, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T4, T5, T6, T8, T9> _1345689()  {
    return new ITuple7.Base<T1, T3, T4, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T4, T5, T6, T8, T9> _2345689()  {
    return new ITuple7.Base<T2, T3, T4, T5, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T4, T7, T8, T9> _1234789()  {
    return new ITuple7.Base<T1, T2, T3, T4, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T5, T7, T8, T9> _1235789()  {
    return new ITuple7.Base<T1, T2, T3, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T4, T5, T7, T8, T9> _1245789()  {
    return new ITuple7.Base<T1, T2, T4, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T4, T5, T7, T8, T9> _1345789()  {
    return new ITuple7.Base<T1, T3, T4, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T4, T5, T7, T8, T9> _2345789()  {
    return new ITuple7.Base<T2, T3, T4, T5, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T3, T6, T7, T8, T9> _1236789()  {
    return new ITuple7.Base<T1, T2, T3, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T4, T6, T7, T8, T9> _1246789()  {
    return new ITuple7.Base<T1, T2, T4, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T4, T6, T7, T8, T9> _1346789()  {
    return new ITuple7.Base<T1, T3, T4, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T4, T6, T7, T8, T9> _2346789()  {
    return new ITuple7.Base<T2, T3, T4, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T2, T5, T6, T7, T8, T9> _1256789()  {
    return new ITuple7.Base<T1, T2, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T3, T5, T6, T7, T8, T9> _1356789()  {
    return new ITuple7.Base<T1, T3, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T3, T5, T6, T7, T8, T9> _2356789()  {
    return new ITuple7.Base<T2, T3, T5, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T1, T4, T5, T6, T7, T8, T9> _1456789()  {
    return new ITuple7.Base<T1, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T2, T4, T5, T6, T7, T8, T9> _2456789()  {
    return new ITuple7.Base<T2, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 7-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple7<T3, T4, T5, T6, T7, T8, T9> _3456789()  {
    return new ITuple7.Base<T3, T4, T5, T6, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _7()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T5, T6> _123456()  {
    return new ITuple6.Base<T1, T2, T3, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T5, T7> _123457()  {
    return new ITuple6.Base<T1, T2, T3, T4, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T6, T7> _123467()  {
    return new ITuple6.Base<T1, T2, T3, T4, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T6, T7> _123567()  {
    return new ITuple6.Base<T1, T2, T3, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T6, T7> _124567()  {
    return new ITuple6.Base<T1, T2, T4, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T6, T7> _134567()  {
    return new ITuple6.Base<T1, T3, T4, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T6, T7> _234567()  {
    return new ITuple6.Base<T2, T3, T4, T5, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _6()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T5, T8> _123458()  {
    return new ITuple6.Base<T1, T2, T3, T4, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T6, T8> _123468()  {
    return new ITuple6.Base<T1, T2, T3, T4, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T6, T8> _123568()  {
    return new ITuple6.Base<T1, T2, T3, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T6, T8> _124568()  {
    return new ITuple6.Base<T1, T2, T4, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T6, T8> _134568()  {
    return new ITuple6.Base<T1, T3, T4, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T6, T8> _234568()  {
    return new ITuple6.Base<T2, T3, T4, T5, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T7, T8> _123478()  {
    return new ITuple6.Base<T1, T2, T3, T4, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T7, T8> _123578()  {
    return new ITuple6.Base<T1, T2, T3, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T7, T8> _124578()  {
    return new ITuple6.Base<T1, T2, T4, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T7, T8> _134578()  {
    return new ITuple6.Base<T1, T3, T4, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T7, T8> _234578()  {
    return new ITuple6.Base<T2, T3, T4, T5, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T6, T7, T8> _123678()  {
    return new ITuple6.Base<T1, T2, T3, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T6, T7, T8> _124678()  {
    return new ITuple6.Base<T1, T2, T4, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T6, T7, T8> _134678()  {
    return new ITuple6.Base<T1, T3, T4, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T6, T7, T8> _234678()  {
    return new ITuple6.Base<T2, T3, T4, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T5, T6, T7, T8> _125678()  {
    return new ITuple6.Base<T1, T2, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T5, T6, T7, T8> _135678()  {
    return new ITuple6.Base<T1, T3, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T5, T6, T7, T8> _235678()  {
    return new ITuple6.Base<T2, T3, T5, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T4, T5, T6, T7, T8> _145678()  {
    return new ITuple6.Base<T1, T4, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T4, T5, T6, T7, T8> _245678()  {
    return new ITuple6.Base<T2, T4, T5, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T4, T5, T6, T7, T8> _345678()  {
    return new ITuple6.Base<T3, T4, T5, T6, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _6()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T5, T9> _123459()  {
    return new ITuple6.Base<T1, T2, T3, T4, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T6, T9> _123469()  {
    return new ITuple6.Base<T1, T2, T3, T4, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T6, T9> _123569()  {
    return new ITuple6.Base<T1, T2, T3, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T6, T9> _124569()  {
    return new ITuple6.Base<T1, T2, T4, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T6, T9> _134569()  {
    return new ITuple6.Base<T1, T3, T4, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T6, T9> _234569()  {
    return new ITuple6.Base<T2, T3, T4, T5, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T7, T9> _123479()  {
    return new ITuple6.Base<T1, T2, T3, T4, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T7, T9> _123579()  {
    return new ITuple6.Base<T1, T2, T3, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T7, T9> _124579()  {
    return new ITuple6.Base<T1, T2, T4, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T7, T9> _134579()  {
    return new ITuple6.Base<T1, T3, T4, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T7, T9> _234579()  {
    return new ITuple6.Base<T2, T3, T4, T5, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T6, T7, T9> _123679()  {
    return new ITuple6.Base<T1, T2, T3, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T6, T7, T9> _124679()  {
    return new ITuple6.Base<T1, T2, T4, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T6, T7, T9> _134679()  {
    return new ITuple6.Base<T1, T3, T4, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T6, T7, T9> _234679()  {
    return new ITuple6.Base<T2, T3, T4, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T5, T6, T7, T9> _125679()  {
    return new ITuple6.Base<T1, T2, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T5, T6, T7, T9> _135679()  {
    return new ITuple6.Base<T1, T3, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T5, T6, T7, T9> _235679()  {
    return new ITuple6.Base<T2, T3, T5, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T4, T5, T6, T7, T9> _145679()  {
    return new ITuple6.Base<T1, T4, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T4, T5, T6, T7, T9> _245679()  {
    return new ITuple6.Base<T2, T4, T5, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T4, T5, T6, T7, T9> _345679()  {
    return new ITuple6.Base<T3, T4, T5, T6, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T4, T8, T9> _123489()  {
    return new ITuple6.Base<T1, T2, T3, T4, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T5, T8, T9> _123589()  {
    return new ITuple6.Base<T1, T2, T3, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T5, T8, T9> _124589()  {
    return new ITuple6.Base<T1, T2, T4, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T5, T8, T9> _134589()  {
    return new ITuple6.Base<T1, T3, T4, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T5, T8, T9> _234589()  {
    return new ITuple6.Base<T2, T3, T4, T5, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T6, T8, T9> _123689()  {
    return new ITuple6.Base<T1, T2, T3, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T6, T8, T9> _124689()  {
    return new ITuple6.Base<T1, T2, T4, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T6, T8, T9> _134689()  {
    return new ITuple6.Base<T1, T3, T4, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T6, T8, T9> _234689()  {
    return new ITuple6.Base<T2, T3, T4, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T5, T6, T8, T9> _125689()  {
    return new ITuple6.Base<T1, T2, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T5, T6, T8, T9> _135689()  {
    return new ITuple6.Base<T1, T3, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T5, T6, T8, T9> _235689()  {
    return new ITuple6.Base<T2, T3, T5, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T4, T5, T6, T8, T9> _145689()  {
    return new ITuple6.Base<T1, T4, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T4, T5, T6, T8, T9> _245689()  {
    return new ITuple6.Base<T2, T4, T5, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T4, T5, T6, T8, T9> _345689()  {
    return new ITuple6.Base<T3, T4, T5, T6, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T3, T7, T8, T9> _123789()  {
    return new ITuple6.Base<T1, T2, T3, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T4, T7, T8, T9> _124789()  {
    return new ITuple6.Base<T1, T2, T4, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T4, T7, T8, T9> _134789()  {
    return new ITuple6.Base<T1, T3, T4, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T4, T7, T8, T9> _234789()  {
    return new ITuple6.Base<T2, T3, T4, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T5, T7, T8, T9> _125789()  {
    return new ITuple6.Base<T1, T2, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T5, T7, T8, T9> _135789()  {
    return new ITuple6.Base<T1, T3, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T5, T7, T8, T9> _235789()  {
    return new ITuple6.Base<T2, T3, T5, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T4, T5, T7, T8, T9> _145789()  {
    return new ITuple6.Base<T1, T4, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T4, T5, T7, T8, T9> _245789()  {
    return new ITuple6.Base<T2, T4, T5, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T4, T5, T7, T8, T9> _345789()  {
    return new ITuple6.Base<T3, T4, T5, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T2, T6, T7, T8, T9> _126789()  {
    return new ITuple6.Base<T1, T2, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T3, T6, T7, T8, T9> _136789()  {
    return new ITuple6.Base<T1, T3, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T3, T6, T7, T8, T9> _236789()  {
    return new ITuple6.Base<T2, T3, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T4, T6, T7, T8, T9> _146789()  {
    return new ITuple6.Base<T1, T4, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T4, T6, T7, T8, T9> _246789()  {
    return new ITuple6.Base<T2, T4, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T4, T6, T7, T8, T9> _346789()  {
    return new ITuple6.Base<T3, T4, T6, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 1st, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T1, T5, T6, T7, T8, T9> _156789()  {
    return new ITuple6.Base<T1, T5, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T2, T5, T6, T7, T8, T9> _256789()  {
    return new ITuple6.Base<T2, T5, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T3, T5, T6, T7, T8, T9> _356789()  {
    return new ITuple6.Base<T3, T5, T6, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 6-tuple from this one where the elements are ordered: 4th, 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple6<T4, T5, T6, T7, T8, T9> _456789()  {
    return new ITuple6.Base<T4, T5, T6, T7, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _6()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T5> _12345()  {
    return new ITuple5.Base<T1, T2, T3, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T6> _12346()  {
    return new ITuple5.Base<T1, T2, T3, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T5, T6> _12356()  {
    return new ITuple5.Base<T1, T2, T3, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T5, T6> _12456()  {
    return new ITuple5.Base<T1, T2, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T5, T6> _13456()  {
    return new ITuple5.Base<T1, T3, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T5, T6> _23456()  {
    return new ITuple5.Base<T2, T3, T4, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T7> _12347()  {
    return new ITuple5.Base<T1, T2, T3, T4, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T5, T7> _12357()  {
    return new ITuple5.Base<T1, T2, T3, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T5, T7> _12457()  {
    return new ITuple5.Base<T1, T2, T4, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T5, T7> _13457()  {
    return new ITuple5.Base<T1, T3, T4, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T5, T7> _23457()  {
    return new ITuple5.Base<T2, T3, T4, T5, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T6, T7> _12367()  {
    return new ITuple5.Base<T1, T2, T3, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T6, T7> _12467()  {
    return new ITuple5.Base<T1, T2, T4, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T6, T7> _13467()  {
    return new ITuple5.Base<T1, T3, T4, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T6, T7> _23467()  {
    return new ITuple5.Base<T2, T3, T4, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T6, T7> _12567()  {
    return new ITuple5.Base<T1, T2, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T6, T7> _13567()  {
    return new ITuple5.Base<T1, T3, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T6, T7> _23567()  {
    return new ITuple5.Base<T2, T3, T5, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T6, T7> _14567()  {
    return new ITuple5.Base<T1, T4, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T6, T7> _24567()  {
    return new ITuple5.Base<T2, T4, T5, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T6, T7> _34567()  {
    return new ITuple5.Base<T3, T4, T5, T6, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _5()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T8> _12348()  {
    return new ITuple5.Base<T1, T2, T3, T4, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T5, T8> _12358()  {
    return new ITuple5.Base<T1, T2, T3, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T5, T8> _12458()  {
    return new ITuple5.Base<T1, T2, T4, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T5, T8> _13458()  {
    return new ITuple5.Base<T1, T3, T4, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T5, T8> _23458()  {
    return new ITuple5.Base<T2, T3, T4, T5, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T6, T8> _12368()  {
    return new ITuple5.Base<T1, T2, T3, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T6, T8> _12468()  {
    return new ITuple5.Base<T1, T2, T4, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T6, T8> _13468()  {
    return new ITuple5.Base<T1, T3, T4, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T6, T8> _23468()  {
    return new ITuple5.Base<T2, T3, T4, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T6, T8> _12568()  {
    return new ITuple5.Base<T1, T2, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T6, T8> _13568()  {
    return new ITuple5.Base<T1, T3, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T6, T8> _23568()  {
    return new ITuple5.Base<T2, T3, T5, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T6, T8> _14568()  {
    return new ITuple5.Base<T1, T4, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T6, T8> _24568()  {
    return new ITuple5.Base<T2, T4, T5, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T6, T8> _34568()  {
    return new ITuple5.Base<T3, T4, T5, T6, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T7, T8> _12378()  {
    return new ITuple5.Base<T1, T2, T3, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T7, T8> _12478()  {
    return new ITuple5.Base<T1, T2, T4, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T7, T8> _13478()  {
    return new ITuple5.Base<T1, T3, T4, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T7, T8> _23478()  {
    return new ITuple5.Base<T2, T3, T4, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T7, T8> _12578()  {
    return new ITuple5.Base<T1, T2, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T7, T8> _13578()  {
    return new ITuple5.Base<T1, T3, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T7, T8> _23578()  {
    return new ITuple5.Base<T2, T3, T5, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T7, T8> _14578()  {
    return new ITuple5.Base<T1, T4, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T7, T8> _24578()  {
    return new ITuple5.Base<T2, T4, T5, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T7, T8> _34578()  {
    return new ITuple5.Base<T3, T4, T5, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T6, T7, T8> _12678()  {
    return new ITuple5.Base<T1, T2, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T6, T7, T8> _13678()  {
    return new ITuple5.Base<T1, T3, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T6, T7, T8> _23678()  {
    return new ITuple5.Base<T2, T3, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T6, T7, T8> _14678()  {
    return new ITuple5.Base<T1, T4, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T6, T7, T8> _24678()  {
    return new ITuple5.Base<T2, T4, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T6, T7, T8> _34678()  {
    return new ITuple5.Base<T3, T4, T6, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T5, T6, T7, T8> _15678()  {
    return new ITuple5.Base<T1, T5, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T5, T6, T7, T8> _25678()  {
    return new ITuple5.Base<T2, T5, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T5, T6, T7, T8> _35678()  {
    return new ITuple5.Base<T3, T5, T6, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 4th, 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T4, T5, T6, T7, T8> _45678()  {
    return new ITuple5.Base<T4, T5, T6, T7, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _5()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T9> _12349()  {
    return new ITuple5.Base<T1, T2, T3, T4, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T5, T9> _12359()  {
    return new ITuple5.Base<T1, T2, T3, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T5, T9> _12459()  {
    return new ITuple5.Base<T1, T2, T4, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T5, T9> _13459()  {
    return new ITuple5.Base<T1, T3, T4, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T5, T9> _23459()  {
    return new ITuple5.Base<T2, T3, T4, T5, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T6, T9> _12369()  {
    return new ITuple5.Base<T1, T2, T3, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T6, T9> _12469()  {
    return new ITuple5.Base<T1, T2, T4, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T6, T9> _13469()  {
    return new ITuple5.Base<T1, T3, T4, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T6, T9> _23469()  {
    return new ITuple5.Base<T2, T3, T4, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T6, T9> _12569()  {
    return new ITuple5.Base<T1, T2, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T6, T9> _13569()  {
    return new ITuple5.Base<T1, T3, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T6, T9> _23569()  {
    return new ITuple5.Base<T2, T3, T5, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T6, T9> _14569()  {
    return new ITuple5.Base<T1, T4, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T6, T9> _24569()  {
    return new ITuple5.Base<T2, T4, T5, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T6, T9> _34569()  {
    return new ITuple5.Base<T3, T4, T5, T6, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T7, T9> _12379()  {
    return new ITuple5.Base<T1, T2, T3, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T7, T9> _12479()  {
    return new ITuple5.Base<T1, T2, T4, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T7, T9> _13479()  {
    return new ITuple5.Base<T1, T3, T4, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T7, T9> _23479()  {
    return new ITuple5.Base<T2, T3, T4, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T7, T9> _12579()  {
    return new ITuple5.Base<T1, T2, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T7, T9> _13579()  {
    return new ITuple5.Base<T1, T3, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T7, T9> _23579()  {
    return new ITuple5.Base<T2, T3, T5, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T7, T9> _14579()  {
    return new ITuple5.Base<T1, T4, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T7, T9> _24579()  {
    return new ITuple5.Base<T2, T4, T5, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T7, T9> _34579()  {
    return new ITuple5.Base<T3, T4, T5, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T6, T7, T9> _12679()  {
    return new ITuple5.Base<T1, T2, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T6, T7, T9> _13679()  {
    return new ITuple5.Base<T1, T3, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T6, T7, T9> _23679()  {
    return new ITuple5.Base<T2, T3, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T6, T7, T9> _14679()  {
    return new ITuple5.Base<T1, T4, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T6, T7, T9> _24679()  {
    return new ITuple5.Base<T2, T4, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T6, T7, T9> _34679()  {
    return new ITuple5.Base<T3, T4, T6, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T5, T6, T7, T9> _15679()  {
    return new ITuple5.Base<T1, T5, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T5, T6, T7, T9> _25679()  {
    return new ITuple5.Base<T2, T5, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T5, T6, T7, T9> _35679()  {
    return new ITuple5.Base<T3, T5, T6, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 4th, 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T4, T5, T6, T7, T9> _45679()  {
    return new ITuple5.Base<T4, T5, T6, T7, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T8, T9> _12389()  {
    return new ITuple5.Base<T1, T2, T3, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T8, T9> _12489()  {
    return new ITuple5.Base<T1, T2, T4, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T8, T9> _13489()  {
    return new ITuple5.Base<T1, T3, T4, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T8, T9> _23489()  {
    return new ITuple5.Base<T2, T3, T4, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T5, T8, T9> _12589()  {
    return new ITuple5.Base<T1, T2, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T5, T8, T9> _13589()  {
    return new ITuple5.Base<T1, T3, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T5, T8, T9> _23589()  {
    return new ITuple5.Base<T2, T3, T5, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T5, T8, T9> _14589()  {
    return new ITuple5.Base<T1, T4, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T5, T8, T9> _24589()  {
    return new ITuple5.Base<T2, T4, T5, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T5, T8, T9> _34589()  {
    return new ITuple5.Base<T3, T4, T5, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T6, T8, T9> _12689()  {
    return new ITuple5.Base<T1, T2, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T6, T8, T9> _13689()  {
    return new ITuple5.Base<T1, T3, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T6, T8, T9> _23689()  {
    return new ITuple5.Base<T2, T3, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T6, T8, T9> _14689()  {
    return new ITuple5.Base<T1, T4, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T6, T8, T9> _24689()  {
    return new ITuple5.Base<T2, T4, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T6, T8, T9> _34689()  {
    return new ITuple5.Base<T3, T4, T6, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T5, T6, T8, T9> _15689()  {
    return new ITuple5.Base<T1, T5, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T5, T6, T8, T9> _25689()  {
    return new ITuple5.Base<T2, T5, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T5, T6, T8, T9> _35689()  {
    return new ITuple5.Base<T3, T5, T6, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 4th, 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T4, T5, T6, T8, T9> _45689()  {
    return new ITuple5.Base<T4, T5, T6, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T7, T8, T9> _12789()  {
    return new ITuple5.Base<T1, T2, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T7, T8, T9> _13789()  {
    return new ITuple5.Base<T1, T3, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T7, T8, T9> _23789()  {
    return new ITuple5.Base<T2, T3, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T4, T7, T8, T9> _14789()  {
    return new ITuple5.Base<T1, T4, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T4, T7, T8, T9> _24789()  {
    return new ITuple5.Base<T2, T4, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T4, T7, T8, T9> _34789()  {
    return new ITuple5.Base<T3, T4, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T5, T7, T8, T9> _15789()  {
    return new ITuple5.Base<T1, T5, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T5, T7, T8, T9> _25789()  {
    return new ITuple5.Base<T2, T5, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T5, T7, T8, T9> _35789()  {
    return new ITuple5.Base<T3, T5, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 4th, 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T4, T5, T7, T8, T9> _45789()  {
    return new ITuple5.Base<T4, T5, T7, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T6, T7, T8, T9> _16789()  {
    return new ITuple5.Base<T1, T6, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T6, T7, T8, T9> _26789()  {
    return new ITuple5.Base<T2, T6, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 3rd, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T3, T6, T7, T8, T9> _36789()  {
    return new ITuple5.Base<T3, T6, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 4th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T4, T6, T7, T8, T9> _46789()  {
    return new ITuple5.Base<T4, T6, T7, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 5th, 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T5, T6, T7, T8, T9> _56789()  {
    return new ITuple5.Base<T5, T6, T7, T8, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _5()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T4> _1234()  {
    return new ITuple4.Base<T1, T2, T3, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T5> _1235()  {
    return new ITuple4.Base<T1, T2, T3, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T5> _1245()  {
    return new ITuple4.Base<T1, T2, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T5> _1345()  {
    return new ITuple4.Base<T1, T3, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T5> _2345()  {
    return new ITuple4.Base<T2, T3, T4, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T6> _1236()  {
    return new ITuple4.Base<T1, T2, T3, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T6> _1246()  {
    return new ITuple4.Base<T1, T2, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T6> _1346()  {
    return new ITuple4.Base<T1, T3, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T6> _2346()  {
    return new ITuple4.Base<T2, T3, T4, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T5, T6> _1256()  {
    return new ITuple4.Base<T1, T2, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T5, T6> _1356()  {
    return new ITuple4.Base<T1, T3, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T5, T6> _2356()  {
    return new ITuple4.Base<T2, T3, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T5, T6> _1456()  {
    return new ITuple4.Base<T1, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T5, T6> _2456()  {
    return new ITuple4.Base<T2, T4, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T5, T6> _3456()  {
    return new ITuple4.Base<T3, T4, T5, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T7> _1237()  {
    return new ITuple4.Base<T1, T2, T3, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T7> _1247()  {
    return new ITuple4.Base<T1, T2, T4, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T7> _1347()  {
    return new ITuple4.Base<T1, T3, T4, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T7> _2347()  {
    return new ITuple4.Base<T2, T3, T4, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T5, T7> _1257()  {
    return new ITuple4.Base<T1, T2, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T5, T7> _1357()  {
    return new ITuple4.Base<T1, T3, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T5, T7> _2357()  {
    return new ITuple4.Base<T2, T3, T5, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T5, T7> _1457()  {
    return new ITuple4.Base<T1, T4, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T5, T7> _2457()  {
    return new ITuple4.Base<T2, T4, T5, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T5, T7> _3457()  {
    return new ITuple4.Base<T3, T4, T5, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T6, T7> _1267()  {
    return new ITuple4.Base<T1, T2, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T6, T7> _1367()  {
    return new ITuple4.Base<T1, T3, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T6, T7> _2367()  {
    return new ITuple4.Base<T2, T3, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T6, T7> _1467()  {
    return new ITuple4.Base<T1, T4, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T6, T7> _2467()  {
    return new ITuple4.Base<T2, T4, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T6, T7> _3467()  {
    return new ITuple4.Base<T3, T4, T6, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T6, T7> _1567()  {
    return new ITuple4.Base<T1, T5, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T6, T7> _2567()  {
    return new ITuple4.Base<T2, T5, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T6, T7> _3567()  {
    return new ITuple4.Base<T3, T5, T6, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T6, T7> _4567()  {
    return new ITuple4.Base<T4, T5, T6, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _4()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T8> _1238()  {
    return new ITuple4.Base<T1, T2, T3, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T8> _1248()  {
    return new ITuple4.Base<T1, T2, T4, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T8> _1348()  {
    return new ITuple4.Base<T1, T3, T4, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T8> _2348()  {
    return new ITuple4.Base<T2, T3, T4, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T5, T8> _1258()  {
    return new ITuple4.Base<T1, T2, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T5, T8> _1358()  {
    return new ITuple4.Base<T1, T3, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T5, T8> _2358()  {
    return new ITuple4.Base<T2, T3, T5, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T5, T8> _1458()  {
    return new ITuple4.Base<T1, T4, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T5, T8> _2458()  {
    return new ITuple4.Base<T2, T4, T5, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T5, T8> _3458()  {
    return new ITuple4.Base<T3, T4, T5, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T6, T8> _1268()  {
    return new ITuple4.Base<T1, T2, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T6, T8> _1368()  {
    return new ITuple4.Base<T1, T3, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T6, T8> _2368()  {
    return new ITuple4.Base<T2, T3, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T6, T8> _1468()  {
    return new ITuple4.Base<T1, T4, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T6, T8> _2468()  {
    return new ITuple4.Base<T2, T4, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T6, T8> _3468()  {
    return new ITuple4.Base<T3, T4, T6, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T6, T8> _1568()  {
    return new ITuple4.Base<T1, T5, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T6, T8> _2568()  {
    return new ITuple4.Base<T2, T5, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T6, T8> _3568()  {
    return new ITuple4.Base<T3, T5, T6, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T6, T8> _4568()  {
    return new ITuple4.Base<T4, T5, T6, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T7, T8> _1278()  {
    return new ITuple4.Base<T1, T2, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T7, T8> _1378()  {
    return new ITuple4.Base<T1, T3, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T7, T8> _2378()  {
    return new ITuple4.Base<T2, T3, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T7, T8> _1478()  {
    return new ITuple4.Base<T1, T4, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T7, T8> _2478()  {
    return new ITuple4.Base<T2, T4, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T7, T8> _3478()  {
    return new ITuple4.Base<T3, T4, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T7, T8> _1578()  {
    return new ITuple4.Base<T1, T5, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T7, T8> _2578()  {
    return new ITuple4.Base<T2, T5, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T7, T8> _3578()  {
    return new ITuple4.Base<T3, T5, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T7, T8> _4578()  {
    return new ITuple4.Base<T4, T5, T7, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T6, T7, T8> _1678()  {
    return new ITuple4.Base<T1, T6, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T6, T7, T8> _2678()  {
    return new ITuple4.Base<T2, T6, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T6, T7, T8> _3678()  {
    return new ITuple4.Base<T3, T6, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T6, T7, T8> _4678()  {
    return new ITuple4.Base<T4, T6, T7, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 5th, 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T5, T6, T7, T8> _5678()  {
    return new ITuple4.Base<T5, T6, T7, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _4()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T9> _1239()  {
    return new ITuple4.Base<T1, T2, T3, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T9> _1249()  {
    return new ITuple4.Base<T1, T2, T4, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T9> _1349()  {
    return new ITuple4.Base<T1, T3, T4, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T9> _2349()  {
    return new ITuple4.Base<T2, T3, T4, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T5, T9> _1259()  {
    return new ITuple4.Base<T1, T2, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T5, T9> _1359()  {
    return new ITuple4.Base<T1, T3, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T5, T9> _2359()  {
    return new ITuple4.Base<T2, T3, T5, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T5, T9> _1459()  {
    return new ITuple4.Base<T1, T4, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T5, T9> _2459()  {
    return new ITuple4.Base<T2, T4, T5, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T5, T9> _3459()  {
    return new ITuple4.Base<T3, T4, T5, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T6, T9> _1269()  {
    return new ITuple4.Base<T1, T2, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T6, T9> _1369()  {
    return new ITuple4.Base<T1, T3, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T6, T9> _2369()  {
    return new ITuple4.Base<T2, T3, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T6, T9> _1469()  {
    return new ITuple4.Base<T1, T4, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T6, T9> _2469()  {
    return new ITuple4.Base<T2, T4, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T6, T9> _3469()  {
    return new ITuple4.Base<T3, T4, T6, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T6, T9> _1569()  {
    return new ITuple4.Base<T1, T5, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T6, T9> _2569()  {
    return new ITuple4.Base<T2, T5, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T6, T9> _3569()  {
    return new ITuple4.Base<T3, T5, T6, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T6, T9> _4569()  {
    return new ITuple4.Base<T4, T5, T6, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T7, T9> _1279()  {
    return new ITuple4.Base<T1, T2, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T7, T9> _1379()  {
    return new ITuple4.Base<T1, T3, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T7, T9> _2379()  {
    return new ITuple4.Base<T2, T3, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T7, T9> _1479()  {
    return new ITuple4.Base<T1, T4, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T7, T9> _2479()  {
    return new ITuple4.Base<T2, T4, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T7, T9> _3479()  {
    return new ITuple4.Base<T3, T4, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T7, T9> _1579()  {
    return new ITuple4.Base<T1, T5, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T7, T9> _2579()  {
    return new ITuple4.Base<T2, T5, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T7, T9> _3579()  {
    return new ITuple4.Base<T3, T5, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T7, T9> _4579()  {
    return new ITuple4.Base<T4, T5, T7, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T6, T7, T9> _1679()  {
    return new ITuple4.Base<T1, T6, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T6, T7, T9> _2679()  {
    return new ITuple4.Base<T2, T6, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T6, T7, T9> _3679()  {
    return new ITuple4.Base<T3, T6, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T6, T7, T9> _4679()  {
    return new ITuple4.Base<T4, T6, T7, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 5th, 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T5, T6, T7, T9> _5679()  {
    return new ITuple4.Base<T5, T6, T7, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T8, T9> _1289()  {
    return new ITuple4.Base<T1, T2, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T8, T9> _1389()  {
    return new ITuple4.Base<T1, T3, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T8, T9> _2389()  {
    return new ITuple4.Base<T2, T3, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T8, T9> _1489()  {
    return new ITuple4.Base<T1, T4, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T8, T9> _2489()  {
    return new ITuple4.Base<T2, T4, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T8, T9> _3489()  {
    return new ITuple4.Base<T3, T4, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T5, T8, T9> _1589()  {
    return new ITuple4.Base<T1, T5, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T5, T8, T9> _2589()  {
    return new ITuple4.Base<T2, T5, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T5, T8, T9> _3589()  {
    return new ITuple4.Base<T3, T5, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T5, T8, T9> _4589()  {
    return new ITuple4.Base<T4, T5, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T6, T8, T9> _1689()  {
    return new ITuple4.Base<T1, T6, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T6, T8, T9> _2689()  {
    return new ITuple4.Base<T2, T6, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T6, T8, T9> _3689()  {
    return new ITuple4.Base<T3, T6, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T6, T8, T9> _4689()  {
    return new ITuple4.Base<T4, T6, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 5th, 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T5, T6, T8, T9> _5689()  {
    return new ITuple4.Base<T5, T6, T8, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T7, T8, T9> _1789()  {
    return new ITuple4.Base<T1, T7, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T7, T8, T9> _2789()  {
    return new ITuple4.Base<T2, T7, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T7, T8, T9> _3789()  {
    return new ITuple4.Base<T3, T7, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 4th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T4, T7, T8, T9> _4789()  {
    return new ITuple4.Base<T4, T7, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 5th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T5, T7, T8, T9> _5789()  {
    return new ITuple4.Base<T5, T7, T8, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 6th, 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T6, T7, T8, T9> _6789()  {
    return new ITuple4.Base<T6, T7, T8, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _4()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T3> _123()  {
    return new ITuple3.Base<T1, T2, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T2> _132()  {
    return new ITuple3.Base<T1, T3, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T2> _312()  {
    return new ITuple3.Base<T3, T1, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T1> _321()  {
    return new ITuple3.Base<T3, T2, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T1> _231()  {
    return new ITuple3.Base<T2, T3, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T3> _213()  {
    return new ITuple3.Base<T2, T1, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T4> _124()  {
    return new ITuple3.Base<T1, T2, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T2> _142()  {
    return new ITuple3.Base<T1, T4, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T2> _412()  {
    return new ITuple3.Base<T4, T1, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T1> _421()  {
    return new ITuple3.Base<T4, T2, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T1> _241()  {
    return new ITuple3.Base<T2, T4, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T4> _214()  {
    return new ITuple3.Base<T2, T1, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T4> _134()  {
    return new ITuple3.Base<T1, T3, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T3> _143()  {
    return new ITuple3.Base<T1, T4, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T3> _413()  {
    return new ITuple3.Base<T4, T1, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T1> _431()  {
    return new ITuple3.Base<T4, T3, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T1> _341()  {
    return new ITuple3.Base<T3, T4, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T4> _314()  {
    return new ITuple3.Base<T3, T1, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T4> _234()  {
    return new ITuple3.Base<T2, T3, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T3> _243()  {
    return new ITuple3.Base<T2, T4, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T3> _423()  {
    return new ITuple3.Base<T4, T2, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T2> _432()  {
    return new ITuple3.Base<T4, T3, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T2> _342()  {
    return new ITuple3.Base<T3, T4, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T4> _324()  {
    return new ITuple3.Base<T3, T2, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T5> _125()  {
    return new ITuple3.Base<T1, T2, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T2> _152()  {
    return new ITuple3.Base<T1, T5, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T2> _512()  {
    return new ITuple3.Base<T5, T1, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T1> _521()  {
    return new ITuple3.Base<T5, T2, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T1> _251()  {
    return new ITuple3.Base<T2, T5, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T5> _215()  {
    return new ITuple3.Base<T2, T1, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T5> _135()  {
    return new ITuple3.Base<T1, T3, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T3> _153()  {
    return new ITuple3.Base<T1, T5, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T3> _513()  {
    return new ITuple3.Base<T5, T1, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T1> _531()  {
    return new ITuple3.Base<T5, T3, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T1> _351()  {
    return new ITuple3.Base<T3, T5, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T5> _315()  {
    return new ITuple3.Base<T3, T1, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T5> _235()  {
    return new ITuple3.Base<T2, T3, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T3> _253()  {
    return new ITuple3.Base<T2, T5, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T3> _523()  {
    return new ITuple3.Base<T5, T2, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T2> _532()  {
    return new ITuple3.Base<T5, T3, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T2> _352()  {
    return new ITuple3.Base<T3, T5, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T5> _325()  {
    return new ITuple3.Base<T3, T2, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T5> _145()  {
    return new ITuple3.Base<T1, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T4> _154()  {
    return new ITuple3.Base<T1, T5, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T4> _514()  {
    return new ITuple3.Base<T5, T1, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T1> _541()  {
    return new ITuple3.Base<T5, T4, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T1> _451()  {
    return new ITuple3.Base<T4, T5, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T5> _415()  {
    return new ITuple3.Base<T4, T1, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T5> _245()  {
    return new ITuple3.Base<T2, T4, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T4> _254()  {
    return new ITuple3.Base<T2, T5, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T4> _524()  {
    return new ITuple3.Base<T5, T2, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T2> _542()  {
    return new ITuple3.Base<T5, T4, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T2> _452()  {
    return new ITuple3.Base<T4, T5, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T5> _425()  {
    return new ITuple3.Base<T4, T2, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T5> _345()  {
    return new ITuple3.Base<T3, T4, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T4> _354()  {
    return new ITuple3.Base<T3, T5, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T4> _534()  {
    return new ITuple3.Base<T5, T3, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T3> _543()  {
    return new ITuple3.Base<T5, T4, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T3> _453()  {
    return new ITuple3.Base<T4, T5, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T5> _435()  {
    return new ITuple3.Base<T4, T3, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T6> _126()  {
    return new ITuple3.Base<T1, T2, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T2> _162()  {
    return new ITuple3.Base<T1, T6, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T2> _612()  {
    return new ITuple3.Base<T6, T1, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T1> _621()  {
    return new ITuple3.Base<T6, T2, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T1> _261()  {
    return new ITuple3.Base<T2, T6, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T6> _216()  {
    return new ITuple3.Base<T2, T1, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T6> _136()  {
    return new ITuple3.Base<T1, T3, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T3> _163()  {
    return new ITuple3.Base<T1, T6, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T3> _613()  {
    return new ITuple3.Base<T6, T1, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T1> _631()  {
    return new ITuple3.Base<T6, T3, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T1> _361()  {
    return new ITuple3.Base<T3, T6, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T6> _316()  {
    return new ITuple3.Base<T3, T1, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T6> _236()  {
    return new ITuple3.Base<T2, T3, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T3> _263()  {
    return new ITuple3.Base<T2, T6, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T3> _623()  {
    return new ITuple3.Base<T6, T2, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T2> _632()  {
    return new ITuple3.Base<T6, T3, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T2> _362()  {
    return new ITuple3.Base<T3, T6, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T6> _326()  {
    return new ITuple3.Base<T3, T2, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T6> _146()  {
    return new ITuple3.Base<T1, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T4> _164()  {
    return new ITuple3.Base<T1, T6, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T4> _614()  {
    return new ITuple3.Base<T6, T1, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T1> _641()  {
    return new ITuple3.Base<T6, T4, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T1> _461()  {
    return new ITuple3.Base<T4, T6, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T6> _416()  {
    return new ITuple3.Base<T4, T1, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T6> _246()  {
    return new ITuple3.Base<T2, T4, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T4> _264()  {
    return new ITuple3.Base<T2, T6, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T4> _624()  {
    return new ITuple3.Base<T6, T2, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T2> _642()  {
    return new ITuple3.Base<T6, T4, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T2> _462()  {
    return new ITuple3.Base<T4, T6, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T6> _426()  {
    return new ITuple3.Base<T4, T2, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T6> _346()  {
    return new ITuple3.Base<T3, T4, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T4> _364()  {
    return new ITuple3.Base<T3, T6, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T4> _634()  {
    return new ITuple3.Base<T6, T3, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T3> _643()  {
    return new ITuple3.Base<T6, T4, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T3> _463()  {
    return new ITuple3.Base<T4, T6, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T6> _436()  {
    return new ITuple3.Base<T4, T3, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T6> _156()  {
    return new ITuple3.Base<T1, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T5> _165()  {
    return new ITuple3.Base<T1, T6, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T5> _615()  {
    return new ITuple3.Base<T6, T1, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T1> _651()  {
    return new ITuple3.Base<T6, T5, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T1> _561()  {
    return new ITuple3.Base<T5, T6, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T6> _516()  {
    return new ITuple3.Base<T5, T1, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T6> _256()  {
    return new ITuple3.Base<T2, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T5> _265()  {
    return new ITuple3.Base<T2, T6, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T5> _625()  {
    return new ITuple3.Base<T6, T2, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T2> _652()  {
    return new ITuple3.Base<T6, T5, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T2> _562()  {
    return new ITuple3.Base<T5, T6, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T6> _526()  {
    return new ITuple3.Base<T5, T2, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T6> _356()  {
    return new ITuple3.Base<T3, T5, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T5> _365()  {
    return new ITuple3.Base<T3, T6, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T5> _635()  {
    return new ITuple3.Base<T6, T3, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T3> _653()  {
    return new ITuple3.Base<T6, T5, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T3> _563()  {
    return new ITuple3.Base<T5, T6, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T6> _536()  {
    return new ITuple3.Base<T5, T3, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T6> _456()  {
    return new ITuple3.Base<T4, T5, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T5> _465()  {
    return new ITuple3.Base<T4, T6, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T5> _645()  {
    return new ITuple3.Base<T6, T4, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T4> _654()  {
    return new ITuple3.Base<T6, T5, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T4> _564()  {
    return new ITuple3.Base<T5, T6, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T6> _546()  {
    return new ITuple3.Base<T5, T4, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T7> _127()  {
    return new ITuple3.Base<T1, T2, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T2> _172()  {
    return new ITuple3.Base<T1, T7, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T2> _712()  {
    return new ITuple3.Base<T7, T1, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T1> _721()  {
    return new ITuple3.Base<T7, T2, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T1> _271()  {
    return new ITuple3.Base<T2, T7, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T7> _217()  {
    return new ITuple3.Base<T2, T1, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T7> _137()  {
    return new ITuple3.Base<T1, T3, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T3> _173()  {
    return new ITuple3.Base<T1, T7, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T3> _713()  {
    return new ITuple3.Base<T7, T1, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T1> _731()  {
    return new ITuple3.Base<T7, T3, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T1> _371()  {
    return new ITuple3.Base<T3, T7, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T7> _317()  {
    return new ITuple3.Base<T3, T1, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T7> _237()  {
    return new ITuple3.Base<T2, T3, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T3> _273()  {
    return new ITuple3.Base<T2, T7, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T3> _723()  {
    return new ITuple3.Base<T7, T2, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T2> _732()  {
    return new ITuple3.Base<T7, T3, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T2> _372()  {
    return new ITuple3.Base<T3, T7, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T7> _327()  {
    return new ITuple3.Base<T3, T2, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T7> _147()  {
    return new ITuple3.Base<T1, T4, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T4> _174()  {
    return new ITuple3.Base<T1, T7, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T4> _714()  {
    return new ITuple3.Base<T7, T1, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T1> _741()  {
    return new ITuple3.Base<T7, T4, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T1> _471()  {
    return new ITuple3.Base<T4, T7, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T7> _417()  {
    return new ITuple3.Base<T4, T1, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T7> _247()  {
    return new ITuple3.Base<T2, T4, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T4> _274()  {
    return new ITuple3.Base<T2, T7, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T4> _724()  {
    return new ITuple3.Base<T7, T2, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T2> _742()  {
    return new ITuple3.Base<T7, T4, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T2> _472()  {
    return new ITuple3.Base<T4, T7, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T7> _427()  {
    return new ITuple3.Base<T4, T2, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T7> _347()  {
    return new ITuple3.Base<T3, T4, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T4> _374()  {
    return new ITuple3.Base<T3, T7, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T4> _734()  {
    return new ITuple3.Base<T7, T3, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T3> _743()  {
    return new ITuple3.Base<T7, T4, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T3> _473()  {
    return new ITuple3.Base<T4, T7, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T7> _437()  {
    return new ITuple3.Base<T4, T3, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T7> _157()  {
    return new ITuple3.Base<T1, T5, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T5> _175()  {
    return new ITuple3.Base<T1, T7, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T5> _715()  {
    return new ITuple3.Base<T7, T1, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T1> _751()  {
    return new ITuple3.Base<T7, T5, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T1> _571()  {
    return new ITuple3.Base<T5, T7, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T7> _517()  {
    return new ITuple3.Base<T5, T1, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T7> _257()  {
    return new ITuple3.Base<T2, T5, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T5> _275()  {
    return new ITuple3.Base<T2, T7, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T5> _725()  {
    return new ITuple3.Base<T7, T2, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T2> _752()  {
    return new ITuple3.Base<T7, T5, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T2> _572()  {
    return new ITuple3.Base<T5, T7, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T7> _527()  {
    return new ITuple3.Base<T5, T2, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T7> _357()  {
    return new ITuple3.Base<T3, T5, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T5> _375()  {
    return new ITuple3.Base<T3, T7, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T5> _735()  {
    return new ITuple3.Base<T7, T3, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T3> _753()  {
    return new ITuple3.Base<T7, T5, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T3> _573()  {
    return new ITuple3.Base<T5, T7, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T7> _537()  {
    return new ITuple3.Base<T5, T3, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T7> _457()  {
    return new ITuple3.Base<T4, T5, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T5> _475()  {
    return new ITuple3.Base<T4, T7, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T5> _745()  {
    return new ITuple3.Base<T7, T4, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T4> _754()  {
    return new ITuple3.Base<T7, T5, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T4> _574()  {
    return new ITuple3.Base<T5, T7, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T7> _547()  {
    return new ITuple3.Base<T5, T4, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T7> _167()  {
    return new ITuple3.Base<T1, T6, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T6> _176()  {
    return new ITuple3.Base<T1, T7, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T6> _716()  {
    return new ITuple3.Base<T7, T1, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T1> _761()  {
    return new ITuple3.Base<T7, T6, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T1> _671()  {
    return new ITuple3.Base<T6, T7, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T7> _617()  {
    return new ITuple3.Base<T6, T1, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T7> _267()  {
    return new ITuple3.Base<T2, T6, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T6> _276()  {
    return new ITuple3.Base<T2, T7, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T6> _726()  {
    return new ITuple3.Base<T7, T2, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T2> _762()  {
    return new ITuple3.Base<T7, T6, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T2> _672()  {
    return new ITuple3.Base<T6, T7, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T7> _627()  {
    return new ITuple3.Base<T6, T2, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T7> _367()  {
    return new ITuple3.Base<T3, T6, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T6> _376()  {
    return new ITuple3.Base<T3, T7, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T6> _736()  {
    return new ITuple3.Base<T7, T3, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T3> _763()  {
    return new ITuple3.Base<T7, T6, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T3> _673()  {
    return new ITuple3.Base<T6, T7, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T7> _637()  {
    return new ITuple3.Base<T6, T3, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T7> _467()  {
    return new ITuple3.Base<T4, T6, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T6> _476()  {
    return new ITuple3.Base<T4, T7, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T6> _746()  {
    return new ITuple3.Base<T7, T4, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T4> _764()  {
    return new ITuple3.Base<T7, T6, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T4> _674()  {
    return new ITuple3.Base<T6, T7, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T7> _647()  {
    return new ITuple3.Base<T6, T4, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T7> _567()  {
    return new ITuple3.Base<T5, T6, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T6> _576()  {
    return new ITuple3.Base<T5, T7, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T6> _756()  {
    return new ITuple3.Base<T7, T5, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T5> _765()  {
    return new ITuple3.Base<T7, T6, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T5> _675()  {
    return new ITuple3.Base<T6, T7, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T7> _657()  {
    return new ITuple3.Base<T6, T5, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T8> _128()  {
    return new ITuple3.Base<T1, T2, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T2> _182()  {
    return new ITuple3.Base<T1, T8, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T2> _812()  {
    return new ITuple3.Base<T8, T1, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T1> _821()  {
    return new ITuple3.Base<T8, T2, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T1> _281()  {
    return new ITuple3.Base<T2, T8, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T8> _218()  {
    return new ITuple3.Base<T2, T1, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T8> _138()  {
    return new ITuple3.Base<T1, T3, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T3> _183()  {
    return new ITuple3.Base<T1, T8, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T3> _813()  {
    return new ITuple3.Base<T8, T1, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T1> _831()  {
    return new ITuple3.Base<T8, T3, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T1> _381()  {
    return new ITuple3.Base<T3, T8, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T8> _318()  {
    return new ITuple3.Base<T3, T1, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T8> _238()  {
    return new ITuple3.Base<T2, T3, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T3> _283()  {
    return new ITuple3.Base<T2, T8, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T3> _823()  {
    return new ITuple3.Base<T8, T2, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T2> _832()  {
    return new ITuple3.Base<T8, T3, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T2> _382()  {
    return new ITuple3.Base<T3, T8, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T8> _328()  {
    return new ITuple3.Base<T3, T2, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T8> _148()  {
    return new ITuple3.Base<T1, T4, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T4> _184()  {
    return new ITuple3.Base<T1, T8, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T4> _814()  {
    return new ITuple3.Base<T8, T1, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T1> _841()  {
    return new ITuple3.Base<T8, T4, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T1> _481()  {
    return new ITuple3.Base<T4, T8, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T8> _418()  {
    return new ITuple3.Base<T4, T1, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T8> _248()  {
    return new ITuple3.Base<T2, T4, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T4> _284()  {
    return new ITuple3.Base<T2, T8, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T4> _824()  {
    return new ITuple3.Base<T8, T2, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T2> _842()  {
    return new ITuple3.Base<T8, T4, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T2> _482()  {
    return new ITuple3.Base<T4, T8, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T8> _428()  {
    return new ITuple3.Base<T4, T2, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T8> _348()  {
    return new ITuple3.Base<T3, T4, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T4> _384()  {
    return new ITuple3.Base<T3, T8, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T4> _834()  {
    return new ITuple3.Base<T8, T3, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T3> _843()  {
    return new ITuple3.Base<T8, T4, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T3> _483()  {
    return new ITuple3.Base<T4, T8, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T8> _438()  {
    return new ITuple3.Base<T4, T3, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T8> _158()  {
    return new ITuple3.Base<T1, T5, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T5> _185()  {
    return new ITuple3.Base<T1, T8, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T5> _815()  {
    return new ITuple3.Base<T8, T1, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T1> _851()  {
    return new ITuple3.Base<T8, T5, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T1> _581()  {
    return new ITuple3.Base<T5, T8, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T8> _518()  {
    return new ITuple3.Base<T5, T1, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T8> _258()  {
    return new ITuple3.Base<T2, T5, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T5> _285()  {
    return new ITuple3.Base<T2, T8, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T5> _825()  {
    return new ITuple3.Base<T8, T2, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T2> _852()  {
    return new ITuple3.Base<T8, T5, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T2> _582()  {
    return new ITuple3.Base<T5, T8, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T8> _528()  {
    return new ITuple3.Base<T5, T2, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T8> _358()  {
    return new ITuple3.Base<T3, T5, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T5> _385()  {
    return new ITuple3.Base<T3, T8, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T5> _835()  {
    return new ITuple3.Base<T8, T3, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T3> _853()  {
    return new ITuple3.Base<T8, T5, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T3> _583()  {
    return new ITuple3.Base<T5, T8, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T8> _538()  {
    return new ITuple3.Base<T5, T3, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T8> _458()  {
    return new ITuple3.Base<T4, T5, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T5> _485()  {
    return new ITuple3.Base<T4, T8, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T5> _845()  {
    return new ITuple3.Base<T8, T4, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T4> _854()  {
    return new ITuple3.Base<T8, T5, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T4> _584()  {
    return new ITuple3.Base<T5, T8, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T8> _548()  {
    return new ITuple3.Base<T5, T4, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T8> _168()  {
    return new ITuple3.Base<T1, T6, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T6> _186()  {
    return new ITuple3.Base<T1, T8, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T6> _816()  {
    return new ITuple3.Base<T8, T1, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T1> _861()  {
    return new ITuple3.Base<T8, T6, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T1> _681()  {
    return new ITuple3.Base<T6, T8, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T8> _618()  {
    return new ITuple3.Base<T6, T1, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T8> _268()  {
    return new ITuple3.Base<T2, T6, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T6> _286()  {
    return new ITuple3.Base<T2, T8, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T6> _826()  {
    return new ITuple3.Base<T8, T2, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T2> _862()  {
    return new ITuple3.Base<T8, T6, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T2> _682()  {
    return new ITuple3.Base<T6, T8, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T8> _628()  {
    return new ITuple3.Base<T6, T2, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T8> _368()  {
    return new ITuple3.Base<T3, T6, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T6> _386()  {
    return new ITuple3.Base<T3, T8, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T6> _836()  {
    return new ITuple3.Base<T8, T3, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T3> _863()  {
    return new ITuple3.Base<T8, T6, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T3> _683()  {
    return new ITuple3.Base<T6, T8, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T8> _638()  {
    return new ITuple3.Base<T6, T3, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T8> _468()  {
    return new ITuple3.Base<T4, T6, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T6> _486()  {
    return new ITuple3.Base<T4, T8, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T6> _846()  {
    return new ITuple3.Base<T8, T4, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T4> _864()  {
    return new ITuple3.Base<T8, T6, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T4> _684()  {
    return new ITuple3.Base<T6, T8, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T8> _648()  {
    return new ITuple3.Base<T6, T4, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T8> _568()  {
    return new ITuple3.Base<T5, T6, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T6> _586()  {
    return new ITuple3.Base<T5, T8, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T6> _856()  {
    return new ITuple3.Base<T8, T5, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T5> _865()  {
    return new ITuple3.Base<T8, T6, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T5> _685()  {
    return new ITuple3.Base<T6, T8, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T8> _658()  {
    return new ITuple3.Base<T6, T5, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T8> _178()  {
    return new ITuple3.Base<T1, T7, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T7> _187()  {
    return new ITuple3.Base<T1, T8, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T7> _817()  {
    return new ITuple3.Base<T8, T1, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T1> _871()  {
    return new ITuple3.Base<T8, T7, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T1> _781()  {
    return new ITuple3.Base<T7, T8, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T8> _718()  {
    return new ITuple3.Base<T7, T1, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T8> _278()  {
    return new ITuple3.Base<T2, T7, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T7> _287()  {
    return new ITuple3.Base<T2, T8, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T7> _827()  {
    return new ITuple3.Base<T8, T2, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T2> _872()  {
    return new ITuple3.Base<T8, T7, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T2> _782()  {
    return new ITuple3.Base<T7, T8, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T8> _728()  {
    return new ITuple3.Base<T7, T2, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T8> _378()  {
    return new ITuple3.Base<T3, T7, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T7> _387()  {
    return new ITuple3.Base<T3, T8, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T7> _837()  {
    return new ITuple3.Base<T8, T3, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T3> _873()  {
    return new ITuple3.Base<T8, T7, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T3> _783()  {
    return new ITuple3.Base<T7, T8, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T8> _738()  {
    return new ITuple3.Base<T7, T3, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T8> _478()  {
    return new ITuple3.Base<T4, T7, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T7> _487()  {
    return new ITuple3.Base<T4, T8, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T7> _847()  {
    return new ITuple3.Base<T8, T4, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T4> _874()  {
    return new ITuple3.Base<T8, T7, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T4> _784()  {
    return new ITuple3.Base<T7, T8, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T8> _748()  {
    return new ITuple3.Base<T7, T4, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T8> _578()  {
    return new ITuple3.Base<T5, T7, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T7> _587()  {
    return new ITuple3.Base<T5, T8, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T7> _857()  {
    return new ITuple3.Base<T8, T5, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T5> _875()  {
    return new ITuple3.Base<T8, T7, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T5> _785()  {
    return new ITuple3.Base<T7, T8, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T8> _758()  {
    return new ITuple3.Base<T7, T5, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T8> _678()  {
    return new ITuple3.Base<T6, T7, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T7> _687()  {
    return new ITuple3.Base<T6, T8, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T7> _867()  {
    return new ITuple3.Base<T8, T6, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T6> _876()  {
    return new ITuple3.Base<T8, T7, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T6> _786()  {
    return new ITuple3.Base<T7, T8, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T8> _768()  {
    return new ITuple3.Base<T7, T6, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T9> _129()  {
    return new ITuple3.Base<T1, T2, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T2> _192()  {
    return new ITuple3.Base<T1, T9, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T2> _912()  {
    return new ITuple3.Base<T9, T1, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T1> _921()  {
    return new ITuple3.Base<T9, T2, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T1> _291()  {
    return new ITuple3.Base<T2, T9, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T9> _219()  {
    return new ITuple3.Base<T2, T1, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T9> _139()  {
    return new ITuple3.Base<T1, T3, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T3> _193()  {
    return new ITuple3.Base<T1, T9, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T3> _913()  {
    return new ITuple3.Base<T9, T1, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T1> _931()  {
    return new ITuple3.Base<T9, T3, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T1> _391()  {
    return new ITuple3.Base<T3, T9, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T9> _319()  {
    return new ITuple3.Base<T3, T1, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T9> _239()  {
    return new ITuple3.Base<T2, T3, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T3> _293()  {
    return new ITuple3.Base<T2, T9, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T3> _923()  {
    return new ITuple3.Base<T9, T2, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T2> _932()  {
    return new ITuple3.Base<T9, T3, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T2> _392()  {
    return new ITuple3.Base<T3, T9, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T9> _329()  {
    return new ITuple3.Base<T3, T2, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T9> _149()  {
    return new ITuple3.Base<T1, T4, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T4> _194()  {
    return new ITuple3.Base<T1, T9, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T4> _914()  {
    return new ITuple3.Base<T9, T1, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T1> _941()  {
    return new ITuple3.Base<T9, T4, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T1> _491()  {
    return new ITuple3.Base<T4, T9, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T9> _419()  {
    return new ITuple3.Base<T4, T1, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T9> _249()  {
    return new ITuple3.Base<T2, T4, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T4> _294()  {
    return new ITuple3.Base<T2, T9, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T4> _924()  {
    return new ITuple3.Base<T9, T2, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T2> _942()  {
    return new ITuple3.Base<T9, T4, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T2> _492()  {
    return new ITuple3.Base<T4, T9, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T9> _429()  {
    return new ITuple3.Base<T4, T2, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T9> _349()  {
    return new ITuple3.Base<T3, T4, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T4> _394()  {
    return new ITuple3.Base<T3, T9, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T4> _934()  {
    return new ITuple3.Base<T9, T3, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T3> _943()  {
    return new ITuple3.Base<T9, T4, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T3> _493()  {
    return new ITuple3.Base<T4, T9, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T9> _439()  {
    return new ITuple3.Base<T4, T3, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T9> _159()  {
    return new ITuple3.Base<T1, T5, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T5> _195()  {
    return new ITuple3.Base<T1, T9, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T5> _915()  {
    return new ITuple3.Base<T9, T1, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T1> _951()  {
    return new ITuple3.Base<T9, T5, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T1> _591()  {
    return new ITuple3.Base<T5, T9, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T9> _519()  {
    return new ITuple3.Base<T5, T1, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T9> _259()  {
    return new ITuple3.Base<T2, T5, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T5> _295()  {
    return new ITuple3.Base<T2, T9, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T5> _925()  {
    return new ITuple3.Base<T9, T2, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T2> _952()  {
    return new ITuple3.Base<T9, T5, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T2> _592()  {
    return new ITuple3.Base<T5, T9, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T9> _529()  {
    return new ITuple3.Base<T5, T2, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T9> _359()  {
    return new ITuple3.Base<T3, T5, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T5> _395()  {
    return new ITuple3.Base<T3, T9, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T5> _935()  {
    return new ITuple3.Base<T9, T3, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T3> _953()  {
    return new ITuple3.Base<T9, T5, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T3> _593()  {
    return new ITuple3.Base<T5, T9, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T9> _539()  {
    return new ITuple3.Base<T5, T3, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T9> _459()  {
    return new ITuple3.Base<T4, T5, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T5> _495()  {
    return new ITuple3.Base<T4, T9, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T5> _945()  {
    return new ITuple3.Base<T9, T4, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T4> _954()  {
    return new ITuple3.Base<T9, T5, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T4> _594()  {
    return new ITuple3.Base<T5, T9, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T9> _549()  {
    return new ITuple3.Base<T5, T4, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T9> _169()  {
    return new ITuple3.Base<T1, T6, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T6> _196()  {
    return new ITuple3.Base<T1, T9, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T6> _916()  {
    return new ITuple3.Base<T9, T1, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T1> _961()  {
    return new ITuple3.Base<T9, T6, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T1> _691()  {
    return new ITuple3.Base<T6, T9, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T9> _619()  {
    return new ITuple3.Base<T6, T1, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T9> _269()  {
    return new ITuple3.Base<T2, T6, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T6> _296()  {
    return new ITuple3.Base<T2, T9, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T6> _926()  {
    return new ITuple3.Base<T9, T2, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T2> _962()  {
    return new ITuple3.Base<T9, T6, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T2> _692()  {
    return new ITuple3.Base<T6, T9, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T9> _629()  {
    return new ITuple3.Base<T6, T2, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T9> _369()  {
    return new ITuple3.Base<T3, T6, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T6> _396()  {
    return new ITuple3.Base<T3, T9, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T6> _936()  {
    return new ITuple3.Base<T9, T3, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T3> _963()  {
    return new ITuple3.Base<T9, T6, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T3> _693()  {
    return new ITuple3.Base<T6, T9, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T9> _639()  {
    return new ITuple3.Base<T6, T3, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T9> _469()  {
    return new ITuple3.Base<T4, T6, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T6> _496()  {
    return new ITuple3.Base<T4, T9, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T6> _946()  {
    return new ITuple3.Base<T9, T4, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T4> _964()  {
    return new ITuple3.Base<T9, T6, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T4> _694()  {
    return new ITuple3.Base<T6, T9, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T9> _649()  {
    return new ITuple3.Base<T6, T4, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T9> _569()  {
    return new ITuple3.Base<T5, T6, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T6> _596()  {
    return new ITuple3.Base<T5, T9, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T6> _956()  {
    return new ITuple3.Base<T9, T5, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T5> _965()  {
    return new ITuple3.Base<T9, T6, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T5> _695()  {
    return new ITuple3.Base<T6, T9, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T9> _659()  {
    return new ITuple3.Base<T6, T5, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T7, T9> _179()  {
    return new ITuple3.Base<T1, T7, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T7> _197()  {
    return new ITuple3.Base<T1, T9, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T7> _917()  {
    return new ITuple3.Base<T9, T1, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T1> _971()  {
    return new ITuple3.Base<T9, T7, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T1> _791()  {
    return new ITuple3.Base<T7, T9, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T1, T9> _719()  {
    return new ITuple3.Base<T7, T1, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T7, T9> _279()  {
    return new ITuple3.Base<T2, T7, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T7> _297()  {
    return new ITuple3.Base<T2, T9, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T7> _927()  {
    return new ITuple3.Base<T9, T2, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T2> _972()  {
    return new ITuple3.Base<T9, T7, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T2> _792()  {
    return new ITuple3.Base<T7, T9, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T2, T9> _729()  {
    return new ITuple3.Base<T7, T2, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T7, T9> _379()  {
    return new ITuple3.Base<T3, T7, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T7> _397()  {
    return new ITuple3.Base<T3, T9, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T7> _937()  {
    return new ITuple3.Base<T9, T3, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T3> _973()  {
    return new ITuple3.Base<T9, T7, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T3> _793()  {
    return new ITuple3.Base<T7, T9, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T3, T9> _739()  {
    return new ITuple3.Base<T7, T3, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T7, T9> _479()  {
    return new ITuple3.Base<T4, T7, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T7> _497()  {
    return new ITuple3.Base<T4, T9, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T7> _947()  {
    return new ITuple3.Base<T9, T4, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T4> _974()  {
    return new ITuple3.Base<T9, T7, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T4> _794()  {
    return new ITuple3.Base<T7, T9, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T4, T9> _749()  {
    return new ITuple3.Base<T7, T4, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T7, T9> _579()  {
    return new ITuple3.Base<T5, T7, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T7> _597()  {
    return new ITuple3.Base<T5, T9, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T7> _957()  {
    return new ITuple3.Base<T9, T5, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T5> _975()  {
    return new ITuple3.Base<T9, T7, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T5> _795()  {
    return new ITuple3.Base<T7, T9, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T5, T9> _759()  {
    return new ITuple3.Base<T7, T5, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T7, T9> _679()  {
    return new ITuple3.Base<T6, T7, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T7> _697()  {
    return new ITuple3.Base<T6, T9, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T7> _967()  {
    return new ITuple3.Base<T9, T6, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T6> _976()  {
    return new ITuple3.Base<T9, T7, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T6> _796()  {
    return new ITuple3.Base<T7, T9, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T6, T9> _769()  {
    return new ITuple3.Base<T7, T6, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T8, T9> _189()  {
    return new ITuple3.Base<T1, T8, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T9, T8> _198()  {
    return new ITuple3.Base<T1, T9, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T1, T8> _918()  {
    return new ITuple3.Base<T9, T1, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T1> _981()  {
    return new ITuple3.Base<T9, T8, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T1> _891()  {
    return new ITuple3.Base<T8, T9, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _3()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T1, T9> _819()  {
    return new ITuple3.Base<T8, T1, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T8, T9> _289()  {
    return new ITuple3.Base<T2, T8, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T9, T8> _298()  {
    return new ITuple3.Base<T2, T9, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T2, T8> _928()  {
    return new ITuple3.Base<T9, T2, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T2> _982()  {
    return new ITuple3.Base<T9, T8, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T2> _892()  {
    return new ITuple3.Base<T8, T9, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _3()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T2, T9> _829()  {
    return new ITuple3.Base<T8, T2, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T8, T9> _389()  {
    return new ITuple3.Base<T3, T8, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T9, T8> _398()  {
    return new ITuple3.Base<T3, T9, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T3, T8> _938()  {
    return new ITuple3.Base<T9, T3, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T3> _983()  {
    return new ITuple3.Base<T9, T8, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T3> _893()  {
    return new ITuple3.Base<T8, T9, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T3, T9> _839()  {
    return new ITuple3.Base<T8, T3, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T8, T9> _489()  {
    return new ITuple3.Base<T4, T8, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T9, T8> _498()  {
    return new ITuple3.Base<T4, T9, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T4, T8> _948()  {
    return new ITuple3.Base<T9, T4, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T4> _984()  {
    return new ITuple3.Base<T9, T8, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T4> _894()  {
    return new ITuple3.Base<T8, T9, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _3()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T4, T9> _849()  {
    return new ITuple3.Base<T8, T4, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T8, T9> _589()  {
    return new ITuple3.Base<T5, T8, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T9, T8> _598()  {
    return new ITuple3.Base<T5, T9, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T5, T8> _958()  {
    return new ITuple3.Base<T9, T5, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T5> _985()  {
    return new ITuple3.Base<T9, T8, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T5> _895()  {
    return new ITuple3.Base<T8, T9, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _3()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T5, T9> _859()  {
    return new ITuple3.Base<T8, T5, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T8, T9> _689()  {
    return new ITuple3.Base<T6, T8, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T9, T8> _698()  {
    return new ITuple3.Base<T6, T9, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T6, T8> _968()  {
    return new ITuple3.Base<T9, T6, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T6> _986()  {
    return new ITuple3.Base<T9, T8, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T6> _896()  {
    return new ITuple3.Base<T8, T9, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _3()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T6, T9> _869()  {
    return new ITuple3.Base<T8, T6, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T8, T9> _789()  {
    return new ITuple3.Base<T7, T8, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 7th, 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T7, T9, T8> _798()  {
    return new ITuple3.Base<T7, T9, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T7, T8> _978()  {
    return new ITuple3.Base<T9, T7, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _3()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 9th, 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T9, T8, T7> _987()  {
    return new ITuple3.Base<T9, T8, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T9, T7> _897()  {
    return new ITuple3.Base<T8, T9, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _3()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 8th, 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T8, T7, T9> _879()  {
    return new ITuple3.Base<T8, T7, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _3()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T2> _12()  {
    return new ITuple2.Base<T1, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T1> _21()  {
    return new ITuple2.Base<T2, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T3> _13()  {
    return new ITuple2.Base<T1, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T1> _31()  {
    return new ITuple2.Base<T3, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T3> _23()  {
    return new ITuple2.Base<T2, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T2> _32()  {
    return new ITuple2.Base<T3, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T4> _14()  {
    return new ITuple2.Base<T1, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T1> _41()  {
    return new ITuple2.Base<T4, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T4> _24()  {
    return new ITuple2.Base<T2, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T2> _42()  {
    return new ITuple2.Base<T4, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T4> _34()  {
    return new ITuple2.Base<T3, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T3> _43()  {
    return new ITuple2.Base<T4, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T5> _15()  {
    return new ITuple2.Base<T1, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T1> _51()  {
    return new ITuple2.Base<T5, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T5> _25()  {
    return new ITuple2.Base<T2, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T2> _52()  {
    return new ITuple2.Base<T5, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T5> _35()  {
    return new ITuple2.Base<T3, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T3> _53()  {
    return new ITuple2.Base<T5, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T5> _45()  {
    return new ITuple2.Base<T4, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T4> _54()  {
    return new ITuple2.Base<T5, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T6> _16()  {
    return new ITuple2.Base<T1, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T1> _61()  {
    return new ITuple2.Base<T6, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T6> _26()  {
    return new ITuple2.Base<T2, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T2> _62()  {
    return new ITuple2.Base<T6, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T6> _36()  {
    return new ITuple2.Base<T3, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T3> _63()  {
    return new ITuple2.Base<T6, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T6> _46()  {
    return new ITuple2.Base<T4, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T4> _64()  {
    return new ITuple2.Base<T6, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T6> _56()  {
    return new ITuple2.Base<T5, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T5> _65()  {
    return new ITuple2.Base<T6, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T7> _17()  {
    return new ITuple2.Base<T1, T7>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T1> _71()  {
    return new ITuple2.Base<T7, T1>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T7> _27()  {
    return new ITuple2.Base<T2, T7>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T2> _72()  {
    return new ITuple2.Base<T7, T2>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T7> _37()  {
    return new ITuple2.Base<T3, T7>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T3> _73()  {
    return new ITuple2.Base<T7, T3>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T7> _47()  {
    return new ITuple2.Base<T4, T7>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T4> _74()  {
    return new ITuple2.Base<T7, T4>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T7> _57()  {
    return new ITuple2.Base<T5, T7>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T5> _75()  {
    return new ITuple2.Base<T7, T5>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T7> _67()  {
    return new ITuple2.Base<T6, T7>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T6> _76()  {
    return new ITuple2.Base<T7, T6>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T8> _18()  {
    return new ITuple2.Base<T1, T8>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T1> _81()  {
    return new ITuple2.Base<T8, T1>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T8> _28()  {
    return new ITuple2.Base<T2, T8>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T2> _82()  {
    return new ITuple2.Base<T8, T2>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T8> _38()  {
    return new ITuple2.Base<T3, T8>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T3> _83()  {
    return new ITuple2.Base<T8, T3>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T8> _48()  {
    return new ITuple2.Base<T4, T8>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T4> _84()  {
    return new ITuple2.Base<T8, T4>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T8> _58()  {
    return new ITuple2.Base<T5, T8>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T5> _85()  {
    return new ITuple2.Base<T8, T5>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T8> _68()  {
    return new ITuple2.Base<T6, T8>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T6> _86()  {
    return new ITuple2.Base<T8, T6>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T8> _78()  {
    return new ITuple2.Base<T7, T8>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T7> _87()  {
    return new ITuple2.Base<T8, T7>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T9> _19()  {
    return new ITuple2.Base<T1, T9>() {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T1> _91()  {
    return new ITuple2.Base<T9, T1>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T1 _2()
      {
        return ITuple9.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T9> _29()  {
    return new ITuple2.Base<T2, T9>() {
      @Override
      public T2 _1()
      {
        return ITuple9.this._2();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T2> _92()  {
    return new ITuple2.Base<T9, T2>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T9> _39()  {
    return new ITuple2.Base<T3, T9>() {
      @Override
      public T3 _1()
      {
        return ITuple9.this._3();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T3> _93()  {
    return new ITuple2.Base<T9, T3>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T3 _2()
      {
        return ITuple9.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T9> _49()  {
    return new ITuple2.Base<T4, T9>() {
      @Override
      public T4 _1()
      {
        return ITuple9.this._4();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T4> _94()  {
    return new ITuple2.Base<T9, T4>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T4 _2()
      {
        return ITuple9.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T9> _59()  {
    return new ITuple2.Base<T5, T9>() {
      @Override
      public T5 _1()
      {
        return ITuple9.this._5();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T5> _95()  {
    return new ITuple2.Base<T9, T5>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T5 _2()
      {
        return ITuple9.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T9> _69()  {
    return new ITuple2.Base<T6, T9>() {
      @Override
      public T6 _1()
      {
        return ITuple9.this._6();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T6> _96()  {
    return new ITuple2.Base<T9, T6>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T6 _2()
      {
        return ITuple9.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 7th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T7, T9> _79()  {
    return new ITuple2.Base<T7, T9>() {
      @Override
      public T7 _1()
      {
        return ITuple9.this._7();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 7th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T7> _97()  {
    return new ITuple2.Base<T9, T7>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T7 _2()
      {
        return ITuple9.this._7();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 8th, 9th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T8, T9> _89()  {
    return new ITuple2.Base<T8, T9>() {
      @Override
      public T8 _1()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _2()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 9th, 8th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T9, T8> _98()  {
    return new ITuple2.Base<T9, T8>() {
      @Override
      public T9 _1()
      {
        return ITuple9.this._9();
      }

      @Override
      public T8 _2()
      {
        return ITuple9.this._8();
      }
    };
  }

  /**
   * Convert this 9-tuple into a {@link ITuple9.Base base tuple} which provides useful implementations for standard methods.
   * @return base view of this tuple
   */
  @NotNull
  default ITuple9.Base<T1, T2, T3, T4, T5, T6, T7, T8, T9> asBase()
  {
    return new Base<T1, T2, T3, T4, T5, T6, T7, T8, T9>()
    {
      @Override
      public T1 _1()
      {
        return ITuple9.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple9.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple9.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple9.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple9.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple9.this._6();
      }

      @Override
      public T7 _7()
      {
        return ITuple9.this._7();
      }

      @Override
      public T8 _8()
      {
        return ITuple9.this._8();
      }

      @Override
      public T9 _9()
      {
        return ITuple9.this._9();
      }
    };
  }

  /**
   * Convert this into an object of a concrete tuple implementation.
   * This is useful because implementations may just be a view of something else.
   * This method makes sure to decouple the tuple from the viewed object.
   * The resulting tuple may contain {@code null} elements,
   * see {@link #frozenNotNull()} for a method which returns tuples
   * which don't have nullable elements.
   * @return standalone tuple object
   */
  @NotNull
  default NTuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> frozen()
  {
    return new NTuple9<>(_1(), _2(), _3(), _4(), _5(), _6(), _7(), _8(), _9());
  }

  /**
   * Convert this into an object of a concrete tuple implementation.
   * This is useful because implementations may just be a view of something else.
   * This method makes sure to decouple the tuple from the viewed object.
   * The resulting tuple is guaranteed not to have {@code null}
   * elements, but if this interface has {@code null} elements this method
   * will throw a {@link NullPointerException}.
   *<p>
   * See {@link #frozen()} for a method which will not throw exceptions.
   * @return standalone tuple object
   * @throws NullPointerException if any element of this tuple is {@code null}
   */
  @NotNull
  default Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> frozenNotNull()
  {
    return new Tuple9<>(Objects.requireNonNull(_1(), "_1()"),
                        Objects.requireNonNull(_2(), "_2()"),
                        Objects.requireNonNull(_3(), "_3()"),
                        Objects.requireNonNull(_4(), "_4()"),
                        Objects.requireNonNull(_5(), "_5()"),
                        Objects.requireNonNull(_6(), "_6()"),
                        Objects.requireNonNull(_7(), "_7()"),
                        Objects.requireNonNull(_8(), "_8()"),
                        Objects.requireNonNull(_9(), "_9()"));
  }

  /**
   * Invoke a %d-argument function on this tuple.
   * @param function function called with the unpacked elements of this tuple
   * @param <T> function return type
   * @return result of calling the function
   */
  default <T> T invoke(@NotNull Function9<T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> function)
  {
    return function.apply(_1(), _2(), _3(), _4(), _5(), _6(), _7(), _8(), _9());
  }

  /**
   * Send this tuple unpacked to a 9-argument procedure.
   * @param procedure procedure called with the unpacked elements of this tuple
   */
  default void sendTo(@NotNull Procedure9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> procedure)
  {
    procedure.apply(_1(), _2(), _3(), _4(), _5(), _6(), _7(), _8(), _9());
  }

  /**
   * Test a 9-argument predicate with this tuple unpacked.
   * @param predicate predicate called with the unpacked elements of this tuple
   * @return the predicate's result
   */
  default boolean testBy(@NotNull Predicate9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> predicate)
  {
    return predicate.test(_1(), _2(), _3(), _4(), _5(), _6(), _7(), _8(), _9());
  }

  /**
   * Create a new 9-tuple on the fly.
   * This is especially useful for temporary usage, you might want to create a {@link Tuple9} 
   * instead as that gives guarantees of the non-nullness of its elements, or a {@link NTuple9}
   * as that at least is serializable (as is {@code Tuple9}). 
   * @param elem1 first element of returned tuple
   * @param elem2 second element of returned tuple
   * @param elem3 third element of returned tuple
   * @param elem4 fourth element of returned tuple
   * @param elem5 fifth element of returned tuple
   * @param elem6 sixth element of returned tuple
   * @param elem7 seventh element of returned tuple
   * @param elem8 eighth element of returned tuple
   * @param elem9 nineth element of returned tuple
   * @param <E1> type of first element
   * @param <E2> type of second element
   * @param <E3> type of third element
   * @param <E4> type of fourth element
   * @param <E5> type of fifth element
   * @param <E6> type of sixth element
   * @param <E7> type of seventh element
   * @param <E8> type of eighth element
   * @param <E9> type of nineth element
   * @return 9-tuple view of the given elements
   */
  @NotNull
  static <E1, E2, E3, E4, E5, E6, E7, E8, E9> ITuple9<E1, E2, E3, E4, E5, E6, E7, E8, E9> view(E1 elem1, E2 elem2, E3 elem3, E4 elem4, E5 elem5, E6 elem6, E7 elem7, E8 elem8, E9 elem9)
  {
    return new ITuple9.Base<E1, E2, E3, E4, E5, E6, E7, E8, E9>() {
      @Override
      public E1 _1()
      {
        return elem1;
      }

      @Override
      public E2 _2()
      {
        return elem2;
      }

      @Override
      public E3 _3()
      {
        return elem3;
      }

      @Override
      public E4 _4()
      {
        return elem4;
      }

      @Override
      public E5 _5()
      {
        return elem5;
      }

      @Override
      public E6 _6()
      {
        return elem6;
      }

      @Override
      public E7 _7()
      {
        return elem7;
      }

      @Override
      public E8 _8()
      {
        return elem8;
      }

      @Override
      public E9 _9()
      {
        return elem9;
      }
    };
  }

  /**
   * Basic implementation of equals for 9-tuples.
   * This can be used in implementations to implement {@link Object#equals(Object)}.
   * Don't forget hashing: {@link #hash(ITuple9)}
   * @param tuple tuple to compare
   * @param o     other object to compare
   * @return {@code false} if {@code o} is {@code null}, not a {@code ITuple9}, or its members differ<br>
   *         {@code true} otherwise
   */
  static boolean equals(@NotNull ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> tuple, @Nullable Object o)
  {
    if (tuple == o) {
      return true;
    }
    if (!(o instanceof ITuple9)) {
      // null will come here, too
      return false;
    }
    final ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> other = (ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?>)o;
    return Objects.equals(tuple._1(), other._1())  &&  Objects.equals(tuple._2(), other._2())  &&
           Objects.equals(tuple._3(), other._3())  &&  Objects.equals(tuple._4(), other._4())  &&
           Objects.equals(tuple._5(), other._5())  &&  Objects.equals(tuple._6(), other._6())  &&
           Objects.equals(tuple._7(), other._7())  &&  Objects.equals(tuple._8(), other._8())  &&
           Objects.equals(tuple._9(), other._9());
  }

  /**
   * Basic implementation for calculating a hash code of a 9-tuple.
   * This can be used in implementations to implement {@link Object#hashCode()}.
   * Don't forget equals: {@link #equals(ITuple9, Object)}.
   * @param tuple tuple to hash
   * @return hash code
   */
  static int hash(@NotNull ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> tuple)
  {
    return Objects.hash(tuple._1(), tuple._2(), tuple._3(), tuple._4(), tuple._5(), tuple._6(), tuple._7(), tuple._8(), tuple._9());
  }

  /**
   * Basic implementation for creating a string from a 9-tuple.
   * This one uses {@code "ITuple9"} as prefix.
   * This can be used im implementations to implement {@link Object#toString()}.
   * @param tuple tuple to convert
   * @return text form
   * @see #toString(String, ITuple9)
   */
  @NotNull
  static String toString(@NotNull ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> tuple)
  {
    return toString("ITuple9", tuple);
  }

  /**
   * Basic implementation for creating a string from a 9-tuple.
   * This can be used im implementations to implement {@link Object#toString()}.
   * @param prefix prefix for the output
   * @param tuple tuple to convert
   * @return text form
   * @see #toString(ITuple9)
   */
  @NotNull
  static String toString(@NotNull String prefix,
                         @NotNull ITuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> tuple)
  {
    return prefix + '(' + tuple._1() +  ',' + tuple._2() +  ',' + tuple._3() +  ',' + tuple._4() +  ',' + tuple._5() +  ',' + tuple._6() +  ',' + tuple._7() +  ',' + tuple._8() +  ',' + tuple._9() +  ')';
  }

  /**
   * Combine a 1-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 1-argument function.
   * @param fn1  1-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 1-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function<S1, R> concat1(@NotNull Function<S1, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                          @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 1-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 1-argument consumer/procedure.
   * @param fn1    1-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 1-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Consumer<S1> concatProc1(@NotNull Function<S1, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                           @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1) -> fn1.apply(v1).sendTo(proc2);
  }

  /**
   * Combine a 1-argument function returning a 9-tuple with a 9-parameter predicate into a 1-argument predicate.
   * @param fn1    1-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 1-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate<S1> concatPred1(@NotNull Function<S1, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                            @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1) -> fn1.apply(v1).testBy(pred2);
  }

  /**
   * Combine a 2-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 2-argument function.
   * @param fn1  2-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 2-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  BiFunction<S1, S2, R> concat2(@NotNull BiFunction<S1, S2, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                                @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 2-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 2-argument consumer/procedure.
   * @param fn1    2-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 2-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  BiConsumer<S1, S2> concatProc2(@NotNull BiFunction<S1, S2, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                                 @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2) -> fn1.apply(v1, v2).sendTo(proc2);
  }

  /**
   * Combine a 2-argument function returning a 9-tuple with a 9-parameter predicate into a 2-argument predicate.
   * @param fn1    2-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 2-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  BiPredicate<S1, S2> concatPred2(@NotNull BiFunction<S1, S2, ? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>> fn1,
                                  @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2) -> fn1.apply(v1, v2).testBy(pred2);
  }

  /**
   * Combine a 3-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 3-argument function.
   * @param fn1  3-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 3-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function3<R, S1, S2, S3> concat3(@NotNull Function3<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3> fn1,
                                   @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 3-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 3-argument consumer/procedure.
   * @param fn1    3-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 3-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure3<S1, S2, S3> concatProc3(@NotNull Function3<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3> fn1,
                                     @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3) -> fn1.apply(v1, v2, v3).sendTo(proc2);
  }

  /**
   * Combine a 3-argument function returning a 9-tuple with a 9-parameter predicate into a 3-argument predicate.
   * @param fn1    3-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 3-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate3<S1, S2, S3> concatPred3(@NotNull Function3<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3> fn1,
                                     @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3) -> fn1.apply(v1, v2, v3).testBy(pred2);
  }

  /**
   * Combine a 4-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 4-argument function.
   * @param fn1  4-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 4-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function4<R, S1, S2, S3, S4> concat4(@NotNull Function4<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4> fn1,
                                       @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 4-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 4-argument consumer/procedure.
   * @param fn1    4-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 4-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure4<S1, S2, S3, S4> concatProc4(@NotNull Function4<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4> fn1,
                                         @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3, v4) -> fn1.apply(v1, v2, v3, v4).sendTo(proc2);
  }

  /**
   * Combine a 4-argument function returning a 9-tuple with a 9-parameter predicate into a 4-argument predicate.
   * @param fn1    4-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 4-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate4<S1, S2, S3, S4> concatPred4(@NotNull Function4<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4> fn1,
                                         @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3, v4) -> fn1.apply(v1, v2, v3, v4).testBy(pred2);
  }

  /**
   * Combine a 5-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 5-argument function.
   * @param fn1  5-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 5-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function5<R, S1, S2, S3, S4, S5> concat5(@NotNull Function5<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5> fn1,
                                           @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 5-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 5-argument consumer/procedure.
   * @param fn1    5-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 5-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure5<S1, S2, S3, S4, S5> concatProc5(@NotNull Function5<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5> fn1,
                                             @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3, v4, v5) -> fn1.apply(v1, v2, v3, v4, v5).sendTo(proc2);
  }

  /**
   * Combine a 5-argument function returning a 9-tuple with a 9-parameter predicate into a 5-argument predicate.
   * @param fn1    5-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 5-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate5<S1, S2, S3, S4, S5> concatPred5(@NotNull Function5<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5> fn1,
                                             @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3, v4, v5) -> fn1.apply(v1, v2, v3, v4, v5).testBy(pred2);
  }

  /**
   * Combine a 6-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 6-argument function.
   * @param fn1  6-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 6-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function6<R, S1, S2, S3, S4, S5, S6> concat6(@NotNull Function6<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6> fn1,
                                               @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 6-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 6-argument consumer/procedure.
   * @param fn1    6-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 6-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure6<S1, S2, S3, S4, S5, S6> concatProc6(@NotNull Function6<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6> fn1,
                                                 @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3, v4, v5, v6) -> fn1.apply(v1, v2, v3, v4, v5, v6).sendTo(proc2);
  }

  /**
   * Combine a 6-argument function returning a 9-tuple with a 9-parameter predicate into a 6-argument predicate.
   * @param fn1    6-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 6-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate6<S1, S2, S3, S4, S5, S6> concatPred6(@NotNull Function6<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6> fn1,
                                                 @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3, v4, v5, v6) -> fn1.apply(v1, v2, v3, v4, v5, v6).testBy(pred2);
  }

  /**
   * Combine a 7-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 7-argument function.
   * @param fn1  7-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 7-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <S7> seventh argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function7<R, S1, S2, S3, S4, S5, S6, S7> concat7(@NotNull Function7<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                   @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 7-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 7-argument consumer/procedure.
   * @param fn1    7-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 7-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure7<S1, S2, S3, S4, S5, S6, S7> concatProc7(@NotNull Function7<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                     @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3, v4, v5, v6, v7) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7).sendTo(proc2);
  }

  /**
   * Combine a 7-argument function returning a 9-tuple with a 9-parameter predicate into a 7-argument predicate.
   * @param fn1    7-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 7-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate7<S1, S2, S3, S4, S5, S6, S7> concatPred7(@NotNull Function7<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                     @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3, v4, v5, v6, v7) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7).testBy(pred2);
  }

  /**
   * Combine a 8-argument function returning a 9-tuple with a 9-parameter function returning another result value
   * into one 8-argument function.
   * @param fn1  8-argument function returning a 9-tuple
   * @param fn2  9-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 8-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <S7> seventh argument of incoming function {@code fn1} and returned function
   * @param <S8> eighth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6, E7, E8, E9, R>
  Function8<R, S1, S2, S3, S4, S5, S6, S7, S8> concat8(@NotNull Function8<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                       @NotNull Function9<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 8-argument function returning a 9-tuple with a 9-parameter consumer/procedure into a 8-argument consumer/procedure.
   * @param fn1    8-argument function returning a 9-tuple
   * @param proc2  9-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 8-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <S8> eighth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Procedure8<S1, S2, S3, S4, S5, S6, S7, S8> concatProc8(@NotNull Function8<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                         @NotNull Procedure9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> proc2)
  {
    return (v1, v2, v3, v4, v5, v6, v7, v8) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7, v8).sendTo(proc2);
  }

  /**
   * Combine a 8-argument function returning a 9-tuple with a 9-parameter predicate into a 8-argument predicate.
   * @param fn1    8-argument function returning a 9-tuple
   * @param pred2  9-argument predicate which can use the expanded tuple elements as arguments 
   * @return 8-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <S8> eighth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <E7> type of seventh element of intermediate tuple 
   * @param <E8> type of eighth element of intermediate tuple 
   * @param <E9> type of nineth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6, E7, E8, E9>
  Predicate8<S1, S2, S3, S4, S5, S6, S7, S8> concatPred8(@NotNull Function8<? extends ITuple9<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6, ? extends E7, ? extends E8, ? extends E9>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                         @NotNull Predicate9<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6, ? super E7, ? super E8, ? super E9> pred2)
  {
    return (v1, v2, v3, v4, v5, v6, v7, v8) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7, v8).testBy(pred2);
  }

  /**
   * Abstract base implementation of a 9-tuple.
   * This provides standard implementations for {@code java.lang.Object} methods
   * {@code equals()}, {@code hashCode()} and {@code toString()}. Therefore it is
   * most useful if you implement a 9-tuple on the fly.
   * @param <T1> type of first element
   * @param <T2> type of second element
   * @param <T3> type of third element
   * @param <T4> type of fourth element
   * @param <T5> type of fifth element
   * @param <T6> type of sixth element
   * @param <T7> type of seventh element
   * @param <T8> type of eighth element
   * @param <T9> type of nineth element
   */
  abstract class Base<T1, T2, T3, T4, T5, T6, T7, T8, T9> implements ITuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
  {
    @NotNull
    @Override
    public Base<T1, T2, T3, T4, T5, T6, T7, T8, T9> asBase()
    {
      return this;
    }

    @Override
    public int hashCode()
    {
      return ITuple9.hash(this);
    }

    @Override
    public boolean equals(Object obj)
    {
      return ITuple9.equals(this, obj);
    }

    @Override
    public String toString()
    {
      return ITuple9.toString(this);
    }
  }
}
