// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2021 - 2022  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.tuple;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.function.*;

import java.util.Objects;
import java.util.function.*;

/**
 * General interface for immutable 6-tuples.
 * <p>
 * This is sometimes useful to access either {@link Tuple6} or {@link NTuple6} in a general way,
 * although in most cases the concrete implementations are usually preferable.
 * <p>
 * If you want to iterate over a tuple or access its elements by index
 * (note that both is only possible for a common super type of the tuple's types)
 * {@link de.caff.generics.Indexable#viewTuple(ITuple6)} will come to help.
 * <p>
 * Note that this class is automatically created by {@code tools.TupleClassCreator} (not yet public).
 *
 * @param <T1> type of first element
 * @param <T2> type of second element
 * @param <T3> type of third element
 * @param <T4> type of fourth element
 * @param <T5> type of fifth element
 * @param <T6> type of sixth element
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 17, 2021
 * @see Tuple6
 * @see NTuple6
 */
public interface ITuple6<T1, T2, T3, T4, T5, T6>
{
  /**
   * Get the first element.
   * @return first element
   */
  T1 _1();

  /**
   * Get the second element.
   * @return second element
   */
  T2 _2();

  /**
   * Get the third element.
   * @return third element
   */
  T3 _3();

  /**
   * Get the fourth element.
   * @return fourth element
   */
  T4 _4();

  /**
   * Get the fifth element.
   * @return fifth element
   */
  T5 _5();

  /**
   * Get the sixth element.
   * @return sixth element
   */
  T6 _6();

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T5> _12345()  {
    return new ITuple5.Base<T1, T2, T3, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T4, T6> _12346()  {
    return new ITuple5.Base<T1, T2, T3, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _5()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T3, T5, T6> _12356()  {
    return new ITuple5.Base<T1, T2, T3, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T2, T4, T5, T6> _12456()  {
    return new ITuple5.Base<T1, T2, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T1, T3, T4, T5, T6> _13456()  {
    return new ITuple5.Base<T1, T3, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 5-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple5<T2, T3, T4, T5, T6> _23456()  {
    return new ITuple5.Base<T2, T3, T4, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _5()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T4> _1234()  {
    return new ITuple4.Base<T1, T2, T3, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T5> _1235()  {
    return new ITuple4.Base<T1, T2, T3, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T5> _1245()  {
    return new ITuple4.Base<T1, T2, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T5> _1345()  {
    return new ITuple4.Base<T1, T3, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T5> _2345()  {
    return new ITuple4.Base<T2, T3, T4, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _4()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T3, T6> _1236()  {
    return new ITuple4.Base<T1, T2, T3, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T4, T6> _1246()  {
    return new ITuple4.Base<T1, T2, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T4, T6> _1346()  {
    return new ITuple4.Base<T1, T3, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T4, T6> _2346()  {
    return new ITuple4.Base<T2, T3, T4, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 2nd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T2, T5, T6> _1256()  {
    return new ITuple4.Base<T1, T2, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T3, T5, T6> _1356()  {
    return new ITuple4.Base<T1, T3, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T3, T5, T6> _2356()  {
    return new ITuple4.Base<T2, T3, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 1st, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T1, T4, T5, T6> _1456()  {
    return new ITuple4.Base<T1, T4, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 2nd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T2, T4, T5, T6> _2456()  {
    return new ITuple4.Base<T2, T4, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 4-tuple from this one where the elements are ordered: 3rd, 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple4<T3, T4, T5, T6> _3456()  {
    return new ITuple4.Base<T3, T4, T5, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _4()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T3> _123()  {
    return new ITuple3.Base<T1, T2, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T2> _132()  {
    return new ITuple3.Base<T1, T3, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T2> _312()  {
    return new ITuple3.Base<T3, T1, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T1> _321()  {
    return new ITuple3.Base<T3, T2, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T1> _231()  {
    return new ITuple3.Base<T2, T3, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T3> _213()  {
    return new ITuple3.Base<T2, T1, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T4> _124()  {
    return new ITuple3.Base<T1, T2, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T2> _142()  {
    return new ITuple3.Base<T1, T4, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T2> _412()  {
    return new ITuple3.Base<T4, T1, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T1> _421()  {
    return new ITuple3.Base<T4, T2, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T1> _241()  {
    return new ITuple3.Base<T2, T4, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T4> _214()  {
    return new ITuple3.Base<T2, T1, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T4> _134()  {
    return new ITuple3.Base<T1, T3, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T3> _143()  {
    return new ITuple3.Base<T1, T4, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T3> _413()  {
    return new ITuple3.Base<T4, T1, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T1> _431()  {
    return new ITuple3.Base<T4, T3, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T1> _341()  {
    return new ITuple3.Base<T3, T4, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T4> _314()  {
    return new ITuple3.Base<T3, T1, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T4> _234()  {
    return new ITuple3.Base<T2, T3, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T3> _243()  {
    return new ITuple3.Base<T2, T4, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T3> _423()  {
    return new ITuple3.Base<T4, T2, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T2> _432()  {
    return new ITuple3.Base<T4, T3, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T2> _342()  {
    return new ITuple3.Base<T3, T4, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T4> _324()  {
    return new ITuple3.Base<T3, T2, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T5> _125()  {
    return new ITuple3.Base<T1, T2, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T2> _152()  {
    return new ITuple3.Base<T1, T5, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T2> _512()  {
    return new ITuple3.Base<T5, T1, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T1> _521()  {
    return new ITuple3.Base<T5, T2, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T1> _251()  {
    return new ITuple3.Base<T2, T5, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T5> _215()  {
    return new ITuple3.Base<T2, T1, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T5> _135()  {
    return new ITuple3.Base<T1, T3, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T3> _153()  {
    return new ITuple3.Base<T1, T5, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T3> _513()  {
    return new ITuple3.Base<T5, T1, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T1> _531()  {
    return new ITuple3.Base<T5, T3, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T1> _351()  {
    return new ITuple3.Base<T3, T5, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T5> _315()  {
    return new ITuple3.Base<T3, T1, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T5> _235()  {
    return new ITuple3.Base<T2, T3, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T3> _253()  {
    return new ITuple3.Base<T2, T5, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T3> _523()  {
    return new ITuple3.Base<T5, T2, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T2> _532()  {
    return new ITuple3.Base<T5, T3, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T2> _352()  {
    return new ITuple3.Base<T3, T5, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T5> _325()  {
    return new ITuple3.Base<T3, T2, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T5> _145()  {
    return new ITuple3.Base<T1, T4, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T4> _154()  {
    return new ITuple3.Base<T1, T5, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T4> _514()  {
    return new ITuple3.Base<T5, T1, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T1> _541()  {
    return new ITuple3.Base<T5, T4, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T1> _451()  {
    return new ITuple3.Base<T4, T5, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T5> _415()  {
    return new ITuple3.Base<T4, T1, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T5> _245()  {
    return new ITuple3.Base<T2, T4, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T4> _254()  {
    return new ITuple3.Base<T2, T5, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T4> _524()  {
    return new ITuple3.Base<T5, T2, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T2> _542()  {
    return new ITuple3.Base<T5, T4, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T2> _452()  {
    return new ITuple3.Base<T4, T5, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T5> _425()  {
    return new ITuple3.Base<T4, T2, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T5> _345()  {
    return new ITuple3.Base<T3, T4, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T4> _354()  {
    return new ITuple3.Base<T3, T5, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T4> _534()  {
    return new ITuple3.Base<T5, T3, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T3> _543()  {
    return new ITuple3.Base<T5, T4, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T3> _453()  {
    return new ITuple3.Base<T4, T5, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T5> _435()  {
    return new ITuple3.Base<T4, T3, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T2, T6> _126()  {
    return new ITuple3.Base<T1, T2, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T2> _162()  {
    return new ITuple3.Base<T1, T6, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T2> _612()  {
    return new ITuple3.Base<T6, T1, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T1> _621()  {
    return new ITuple3.Base<T6, T2, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T1> _261()  {
    return new ITuple3.Base<T2, T6, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T1, T6> _216()  {
    return new ITuple3.Base<T2, T1, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T3, T6> _136()  {
    return new ITuple3.Base<T1, T3, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T3> _163()  {
    return new ITuple3.Base<T1, T6, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T3> _613()  {
    return new ITuple3.Base<T6, T1, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T1> _631()  {
    return new ITuple3.Base<T6, T3, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T1> _361()  {
    return new ITuple3.Base<T3, T6, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T1, T6> _316()  {
    return new ITuple3.Base<T3, T1, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T3, T6> _236()  {
    return new ITuple3.Base<T2, T3, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T3> _263()  {
    return new ITuple3.Base<T2, T6, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T3> _623()  {
    return new ITuple3.Base<T6, T2, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T2> _632()  {
    return new ITuple3.Base<T6, T3, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T2> _362()  {
    return new ITuple3.Base<T3, T6, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T2, T6> _326()  {
    return new ITuple3.Base<T3, T2, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T4, T6> _146()  {
    return new ITuple3.Base<T1, T4, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T4> _164()  {
    return new ITuple3.Base<T1, T6, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T4> _614()  {
    return new ITuple3.Base<T6, T1, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T1> _641()  {
    return new ITuple3.Base<T6, T4, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T1> _461()  {
    return new ITuple3.Base<T4, T6, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T1, T6> _416()  {
    return new ITuple3.Base<T4, T1, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T4, T6> _246()  {
    return new ITuple3.Base<T2, T4, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T4> _264()  {
    return new ITuple3.Base<T2, T6, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T4> _624()  {
    return new ITuple3.Base<T6, T2, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T2> _642()  {
    return new ITuple3.Base<T6, T4, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T2> _462()  {
    return new ITuple3.Base<T4, T6, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T2, T6> _426()  {
    return new ITuple3.Base<T4, T2, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T4, T6> _346()  {
    return new ITuple3.Base<T3, T4, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T4> _364()  {
    return new ITuple3.Base<T3, T6, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T4> _634()  {
    return new ITuple3.Base<T6, T3, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T3> _643()  {
    return new ITuple3.Base<T6, T4, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T3> _463()  {
    return new ITuple3.Base<T4, T6, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T3, T6> _436()  {
    return new ITuple3.Base<T4, T3, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T5, T6> _156()  {
    return new ITuple3.Base<T1, T5, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 1st, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T1, T6, T5> _165()  {
    return new ITuple3.Base<T1, T6, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T1, T5> _615()  {
    return new ITuple3.Base<T6, T1, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T1> _651()  {
    return new ITuple3.Base<T6, T5, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T1> _561()  {
    return new ITuple3.Base<T5, T6, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _3()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T1, T6> _516()  {
    return new ITuple3.Base<T5, T1, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T5, T6> _256()  {
    return new ITuple3.Base<T2, T5, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 2nd, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T2, T6, T5> _265()  {
    return new ITuple3.Base<T2, T6, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T2, T5> _625()  {
    return new ITuple3.Base<T6, T2, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T2> _652()  {
    return new ITuple3.Base<T6, T5, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T2> _562()  {
    return new ITuple3.Base<T5, T6, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _3()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T2, T6> _526()  {
    return new ITuple3.Base<T5, T2, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T5, T6> _356()  {
    return new ITuple3.Base<T3, T5, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 3rd, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T3, T6, T5> _365()  {
    return new ITuple3.Base<T3, T6, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T3, T5> _635()  {
    return new ITuple3.Base<T6, T3, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T3> _653()  {
    return new ITuple3.Base<T6, T5, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T3> _563()  {
    return new ITuple3.Base<T5, T6, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T3, T6> _536()  {
    return new ITuple3.Base<T5, T3, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T5, T6> _456()  {
    return new ITuple3.Base<T4, T5, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 4th, 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T4, T6, T5> _465()  {
    return new ITuple3.Base<T4, T6, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T4, T5> _645()  {
    return new ITuple3.Base<T6, T4, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _3()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 6th, 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T6, T5, T4> _654()  {
    return new ITuple3.Base<T6, T5, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T6, T4> _564()  {
    return new ITuple3.Base<T5, T6, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _3()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 3-tuple from this one where the elements are ordered: 5th, 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple3<T5, T4, T6> _546()  {
    return new ITuple3.Base<T5, T4, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _3()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T2> _12()  {
    return new ITuple2.Base<T1, T2>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T1> _21()  {
    return new ITuple2.Base<T2, T1>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T3> _13()  {
    return new ITuple2.Base<T1, T3>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T1> _31()  {
    return new ITuple2.Base<T3, T1>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T3> _23()  {
    return new ITuple2.Base<T2, T3>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T2> _32()  {
    return new ITuple2.Base<T3, T2>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T4> _14()  {
    return new ITuple2.Base<T1, T4>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T1> _41()  {
    return new ITuple2.Base<T4, T1>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T4> _24()  {
    return new ITuple2.Base<T2, T4>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T2> _42()  {
    return new ITuple2.Base<T4, T2>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T4> _34()  {
    return new ITuple2.Base<T3, T4>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T3> _43()  {
    return new ITuple2.Base<T4, T3>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T5> _15()  {
    return new ITuple2.Base<T1, T5>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T1> _51()  {
    return new ITuple2.Base<T5, T1>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T5> _25()  {
    return new ITuple2.Base<T2, T5>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T2> _52()  {
    return new ITuple2.Base<T5, T2>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T5> _35()  {
    return new ITuple2.Base<T3, T5>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T3> _53()  {
    return new ITuple2.Base<T5, T3>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T5> _45()  {
    return new ITuple2.Base<T4, T5>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T4> _54()  {
    return new ITuple2.Base<T5, T4>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 1st, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T1, T6> _16()  {
    return new ITuple2.Base<T1, T6>() {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 1st.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T1> _61()  {
    return new ITuple2.Base<T6, T1>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T1 _2()
      {
        return ITuple6.this._1();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 2nd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T2, T6> _26()  {
    return new ITuple2.Base<T2, T6>() {
      @Override
      public T2 _1()
      {
        return ITuple6.this._2();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 2nd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T2> _62()  {
    return new ITuple2.Base<T6, T2>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 3rd, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T3, T6> _36()  {
    return new ITuple2.Base<T3, T6>() {
      @Override
      public T3 _1()
      {
        return ITuple6.this._3();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 3rd.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T3> _63()  {
    return new ITuple2.Base<T6, T3>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T3 _2()
      {
        return ITuple6.this._3();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 4th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T4, T6> _46()  {
    return new ITuple2.Base<T4, T6>() {
      @Override
      public T4 _1()
      {
        return ITuple6.this._4();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 4th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T4> _64()  {
    return new ITuple2.Base<T6, T4>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T4 _2()
      {
        return ITuple6.this._4();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 5th, 6th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T5, T6> _56()  {
    return new ITuple2.Base<T5, T6>() {
      @Override
      public T5 _1()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _2()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Create a new 2-tuple from this one where the elements are ordered: 6th, 5th.
   * @return reordered tuple
   */
  @NotNull
  default ITuple2<T6, T5> _65()  {
    return new ITuple2.Base<T6, T5>() {
      @Override
      public T6 _1()
      {
        return ITuple6.this._6();
      }

      @Override
      public T5 _2()
      {
        return ITuple6.this._5();
      }
    };
  }

  /**
   * Convert this 6-tuple into a {@link ITuple6.Base base tuple} which provides useful implementations for standard methods.
   * @return base view of this tuple
   */
  @NotNull
  default ITuple6.Base<T1, T2, T3, T4, T5, T6> asBase()
  {
    return new Base<T1, T2, T3, T4, T5, T6>()
    {
      @Override
      public T1 _1()
      {
        return ITuple6.this._1();
      }

      @Override
      public T2 _2()
      {
        return ITuple6.this._2();
      }

      @Override
      public T3 _3()
      {
        return ITuple6.this._3();
      }

      @Override
      public T4 _4()
      {
        return ITuple6.this._4();
      }

      @Override
      public T5 _5()
      {
        return ITuple6.this._5();
      }

      @Override
      public T6 _6()
      {
        return ITuple6.this._6();
      }
    };
  }

  /**
   * Convert this into an object of a concrete tuple implementation.
   * This is useful because implementations may just be a view of something else.
   * This method makes sure to decouple the tuple from the viewed object.
   * The resulting tuple may contain {@code null} elements,
   * see {@link #frozenNotNull()} for a method which returns tuples
   * which don't have nullable elements.
   * @return standalone tuple object
   */
  @NotNull
  default NTuple6<T1, T2, T3, T4, T5, T6> frozen()
  {
    return new NTuple6<>(_1(), _2(), _3(), _4(), _5(), _6());
  }

  /**
   * Convert this into an object of a concrete tuple implementation.
   * This is useful because implementations may just be a view of something else.
   * This method makes sure to decouple the tuple from the viewed object.
   * The resulting tuple is guaranteed not to have {@code null}
   * elements, but if this interface has {@code null} elements this method
   * will throw a {@link NullPointerException}.
   *<p>
   * See {@link #frozen()} for a method which will not throw exceptions.
   * @return standalone tuple object
   * @throws NullPointerException if any element of this tuple is {@code null}
   */
  @NotNull
  default Tuple6<T1, T2, T3, T4, T5, T6> frozenNotNull()
  {
    return new Tuple6<>(Objects.requireNonNull(_1(), "_1()"),
                        Objects.requireNonNull(_2(), "_2()"),
                        Objects.requireNonNull(_3(), "_3()"),
                        Objects.requireNonNull(_4(), "_4()"),
                        Objects.requireNonNull(_5(), "_5()"),
                        Objects.requireNonNull(_6(), "_6()"));
  }

  /**
   * Invoke a %d-argument function on this tuple.
   * @param function function called with the unpacked elements of this tuple
   * @param <T> function return type
   * @return result of calling the function
   */
  default <T> T invoke(@NotNull Function6<T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> function)
  {
    return function.apply(_1(), _2(), _3(), _4(), _5(), _6());
  }

  /**
   * Send this tuple unpacked to a 6-argument procedure.
   * @param procedure procedure called with the unpacked elements of this tuple
   */
  default void sendTo(@NotNull Procedure6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> procedure)
  {
    procedure.apply(_1(), _2(), _3(), _4(), _5(), _6());
  }

  /**
   * Test a 6-argument predicate with this tuple unpacked.
   * @param predicate predicate called with the unpacked elements of this tuple
   * @return the predicate's result
   */
  default boolean testBy(@NotNull Predicate6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> predicate)
  {
    return predicate.test(_1(), _2(), _3(), _4(), _5(), _6());
  }

  /**
   * Create a new 6-tuple on the fly.
   * This is especially useful for temporary usage, you might want to create a {@link Tuple6} 
   * instead as that gives guarantees of the non-nullness of its elements, or a {@link NTuple6}
   * as that at least is serializable (as is {@code Tuple6}). 
   * @param elem1 first element of returned tuple
   * @param elem2 second element of returned tuple
   * @param elem3 third element of returned tuple
   * @param elem4 fourth element of returned tuple
   * @param elem5 fifth element of returned tuple
   * @param elem6 sixth element of returned tuple
   * @param <E1> type of first element
   * @param <E2> type of second element
   * @param <E3> type of third element
   * @param <E4> type of fourth element
   * @param <E5> type of fifth element
   * @param <E6> type of sixth element
   * @return 6-tuple view of the given elements
   */
  @NotNull
  static <E1, E2, E3, E4, E5, E6> ITuple6<E1, E2, E3, E4, E5, E6> view(E1 elem1, E2 elem2, E3 elem3, E4 elem4, E5 elem5, E6 elem6)
  {
    return new ITuple6.Base<E1, E2, E3, E4, E5, E6>() {
      @Override
      public E1 _1()
      {
        return elem1;
      }

      @Override
      public E2 _2()
      {
        return elem2;
      }

      @Override
      public E3 _3()
      {
        return elem3;
      }

      @Override
      public E4 _4()
      {
        return elem4;
      }

      @Override
      public E5 _5()
      {
        return elem5;
      }

      @Override
      public E6 _6()
      {
        return elem6;
      }
    };
  }

  /**
   * Basic implementation of equals for 6-tuples.
   * This can be used in implementations to implement {@link Object#equals(Object)}.
   * Don't forget hashing: {@link #hash(ITuple6)}
   * @param tuple tuple to compare
   * @param o     other object to compare
   * @return {@code false} if {@code o} is {@code null}, not a {@code ITuple6}, or its members differ<br>
   *         {@code true} otherwise
   */
  static boolean equals(@NotNull ITuple6<?, ?, ?, ?, ?, ?> tuple, @Nullable Object o)
  {
    if (tuple == o) {
      return true;
    }
    if (!(o instanceof ITuple6)) {
      // null will come here, too
      return false;
    }
    final ITuple6<?, ?, ?, ?, ?, ?> other = (ITuple6<?, ?, ?, ?, ?, ?>)o;
    return Objects.equals(tuple._1(), other._1())  &&  Objects.equals(tuple._2(), other._2())  &&
           Objects.equals(tuple._3(), other._3())  &&  Objects.equals(tuple._4(), other._4())  &&
           Objects.equals(tuple._5(), other._5())  &&  Objects.equals(tuple._6(), other._6());
  }

  /**
   * Basic implementation for calculating a hash code of a 6-tuple.
   * This can be used in implementations to implement {@link Object#hashCode()}.
   * Don't forget equals: {@link #equals(ITuple6, Object)}.
   * @param tuple tuple to hash
   * @return hash code
   */
  static int hash(@NotNull ITuple6<?, ?, ?, ?, ?, ?> tuple)
  {
    return Objects.hash(tuple._1(), tuple._2(), tuple._3(), tuple._4(), tuple._5(), tuple._6());
  }

  /**
   * Basic implementation for creating a string from a 6-tuple.
   * This one uses {@code "ITuple6"} as prefix.
   * This can be used im implementations to implement {@link Object#toString()}.
   * @param tuple tuple to convert
   * @return text form
   * @see #toString(String, ITuple6)
   */
  @NotNull
  static String toString(@NotNull ITuple6<?, ?, ?, ?, ?, ?> tuple)
  {
    return toString("ITuple6", tuple);
  }

  /**
   * Basic implementation for creating a string from a 6-tuple.
   * This can be used im implementations to implement {@link Object#toString()}.
   * @param prefix prefix for the output
   * @param tuple tuple to convert
   * @return text form
   * @see #toString(ITuple6)
   */
  @NotNull
  static String toString(@NotNull String prefix,
                         @NotNull ITuple6<?, ?, ?, ?, ?, ?> tuple)
  {
    return prefix + '(' + tuple._1() +  ',' + tuple._2() +  ',' + tuple._3() +  ',' + tuple._4() +  ',' + tuple._5() +  ',' + tuple._6() +  ')';
  }

  /**
   * Combine a 1-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 1-argument function.
   * @param fn1  1-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 1-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6, R>
  Function<S1, R> concat1(@NotNull Function<S1, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                          @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 1-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 1-argument consumer/procedure.
   * @param fn1    1-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 1-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6>
  Consumer<S1> concatProc1(@NotNull Function<S1, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                           @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1) -> fn1.apply(v1).sendTo(proc2);
  }

  /**
   * Combine a 1-argument function returning a 6-tuple with a 6-parameter predicate into a 1-argument predicate.
   * @param fn1    1-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 1-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, E1, E2, E3, E4, E5, E6>
  Predicate<S1> concatPred1(@NotNull Function<S1, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                            @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1) -> fn1.apply(v1).testBy(pred2);
  }

  /**
   * Combine a 2-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 2-argument function.
   * @param fn1  2-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 2-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6, R>
  BiFunction<S1, S2, R> concat2(@NotNull BiFunction<S1, S2, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                                @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 2-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 2-argument consumer/procedure.
   * @param fn1    2-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 2-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6>
  BiConsumer<S1, S2> concatProc2(@NotNull BiFunction<S1, S2, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                                 @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2) -> fn1.apply(v1, v2).sendTo(proc2);
  }

  /**
   * Combine a 2-argument function returning a 6-tuple with a 6-parameter predicate into a 2-argument predicate.
   * @param fn1    2-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 2-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, E1, E2, E3, E4, E5, E6>
  BiPredicate<S1, S2> concatPred2(@NotNull BiFunction<S1, S2, ? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>> fn1,
                                  @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2) -> fn1.apply(v1, v2).testBy(pred2);
  }

  /**
   * Combine a 3-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 3-argument function.
   * @param fn1  3-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 3-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6, R>
  Function3<R, S1, S2, S3> concat3(@NotNull Function3<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3> fn1,
                                   @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 3-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 3-argument consumer/procedure.
   * @param fn1    3-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 3-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6>
  Procedure3<S1, S2, S3> concatProc3(@NotNull Function3<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3> fn1,
                                     @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3) -> fn1.apply(v1, v2, v3).sendTo(proc2);
  }

  /**
   * Combine a 3-argument function returning a 6-tuple with a 6-parameter predicate into a 3-argument predicate.
   * @param fn1    3-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 3-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, E1, E2, E3, E4, E5, E6>
  Predicate3<S1, S2, S3> concatPred3(@NotNull Function3<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3> fn1,
                                     @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3) -> fn1.apply(v1, v2, v3).testBy(pred2);
  }

  /**
   * Combine a 4-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 4-argument function.
   * @param fn1  4-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 4-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6, R>
  Function4<R, S1, S2, S3, S4> concat4(@NotNull Function4<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4> fn1,
                                       @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 4-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 4-argument consumer/procedure.
   * @param fn1    4-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 4-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6>
  Procedure4<S1, S2, S3, S4> concatProc4(@NotNull Function4<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4> fn1,
                                         @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3, v4) -> fn1.apply(v1, v2, v3, v4).sendTo(proc2);
  }

  /**
   * Combine a 4-argument function returning a 6-tuple with a 6-parameter predicate into a 4-argument predicate.
   * @param fn1    4-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 4-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, E1, E2, E3, E4, E5, E6>
  Predicate4<S1, S2, S3, S4> concatPred4(@NotNull Function4<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4> fn1,
                                         @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3, v4) -> fn1.apply(v1, v2, v3, v4).testBy(pred2);
  }

  /**
   * Combine a 5-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 5-argument function.
   * @param fn1  5-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 5-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6, R>
  Function5<R, S1, S2, S3, S4, S5> concat5(@NotNull Function5<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5> fn1,
                                           @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 5-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 5-argument consumer/procedure.
   * @param fn1    5-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 5-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6>
  Procedure5<S1, S2, S3, S4, S5> concatProc5(@NotNull Function5<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5> fn1,
                                             @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3, v4, v5) -> fn1.apply(v1, v2, v3, v4, v5).sendTo(proc2);
  }

  /**
   * Combine a 5-argument function returning a 6-tuple with a 6-parameter predicate into a 5-argument predicate.
   * @param fn1    5-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 5-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, E1, E2, E3, E4, E5, E6>
  Predicate5<S1, S2, S3, S4, S5> concatPred5(@NotNull Function5<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5> fn1,
                                             @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3, v4, v5) -> fn1.apply(v1, v2, v3, v4, v5).testBy(pred2);
  }

  /**
   * Combine a 6-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 6-argument function.
   * @param fn1  6-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 6-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6, R>
  Function6<R, S1, S2, S3, S4, S5, S6> concat6(@NotNull Function6<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6> fn1,
                                               @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 6-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 6-argument consumer/procedure.
   * @param fn1    6-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 6-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6>
  Procedure6<S1, S2, S3, S4, S5, S6> concatProc6(@NotNull Function6<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6> fn1,
                                                 @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3, v4, v5, v6) -> fn1.apply(v1, v2, v3, v4, v5, v6).sendTo(proc2);
  }

  /**
   * Combine a 6-argument function returning a 6-tuple with a 6-parameter predicate into a 6-argument predicate.
   * @param fn1    6-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 6-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, E1, E2, E3, E4, E5, E6>
  Predicate6<S1, S2, S3, S4, S5, S6> concatPred6(@NotNull Function6<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6> fn1,
                                                 @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3, v4, v5, v6) -> fn1.apply(v1, v2, v3, v4, v5, v6).testBy(pred2);
  }

  /**
   * Combine a 7-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 7-argument function.
   * @param fn1  7-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 7-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <S7> seventh argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6, R>
  Function7<R, S1, S2, S3, S4, S5, S6, S7> concat7(@NotNull Function7<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                   @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 7-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 7-argument consumer/procedure.
   * @param fn1    7-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 7-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6>
  Procedure7<S1, S2, S3, S4, S5, S6, S7> concatProc7(@NotNull Function7<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                     @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3, v4, v5, v6, v7) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7).sendTo(proc2);
  }

  /**
   * Combine a 7-argument function returning a 6-tuple with a 6-parameter predicate into a 7-argument predicate.
   * @param fn1    7-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 7-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, E1, E2, E3, E4, E5, E6>
  Predicate7<S1, S2, S3, S4, S5, S6, S7> concatPred7(@NotNull Function7<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7> fn1,
                                                     @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3, v4, v5, v6, v7) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7).testBy(pred2);
  }

  /**
   * Combine a 8-argument function returning a 6-tuple with a 6-parameter function returning another result value
   * into one 8-argument function.
   * @param fn1  8-argument function returning a 6-tuple
   * @param fn2  6-argument function which can use the expanded tuple elements as arguments and returns the result value 
   * @return 8-argument function which returns the result value 
   * @param <S1> first argument of incoming function {@code fn1} and returned function
   * @param <S2> second argument of incoming function {@code fn1} and returned function
   * @param <S3> third argument of incoming function {@code fn1} and returned function
   * @param <S4> fourth argument of incoming function {@code fn1} and returned function
   * @param <S5> fifth argument of incoming function {@code fn1} and returned function
   * @param <S6> sixth argument of incoming function {@code fn1} and returned function
   * @param <S7> seventh argument of incoming function {@code fn1} and returned function
   * @param <S8> eighth argument of incoming function {@code fn1} and returned function
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   * @param <R> result type
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6, R>
  Function8<R, S1, S2, S3, S4, S5, S6, S7, S8> concat8(@NotNull Function8<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                       @NotNull Function6<R, ? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> fn2)
  {
    return fn1.andThen(tuple -> tuple.invoke(fn2));
  }

  /**
   * Combine a 8-argument function returning a 6-tuple with a 6-parameter consumer/procedure into a 8-argument consumer/procedure.
   * @param fn1    8-argument function returning a 6-tuple
   * @param proc2  6-argument consumer/procedure which can use the expanded tuple elements as arguments 
   * @return 8-argument consumer/procedure which returns the result value 
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <S8> eighth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6>
  Procedure8<S1, S2, S3, S4, S5, S6, S7, S8> concatProc8(@NotNull Function8<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                         @NotNull Procedure6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> proc2)
  {
    return (v1, v2, v3, v4, v5, v6, v7, v8) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7, v8).sendTo(proc2);
  }

  /**
   * Combine a 8-argument function returning a 6-tuple with a 6-parameter predicate into a 8-argument predicate.
   * @param fn1    8-argument function returning a 6-tuple
   * @param pred2  6-argument predicate which can use the expanded tuple elements as arguments 
   * @return 8-argument predicate which returns the test result of the tuple returned by {@code fn1}
   * @param <S1> first argument of function and returned consumer/procedure
   * @param <S2> second argument of function and returned consumer/procedure
   * @param <S3> third argument of function and returned consumer/procedure
   * @param <S4> fourth argument of function and returned consumer/procedure
   * @param <S5> fifth argument of function and returned consumer/procedure
   * @param <S6> sixth argument of function and returned consumer/procedure
   * @param <S7> seventh argument of function and returned consumer/procedure
   * @param <S8> eighth argument of function and returned consumer/procedure
   * @param <E1> type of first element of intermediate tuple 
   * @param <E2> type of second element of intermediate tuple 
   * @param <E3> type of third element of intermediate tuple 
   * @param <E4> type of fourth element of intermediate tuple 
   * @param <E5> type of fifth element of intermediate tuple 
   * @param <E6> type of sixth element of intermediate tuple 
   */
  @NotNull
  static <S1, S2, S3, S4, S5, S6, S7, S8, E1, E2, E3, E4, E5, E6>
  Predicate8<S1, S2, S3, S4, S5, S6, S7, S8> concatPred8(@NotNull Function8<? extends ITuple6<? extends E1, ? extends E2, ? extends E3, ? extends E4, ? extends E5, ? extends E6>, S1, S2, S3, S4, S5, S6, S7, S8> fn1,
                                                         @NotNull Predicate6<? super E1, ? super E2, ? super E3, ? super E4, ? super E5, ? super E6> pred2)
  {
    return (v1, v2, v3, v4, v5, v6, v7, v8) -> fn1.apply(v1, v2, v3, v4, v5, v6, v7, v8).testBy(pred2);
  }

  /**
   * Abstract base implementation of a 6-tuple.
   * This provides standard implementations for {@code java.lang.Object} methods
   * {@code equals()}, {@code hashCode()} and {@code toString()}. Therefore it is
   * most useful if you implement a 6-tuple on the fly.
   * @param <T1> type of first element
   * @param <T2> type of second element
   * @param <T3> type of third element
   * @param <T4> type of fourth element
   * @param <T5> type of fifth element
   * @param <T6> type of sixth element
   */
  abstract class Base<T1, T2, T3, T4, T5, T6> implements ITuple6<T1, T2, T3, T4, T5, T6>
  {
    @NotNull
    @Override
    public Base<T1, T2, T3, T4, T5, T6> asBase()
    {
      return this;
    }

    @Override
    public int hashCode()
    {
      return ITuple6.hash(this);
    }

    @Override
    public boolean equals(Object obj)
    {
      return ITuple6.equals(this, obj);
    }

    @Override
    public String toString()
    {
      return ITuple6.toString(this);
    }
  }
}
