// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.matcher;

import de.caff.generics.UniformMatcher;

/**
 * A matcher which inverts the direction of comparison of a wrapped matcher.
 * <p>
 * Basically the equality relation should be reflexive, but there are good reasons
 * to not obey this rule in a class hierarchy.
 * <p>
 * How this matcher handles {@code null} values depends on the wrapped matcher.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @see de.caff.generics.matcher.Match#revert(de.caff.generics.Matcher)
 */
public class RevertedUniformMatcher<T>
        implements UniformMatcher<T>
{
  /** The wrapped matcher. */
  private final UniformMatcher<T> matcher;

  /**
   * Constructor.
   * @param matcher wrapped matcher
   */
  public RevertedUniformMatcher(UniformMatcher<T> matcher)
  {
    this.matcher = matcher;
  }

  /**
   * Are the given two objects considered equal?
   *
   * @param object1 object 1
   * @param object2 object 2
   * @return {@code true} if this matcher considers the two object equals<br>
   *         {@code false} if this matcher considers them different
   */
  @Override
  public boolean areEqual(T object1, T object2)
  {
    return matcher.areEqual(object2, object1);
  }
}
