// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.matcher;

import de.caff.generics.UniformMatcher;

/**
 * A matcher which considers two comparable objects equals if they
 * compare with result {@code 0}.
 * <p>
 * Indeed the {@link Comparable#compareTo(Object)} method of object 1 is used.
 * <p>
 * This matcher does not allow {@code null} values.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class ComparableMatcher<T extends Comparable<T>>
        implements UniformMatcher<T>
{
  /**
   * Are the given two objects considered equal?
   *
   * @param object1 object 1
   * @param object2 object 2
   * @return <code>true</code> if this matcher considers the two object equals<br>
   *         <code>false</code> if this matcher considers them different
   */
  @Override
  public boolean areEqual(T object1, T object2)
  {
    return object1.compareTo(object2) == 0;
  }
}
