// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.handler;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;

import java.util.function.Predicate;

/**
 * A converting loop item handler which filters the converted items.
 * You should prefer using one of {@link de.caff.generics.Types}' filter
 * methods instead of this class.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @see de.caff.generics.handler.ConvertingLoopItemHandler
 * @see de.caff.generics.handler.DeletingLoopItemHandler
 * @see de.caff.generics.handler.MultiConvertingLoopItemHandler
 * @see de.caff.generics.handler.ConvertingFragileLoopItemHandler
 * @see de.caff.generics.handler.DeletingFragileLoopItemHandler
 * @see de.caff.generics.handler.MultiConvertingFragileLoopItemHandler
 */
public abstract class FilteringLoopItemHandler<T>
        extends DeletingLoopItemHandler<T, T>
{
  /**
   * Constructor.
   * @param checker checker to use for filtering
   * @param deleteMark delete mark
   */
  public FilteringLoopItemHandler(@NotNull final Predicate<T> checker,
                                  @Nullable final T deleteMark)
  {
    super(arg -> checker.test(arg) ? arg: deleteMark, deleteMark);
  }

  /**
   * Constructor.
   * This uses {@code null} as delete mark.
   * @param checker checker to use for filtering
   */
  public FilteringLoopItemHandler(@NotNull Predicate<T> checker)
  {
    this(checker, null);
  }
}
