// ============================================================================
// File:               ToShortFunction
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            31.01.22 15:13
//=============================================================================
package de.caff.generics.function;

/**
 * A function which produces a short value from a generic value.
 * 
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 31, 2022
 */
@FunctionalInterface
public interface ToShortFunction<T>
{
  /**
   * Apply this function to the given value.
   * @param value function argument
   * @return short result
   */
  short applyAsShort(T value);
}
