// ============================================================================
// File:               ToByteFunction
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            31.01.22 15:13
//=============================================================================
package de.caff.generics.function;

/**
 * A function which produces a byte value from a generic value.
 *
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since January 31, 2022
 */
@FunctionalInterface
public interface ToByteFunction<T>
{
  /**
   * Apply this function to the given value.
   * @param value function argument
   * @return byte result
   */
  byte applyAsByte(T value);
}
