// ============================================================================
// File:               LongSetter
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            7/14/22 10:10 AM
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Procedure with a generic and a long argument.
 * <p>
 * Especially useful for handling setting properties which have a long
 * value.
 * <pre>{@code
 * class A
 * {
 *   private long value;
 *
 *   public long getValue()
 *   {
 *     return value;
 *   }
 *
 *   public void setValue(long value)
 *   {
 *     this.value = value;
 *   }
 * }
 * // [...]
 * LongSetter<A> valueSetter = A::setValue;
 * }</pre>
 *
 * The other way round, i.e. a {@code LongGetter}, is already
 * provided by the standard library: see {@link java.util.function.ToLongFunction}.
 *
 * @param <T> generic type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since July 14, 2022
 */
@FunctionalInterface
public interface LongSetter<T>
{
  /**
   * Handle an item and a long value.
   * In the expected use scenario this sets the value to the given item.
   * @param item   item
   * @param value  value
   */
  void set(@NotNull T item, long value);
}
