// ============================================================================
// File:               IntFunction2
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 13:37
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Function with two primitive integer arguments and a primitive long result.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntToLongFunction2
{
  /**
   * Apply this function to the given 2 arguments.
   * @param value1 first argument
   * @param value2 second argument
   * @return the function result
   */
  long applyAsLong(int value1, int value2);

  /**
   * View this as a 2 {@code int} to {@code double} function.
   * @return int to double function, due to precision restrictions sometimes
   *         not returning the original integral {@code long} values but
   *         an approximation
   */
  @NotNull
  default IntToDoubleFunction2 asIntToDoubleFunction()
  {
    return this::applyAsLong;
  }
}
