// ============================================================================
// File:               IntFunction2
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 13:37
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Function with two primitive integer arguments and a primitive float result.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntToFloatFunction2
{
  /**
   * Apply this function to the given 2 arguments.
   * @param value1 first argument
   * @param value2 second argument
   * @return the function result
   */
  float applyAsFloat(int value1, int value2);

  /**
   * View this function as one with 1 argument using a fix first argument.
   * @param value1 fix first argument
   * @return function expecting the remaining argument
   */
  @NotNull
  default IntToFloatFunction1 partial1(int value1)
  {
    return v2 -> applyAsFloat(value1, v2);
  }

  /**
   * View this function as one with 1 argument using a fix second argument.
   * @param value2 fix second argument
   * @return function expecting the remaining argument
   */
  @NotNull
  default IntToFloatFunction1 partial2(int value2)
  {
    return v1 -> applyAsFloat(v1, value2);
  }

  /**
   * View this as a 2 {@code int} to {@code double} function.
   * @return int to double function which will return integral values between
   *         {@code -128.0} to {@code 127.0}
   */
  @NotNull
  default IntToDoubleFunction2 asIntToDoubleFunction()
  {
    return this::applyAsFloat;
  }
}
