// ============================================================================
// File:               IntToByteFunction1
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 11:59
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

import java.util.function.IntToDoubleFunction;

/**
 * Function with one primitive integer argument and a primitive flaat return.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntToFloatFunction1
{
  /**
   /**
   * Applies this function to the given argument.
   *
   * @param value the function argument
   * @return the function result
   */
  float applyAsFloat(int value);

  /**
   * View this as an {@code int} to {@code double} function.
   * @return int to double function which will return floating point values
   */
  @NotNull
  default IntToDoubleFunction asIntToDoubleFunction()
  {
    return this::applyAsFloat;
  }
}
