// ============================================================================
// File:               IntFunction2
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 13:37
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Function with three primitive integer arguments and a primitive double result.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntToDoubleFunction3
{
  /**
   * Apply this function to the given 3 arguments.
   * @param value1 first argument
   * @param value2 second argument
   * @param value3 third argument
   * @return the function result
   */
  double applyAsDouble(int value1, int value2, int value3);

  /**
   * View this function as one with 2 arguments using a fix first argument.
   * @param value1 fix first argument
   * @return function expecting the remaining 2 arguments in order
   */
  @NotNull
  default IntToDoubleFunction2 partial1(int value1)
  {
    return (v2, v3) -> applyAsDouble(value1, v2, v3);
  }

  /**
   * View this function as one with 2 arguments using a fix second argument.
   * @param value2 fix second argument
   * @return function expecting the remaining 2 arguments in order
   */
  @NotNull
  default IntToDoubleFunction2 partial2(int value2)
  {
    return (v1, v3) -> applyAsDouble(v1, value2, v3);
  }

  /**
   * View this function as one with 2 arguments using a fix third argument.
   * @param value3 fix third argument
   * @return function expecting the remaining 2 arguments in order
   */
  @NotNull
  default IntToDoubleFunction2 partial3(int value3)
  {
    return (v1, v2) -> applyAsDouble(v1, v2, value3);
  }
}
