// ============================================================================
// File:               IntFunction2
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 13:37
//=============================================================================
package de.caff.generics.function;

/**
 * Function with three integer arguments and generic result.
 * @param <T> tye of the result of this function
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntFunction3<T>
{
  /**
   * Apply this function to the given 3 arguments.
   * @param value1 first argument
   * @param value2 second argument
   * @param value3 third argument
   * @return the function result
   */
  T applyAsInt(int value1, int value2, int value3);
}
