// ============================================================================
// File:               IntFunction2
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2020-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            27.11.20 13:37
//=============================================================================
package de.caff.generics.function;

/**
 * Function with two integer arguments and generic result.
 * @param <T> tye of the result of this function
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since November 27, 2020
 */
@FunctionalInterface
public interface IntFunction2<T>
        extends Function2<T, Integer, Integer>
{
  /**
   * Apply this function to the given 2 arguments.
   * @param value1 first argument
   * @param value2 second argument
   * @return the function result
   */
  T applyAsInt(int value1, int value2);

  /**
   * Default implementation.
   * This uses {@link #applyAsInt(int, int)}.
   * @param v1 first argument
   * @param v2 second argument
   * @return result value
   * @throws NullPointerException if either argument is {@code null}
   */
  @Override
  default T apply(Integer v1, Integer v2)
  {
    return applyAsInt(v1, v2);
  }
}
