// ============================================================================
// File:               CharFunction
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2021-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            19.10.21 13:30
//=============================================================================
package de.caff.generics.function;

/**
 * Function which has a primitive character as input,
 * and an object as output.
 * @param <T> output type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since October 19, 2021
 */
@FunctionalInterface
public interface CharFunction1<T>
{
  /**
   * Convert a character into something else.
   * @param ch character
   * @return converted character
   */
  T applyAsChar(char ch);
}
