// ============================================================================
// File:               ByteSetter
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            7/14/22 10:10 AM
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Procedure with a generic and a byte argument.
 * <p>
 * Especially useful for handling setting properties which have a byte
 * value.
 * <pre>{@code
 * class A
 * {
 *   private byte value;
 *
 *   public byte getValue()
 *   {
 *     return value;     
 *   }
 *
 *   public void setValue(byte value)
 *   {
 *     this.value = value;
 *   }
 * }
 * // [...]
 * ByteSetter<A> valueSetter = A::setValue;
 * }</pre>
 *
 * The other way round, i.e. a {@code ByteGetter}, is provided
 * by {@link ToByteFunction}.
 *
 * @param <T> generic type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since July 14, 2022
 */
@FunctionalInterface
public interface ByteSetter<T>
{
  /**
   * Handle an item and a byte value.
   * In the expected use scenario this sets the value to the given item. 
   * @param item   item
   * @param value  value
   */
  void set(@NotNull T item, byte value);
}
