// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2020-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.function;

/**
 * Function which has two primitive bytes as input,
 * and an object as output.
 * @param <T> output type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since October 19, 2021
 */
@FunctionalInterface
public interface ByteFunction2<T>
        extends Function2<T, Byte, Byte>
{
  /**
   * Convert two bytes into something else.
   * @param ch1 first byte
   * @param ch2 second byte
   * @return converted byte
   */
  T applyAsByte(byte ch1, byte ch2);

  /**
   * Default implementation.
   * This uses {@link #applyAsByte(byte, byte)}.
   * @param v1 first argument
   * @param v2 second argument
   * @return result value
   * @throws NullPointerException if either argument is {@code null}
   */
  @Override
  default T apply(Byte v1, Byte v2)
  {
    return applyAsByte(v1, v2);
  }
}
