// ============================================================================
// File:               CharFunction
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2021-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            19.10.21 13:30
//=============================================================================
package de.caff.generics.function;

/**
 * Function which has a primitive byte as input,
 * and an object as output.
 * @param <T> output type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since April 22, 2022
 */
@FunctionalInterface
public interface ByteFunction1<T>
{
  /**
   * Convert a byte into something else.
   * @param v byte value
   * @return converted byte
   */
  T applyAsByte(byte v);
}
