// ============================================================================
// File:               BooleanSetter
//
// Project:            CAFF
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   © 2022-2024  Rammi (rammi@caff.de)
//                     The usage of this source code in commercial or open 
//                     source projects is not allowed without explicit 
//                     permission.
//
// Created:            7/14/22 10:10 AM
//=============================================================================
package de.caff.generics.function;

import de.caff.annotation.NotNull;

/**
 * Procedure with a generic and a boolean argument.
 * <p>
 * Especially useful for handling setting properties which have a boolean
 * value.
 * <pre>{@code
 * class A
 * {
 *   private boolean value;
 *
 *   public boolean getValue()
 *   {
 *     return value;     
 *   }
 *
 *   public void setValue(boolean value)
 *   {
 *     this.value = value;
 *   }
 * }
 * // [...]
 * BooleanSetter<A> valueSetter = A::setValue;
 * }</pre>
 *
 * The other way round, i.e. a {@code BooleanGetter}, is already provided
 * by standard library interface {@link java.util.function.Predicate}.
 *
 * @param <T> generic type
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @since July 14, 2022
 */
@FunctionalInterface
public interface BooleanSetter<T>
{
  /**
   * Handle an item and a boolean value.
   * In the expected use scenario this sets the value to the given item. 
   * @param item   item
   * @param value  value
   */
  void set(@NotNull T item, boolean value);
}
