// ============================================================================
// COPYRIGHT NOTICE
// ----------------------------------------------------------------------------
// (This is the open source ISC license, see
// http://en.wikipedia.org/wiki/ISC_license
// for more info)
//
// Copyright © 2012-2024  Andreas M. Rammelt <rammi@caff.de>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//=============================================================================
// Latest version on https://caff.de/projects/decaff-commons/
//=============================================================================
package de.caff.generics.converter;

import de.caff.generics.ReferenceCreator;
import de.caff.generics.function.Function1;

import java.lang.ref.Reference;

/**
 * Type converter which wraps the object with an reference.
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 */
public class ReferencingTypeConverter<T, R extends Reference<? super T>>
        implements Function1<R, T>
{
  private final ReferenceCreator<R, T> referenceCreator;

  /**
   * Constructor.
   * @param referenceCreator reference creator
   */
  public ReferencingTypeConverter(ReferenceCreator<R, T> referenceCreator)
  {
    this.referenceCreator = referenceCreator;
  }

  /**
   * Convert an object to another type.
   *
   * @param object object to convert
   * @return target object
   */
  @Override
  public R apply(T object)
  {
    return referenceCreator.createReference(object);
  }
}
